# Workshop: Android malware reverse engineering

This workshop explains how to reverse engineer Android malware. After some brief explanation, attendees will be provided with a few recent samples such as `Android/SpyBanker` (May 2016), `Android/Xiny` (May 2016) or `Riskware/InnerSnail` (June 2016). They will learn how to reverse those, step by step.

The course will be split in two parts:

* The first part covers the “basics” - which are sufficient to handle most samples. Duration: 2 hours
* The second part dives into more advanced consideration such as dealing with obfuscated or packed samples. Duration: 1 hour.

You may attend either session, or both!

Attendees bring their own laptop, pre-installed with either VirtualBox or docker. It greatly helps if they pre-install the lab before the workshop sessions:

**REQUIREMENTS:**

* 64 bit laptop
* Internet connection
* be at ease with Unix commands

**DOCKER OPTION:**

* Install it
* Install ssh and/or vncviewer on your host
* Pull the lab’s container: docker pull cryptax/android-re
* Test:
    - open a terminal
    - run: `docker run -d –name workshop-test -p 5022:22 -p 5900:5900 cryptax/android-re`
    - run: `vncviewer 127.0.0.1::5900 with password: rootpass`
    - in the docker container, run: `emulator & wait` and ensure the Android emulator opens up correctly

**or VIRTUAL BOX OPTION:**

* Install VirtualBox
* Get the lab’s appliance (5GB)
* Test:
* Connect to appliance with password: rootpass
* Open a terminal, run: emulator & wait and ensure the Android emulator opens up correctly.