[Nuclear fusion. Who's gonna win the race ITER or other alternatives like helion, tri alpha, polywell, lockheed Martin…? - Quora](https://www.quora.com/Nuclear-fusion-Whos-gonna-win-the-race-ITER-or-other-alternatives-like-helion-tri-alpha-polywell-lockheed-Martin)

> I used to work on fusion simulation codes (particle in cell) with the US National Labs when I was at NVIDIA, and I was very interested in seeing if we could solve the problems with fusion and picked the scientist and engineers' brains endlessly. My former father-in-law also worked at Lawrence Berkeley Labs, and was an engineer designing superconducting coil magnets and had decades of experience working with fusion researchers, even though his primary application was particle accelerators. From having many long conversations with these very intelligent and qualified people I realized that there are some really hard problems that block practical fusion, with no immediate solutions in sight.
> 
> The only place we know of working, large-scale, energy-generating fusion reactions is at the center of a star, where the gravity of the massive star creates the necessary density, temperature, and time being held in that state at the core for fusion reactions to run continuously. This is called the Lawson criteria, and is hard to achieve. All of the layers of the star above that act as an energy exchanger, converting all the gamma rays and fast neutrons at the core into progressively less energetic wavelengths of light and motion of nuclei (heat) so by the time they reach the surface of the star, that energy is emitted as IR and visible light that heats and powers our planet's biosphere, and can provide photovoltaic energy to us as well. All of our efforts in fusion have been to try and reproduce this process on earth, in a small reactor that can provide practical energy.
> 
> First I will talk about Magnetic Confinement Fusion, which (in the Tokamak configuration) has a donut-shaped fusion chamber surrounded by magnetic coils that generate a very strong magnetic field that compresses and contains a hot, burning plasma, and is there to keep it at the right density and temperature for long enough for fusion reactions to occur.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-778d7d6c7b0aceb93f69b71759a633b8-lq)
> 
> The first problem with magnetic confinement is fundamental - no matter how strong or well formed the magnetic field containing the plasma is, it will always leak, as positive nuclei or ions spiralling around the magnetic field lines collide and scatter, eventually drifting out of the containment field. The only known solution is to make the reactor larger so the scattering ions take longer to travel to the plasma boundary, and thus more fusion can happen during that time. Pretty brute force.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-aa203f0fa9fbb5ed1b1ba1a51bb3c738-lq)
> 
> The world's most advanced magnetic confinement fusion power plant is ITER, which, to reduce the ion scattering problem mentioned above, is 6-stories tall and about the same dimension in diameter, containing the mass of 3 Eiffel towers, and it is still not expected to be large enough to contain a plasma long enough to sustain burning and produce continuous energy generation.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-9116aa70834334cf73c3eeaed9fef0a6-lq)
> 
> A more practical problem is how do we extract the energy? Most of the energy in deuterium-tritium fusion reactions is released in fast, high-energy neutrons, which (because they are neutral, and have no electric charge) are not confined by the magnetic field, don't heat up the plasma, and have to be stopped by a thick shield, which then heats up, and can vaporize water to steam in order to power turbines and electrical generators. The problem is the constant bombardment by neutrons makes the shield material degrade with time, and become very radioactive, posing a problem for removal and disposal.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-38b470bb2f8531c72989b1b3f7dd7102-lq)
> 
> Also, deuterium-tritium fusion reactions are currently used because they take place at the lowest energies and at the lowest plasma temperatures of all the possible fusion fuels, and thus are easier to ignite and keep lit. However, tritium is not found naturally in any significant quantities and needs to be manufactured in nuclear reactors. With today's production capacity, we just cannot make enough tritium to power even ITER continuously. We could use better fuels, like Helium-3 or Boron-11, which do not emit neutrons and thus 'burn clean', but the plasma temperature must be much higher and the confinement much better to ignite fusion and sustain it with these fuels. And while Boron-11 is plentiful, Helium-3 is so rare that scientists think that the best source of it is lunar regolith that has been irradiated for billions of years on the moon's surface. Any energy generation infrastructure that requires a regular supply of a moon-based fuel, even as energy dense as He3, will probably never work out.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-fc869605ded8aec26205040e6681c3af-lq)
> 
> A proposed solution to the Tritium deficit is to construct the shield surrounding the reactor with lithium, which is abundant, and fissions into tritium when struck by neutrons, thereby 'breeding' tritium within the reactor itself. Of course, this comes with its own set of problems of how to capture, purify, and contain the tritium after it is released into the tokamak reaction chamber from the walls.
> 
> Another issue is that when all of the superconducting magnets in ITER are running at full current (160,000 amps) to create the 13 Tesla toroidal magnetic field (13x that in an MRI machine) and to create the other plasma-shaping and heating fields, they are storing 60 GigaJoules, or around 12 Tons of TNT worth of energy. This is because the 180 kilometers of superconducting Niobium-Tin wires in all these massive magnet coils can carry enormous electrical current when supercooled with liquid helium.
> 
> More info on the ITER magnets: [http://snf.ieeecsc.org/sites/ieeecsc.org/files/ST284.pdf](http://snf.ieeecsc.org/sites/ieeecsc.org/files/ST284.pdf "snf.ieeecsc.org")
> 
> But, if that cooling fails, the superconductor heats up, quenches, and becomes a normal conductor, and can no longer carry that enormous current. With 160,000 amps suddenly meeting resistance, the coil rapidly vaporizes, and causes a meltdown of the other coils, with a total energy release of 12 tons of TNT. This is very undesirable, especially when those coils are wrapped around a highly radioactive shield that also vaporizes and is expelled into the atmosphere. There are fault-detection systems, but it takes a while to dissipate that amount of energy safely, and there may not be enough time to react quickly enough in the event of a catastrophic magnet coil failure.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-4f5d2989b396e23c9164ddf1a2994709-lq)
> 
> So, some gotchas left to solve for practical fusion energy generation with magnetic confinement, with some perhaps not so easily solved.
> 
> Inertial confinement fusion is when powerful lasers are focused in on a tiny pellet of deuterium fuel to compress it very quickly and cause it to reach the required temperature and density (Lawson criteria) needed to undergo fusion, in the same manner as a thermonuclear weapon (or H-Bomb), but on a much smaller scale. However, there are fundamental problems with imploding the deuterium fuel pellet evenly, as the plasma becomes very unstable once compression starts, and unless the laser beams used are perfectly aligned and perfectly even (or flat), it is kind of like squeezing Jello with your fingers, and the plasma kind of bulges out where the lasers are slightly less intense, and it does not reach the ignition criteria before is is squeezed out of the gaps.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-64636a6eeab8ac94052a389df73f4d19-lq)
> 
> It also has many of the same problems with energy conversion to electricity, and much worse wear and tear on the shielding from these small nuclear fusion explosions being set off, which also trashes all the precision equipment needed to hold the fuel pellet in the focus of the converging laser beams with extreme accuracy. So, a lot of practical damage control problems before inertial confinement fusion is a practical source of energy generation.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-4a739da7a06226bca637376b37c68b74-lq)
> 
> While these problems may be solved, practical application is still a very long way off, and currently the main application of inertial confinement fusion is as an experimental testbed for calibrating computer codes used to simulate and design thermonuclear fusion weapons. As horrific as these weapons may be, the simulation codes developed for designing them (sorry maintaining them), are the one of the greatest tools for innovation in fusion energy. There is a hydrodynamics code which simulates the behavior of the fissile (and fusion) materials under extreme conditions of pressure and temperature, as well as transport codes that model neutron transport and scattering in the materials under these conditions, and many other bits and bobs. They are all standard numerical techniques, and the really classified part is the integration and calibration of all these codes with previous nuclear weapon tests from the past, and with these small scale simulations in the present.
> 
> Electrostatic Confinement Fusion: THE most interesting, tantalizing, and simplest fusion reactor to make is an inertial electrostatic confinement fusion reactor, or Farnsworth-Hirsch [fusor](https://en.wikipedia.org/wiki/Fusor "en.wikipedia.org")
> 
> . You can literally build them in a home lab and demonstrate fusion. Kids have shown them at science fairs (maybe with a bit of Dad’s help).
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-27dbc1f74ec34da6a68b152875ac7ff6-lq)
> 
> Basically you need a vacuum container the size of a basketball and a pump to empty it. You put a small spherical wire cage the size of a golf ball in the center, and a larger wire cage the size of a bowling ball around it. You then pump out all the air, and apply a very large (10,000V) electrical potential between the two cages, with the small negative cathode at the center, and the positive anode at the periphery.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-4064060258ed7c7129168bf4b11f6015-pjlq)
> 
> Then you open a valve and let in a very small amount of Deuterium gas (commercially available) into the vacuum chamber, and it ionizes in the large voltage potential, the D+ ions in the periphery experience a very strong electric field (100K V/m), and are rapidly accelerated towards the center of the reactor, with enough energy to collide and fuse the deuterium nuclei (no tritium required). This fusion can be measured with an external neutron counter.
> 
> Theoretically, power generation would be simple, as the fusion products consisting of highly energetic He3 and (few) H3 ions could be decelerated in an electric field and the current from that used to generate electricity directly.
> 
> Here is ECG Herman’s excellent thesis paper on designing and constructing a Farnsworth Fusor: [https://pure.tue.nl/ws/files/46932494/759014-1.pdf](https://pure.tue.nl/ws/files/46932494/759014-1.pdf "pure.tue.nl")
> 
> Although they seem like a obvious winners due to their simplicity and effectiveness, ECF reactors have several things limiting scaling:
> 
> a) There is a limit to the deuterium gas density before performance degrades, so generation capacity is limited.
> 
> b) Deuterium ions tend to collide with the wire cage cathode in the center, which absorbs them, heating the cage, and causing energy loss and contamination from metal atoms being dislodged.
> 
> c) As the deuterium ions oscillate back and forth through the center, each time they change direction, they emit bremsstrahlung radiation, or photons of light, losing energy (this is how your dentist’s x-ray machine works).
> 
> d) Scattering tends to reduce the nice, radial trajectories of the ions into a Maxwellian distribution over time, reducing the fusion that occurs.
> 
> There has been work in using electromagnets at the periphery to try and hold a ball of electrons in the center, eliminating the need for a central cage… aka [Bussard](https://en.wikipedia.org/wiki/Robert_W._Bussard "en.wikipedia.org")
> 
> 's [Polywell](https://en.wikipedia.org/wiki/Polywell "en.wikipedia.org")
> 
> system. A company called EC3 was trying to continue his work, but no commercial success ever resulted, mostly due to a), c), and d) still limiting it. Maxwellian re-distribution of ion trajectories is the bane of much of plasma fusion physics, more so for ECF researchers.
> 
> Thermonuclear Weapons: To address the elephant in the room, thermonuclear weapons are the only really successful implementation of large-scale fusion energy release that humans have mastered. The massive, immediate, multi-megaton TNT energy release and resulting catastrophic damage and radioactive fallout precludes any use in generating energy (or really anything useful for that matter), but understanding the physics is fundamental to understanding the enormous energies and conditions necessary to induce large-scale fusion.
> 
> ![](https://qph.cf2.quoracdn.net/main-qimg-209839be25be10ef5caebf8493c2f2ff-lq)
> 
> In the Teller-Ulam, two-stage, thermonuclear weapon, a spherical plutonium fission primary (with deuterium-tritium fusion fuel at the core to boost it) is imploded by conventional explosives, the plutonium is crushed far beyond critical density, fissions and detonates. The initial radiation released is contained and focused onto the fusion secondary to implode it, ignite fusion, and detonate it. I just mention this to illustrate the enormous energy needed to really reach the Lawson criteria in a large scale, but nuclear weapons kind of freak me out, so I'm going to refer you to the link to the Wikipedia article about them if you want to read more:
> 
> [Thermonuclear weapon - Wikipedia](https://en.m.wikipedia.org/wiki/Thermonuclear_weapon "en.m.wikipedia.org")
> 
> So, in summary, we should not shut down or stop building today's fission nuclear reactors, as commercial fusion reactors are not only far in the future, but also produce radioactive waste (their shielding, which needs to be periodically replaced), and Tokamaks can melt down catastrophically and explode if there is a cooling failure in the magnet coils during full power operation. They also do not run on seawater, like some say. We need expensive and difficult to produce tritium (which is also radioactive) to ignite fusion at the temperatures and densities that today's tokamak magnetic fields can produce.
> 
> To advance fusion energy in your career, I think the best fields to study would be physics (classical, electrodynamics, plasma, quantum, nuclear…) and computer science, with a focus on numerical simulation. The actual physical fusion reactors are so expensive and time-consuming to build, test, and operate, that you may only get to iterate designs once or twice in a career, but computer simulations can take us in so many different directions more cheaply and easily by comparison.
> 
> Perhaps there is some exotic stellarator magnetic confinement design, or advanced Farnsworth electrostatic confinement design that has not been explored in depth, that will turn out to hold the key to fusion energy. Simulation is probably the best first step to find it, unless you have a few billion dollars and several hundred kilometers of Niobium-Tin wire and helium cooling tubing to play with.

---
+ [Nuclear fusion. Who's gonna win the race ITER or other alternatives like helion, tri alpha, polywell, lockheed Martin…? - Quora](https://www.quora.com/Nuclear-fusion-Whos-gonna-win-the-race-ITER-or-other-alternatives-like-helion-tri-alpha-polywell-lockheed-Martin)
