# Contributing to Encoder-run/operator

First off, thank you for considering contributing to our project!

The following is a set of guidelines for contributing. These are mostly guidelines, not rules. Use your best judgment, and feel free to propose changes to this document in a pull request.

## Table of Contents

1. [Code of Conduct](#code-of-conduct)
2. [How Can I Contribute?](#how-can-i-contribute)
    - [Reporting Bugs](#reporting-bugs)
    - [Suggesting Enhancements](#suggesting-enhancements)
    - [Your First Code Contribution](#your-first-code-contribution)
    - [Pull Requests](#pull-requests)
3. [Style Guides](#style-guides)
    - [Git Commit Messages](#git-commit-messages)
4. [Additional Notes](#additional-notes)
    - [Issue and Pull Request Labels](#issue-and-pull-request-labels)

## Code of Conduct

This project and everyone participating in it is governed by our [Code of Conduct](CODE_OF_CONDUCT.md). By participating, you are expected to uphold this code. Please report unacceptable behavior to info@encoder.run.

## How Can I Contribute?

### Reporting Bugs

This section guides you through submitting a bug report for Encoder-run/operator. Following these guidelines helps maintainers and the community understand your report, reproduce the behavior, and find related reports.

Before creating a bug report, please check if the issue has already been reported by searching existing issues.

#### How Do I Submit A (Good) Bug Report?

Bugs are tracked as [GitHub issues](https://github.com/encoder-run/operator/issues). Create an issue and provide the following information:

- **Use a clear and descriptive title** for the issue.
- **Describe the exact steps which reproduce the problem** in as many details as possible. 
- **Provide specific examples** to demonstrate the steps.
- **Describe the behavior you observed** after following the steps and explain what is wrong with that behavior.
- **Explain which behavior you expected to see** instead and why.
- **Include screenshots and animated GIFs** which show you following the described steps and clearly demonstrate the problem.

### Suggesting Enhancements

This section guides you through submitting an enhancement suggestion for Encoder-run/Operator, including completely new features and minor improvements to existing functionality. 

Before creating enhancement suggestions, please check if the enhancement has already been suggested by searching existing issues.

#### How Do I Submit A (Good) Enhancement Suggestion?

Enhancement suggestions are tracked as [GitHub issues](https://github.com/encoder-run/operator/issues). Create an issue and provide the following information:

- **Use a clear and descriptive title** for the issue.
- **Provide a step-by-step description of the suggested enhancement** in as many details as possible.
- **Provide specific examples** to demonstrate the steps.
- **Explain why this enhancement would be useful** to most Encoder-run/operator users.
- **Include screenshots and animated GIFs** which help you demonstrate the steps or point out the part which the enhancement suggestion is related to.

### Your First Code Contribution

Unsure where to begin contributing to Encoder-run/operator? You can start by looking through these `beginner` and `help-wanted` issues:

- [Help wanted issues](https://github.com/encoder-run/operator/issues?q=is%3Aopen+is%3Aissue+label%3A%22help+wanted%22)

### Pull Requests

The process described here has several goals:

- Maintain Encoder-run/operator's quality
- Fix problems that are important to users
- Engage the community in working toward the best possible project
- Enable a sustainable system for maintainers to review contributions

Please follow these steps to have your contribution considered by the maintainers:

1. Fork the repository and create your branch from `main`.
2. If you've added code that should be tested, add tests.
3. If you've changed APIs, update the documentation.
4. Ensure the test suite passes.
5. Make sure your code lints.
6. Issue that pull request!

## Style Guides

### Git Commit Messages

- Use the present tense ("Add feature" not "Added feature")
- Use the imperative mood ("Move cursor to..." not "Moves cursor to...")
- Limit the first line to 72 characters or less
- Reference issues and pull requests liberally after the first line

## Additional Notes

### Issue and Pull Request Labels

This section lists the labels we use to help us track and manage issues and pull requests. Please make sure to tag your issues and pull requests with appropriate labels from the following categories:

- `bug` - An issue describing a bug.
- `enhancement` - An issue suggesting an enhancement.
- `question` - An issue raising a question.
- `documentation` - An issue related to documentation.
- `help wanted` - Issues that are suitable for new contributors.

Thank you for contributing!
