# Introduction

[MQTTX](https://mqttx.app) is an open-source, cross-platform MQTT 5.0 desktop client initially developed by [EMQ](https://www.emqx.com/), which can run on macOS, Linux, and Windows.

The user interface (UI) of [MQTTX](https://mqttx.app) adopts a chat-based layout, simplifying operational logic. It enables users to establish multiple MQTT connections, thereby facilitating swift testing of `MQTT/MQTTS` connections, as well as message subscription and publication.

Before installing, we encourage you to visit our [website](https://mqttx.app) or [GitHub](https://github.com/emqx/MQTTX) to acquaint yourself with the latest version information. The latest updates are aimed at enhancing the user experience. If you're familiar with this project, you also have the option to directly clone the source code of [MQTTX](https://mqttx.app), and build and use it on your own terms. During usage, if you encounter any issues, please navigate to [GitHub issues](https://github.com/emqx/MQTTX/issues) to pose queries or share your thoughts. Alternatively, you can fork our project and submit your modifications as a Pull Request. We promise a thoughtful review and timely response.

## Preview

![mqttx-gif](/images/mqttx-gif.gif)

## Main Features

- User-friendly, chat box for sending/receiving MQTT messages
- Cross-platform, compatibility, runs on Windows, macOS, and Linux
- Fully compliant with MQTT 5.0, 3.1.1 and 3.1
- Customizable color schemes for different MQTT subscriptions
- Supports one-way and two-way SSL/TLS authentication
- Supports [MQTT over WebSockets](https://www.emqx.com/en/blog/connect-to-mqtt-broker-with-websocket)
- Payload Format Conversion with support for Hex, Base64, JSON, and Plaintext
- Custom scripts for MQTT Pub/Sub simulation
- Comprehensive logging capabilities
- Language support for English, Japanese, Simplified Chinese, Turkish, and Hungarian 🇨🇳 🇯🇵 🇺🇸 🇹🇷 🇭🇺
- Toggle between Light/Dark/Night mode freely
