﻿using EImece.Domain;
using EImece.Domain.Helpers;
using EImece.Domain.Models.Enums;
using EImece.Domain.Services.IServices;
using Ninject;
using NLog;
using System;
using System.Threading;
using System.Web;
using System.Web.Mvc;

namespace EImece.Controllers
{
    public abstract class BaseController : Controller
    {
        [Inject]
        public ISettingService SettingService { get; set; }
        private static readonly Logger BaseLogger = LogManager.GetCurrentClassLogger();
        public void CreateLanguageCookie_OLD(EImeceLanguage selectedLanguage, string cookieName)
        {
            String cultureName = EnumHelper.GetEnumDescription(selectedLanguage);
            Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo(cultureName);
            Thread.CurrentThread.CurrentUICulture = Thread.CurrentThread.CurrentCulture;
            HttpCookie cultureCookie = new HttpCookie(cookieName);
            cultureCookie.Values[Constants.ELanguage] = ((int)selectedLanguage) + "";
            cultureCookie.Values[Constants.LastVisit] = DateTime.Now.ToString();
            cultureCookie.Expires = DateTime.Now.AddDays(1);
            Response.Cookies.Add(cultureCookie);
        }
        public void CreateLanguageCookie(EImeceLanguage selectedLanguage, string cookieName)
        {
            String cultureName = EnumHelper.GetEnumDescription(selectedLanguage);
            Thread.CurrentThread.CurrentCulture = new System.Globalization.CultureInfo(cultureName);
            Thread.CurrentThread.CurrentUICulture = Thread.CurrentThread.CurrentCulture;
            Session[Constants.CultureCookieName] = ((int)selectedLanguage) + "";
        }
        protected int CurrentLanguage
        {
            get
            {
                var cultureCookie =Session[Constants.CultureCookieName];
                if (cultureCookie != null)
                {
                    return Session[Constants.CultureCookieName].ToInt();
                }
                else
                {
                    return AppConfig.MainLanguage;
                }
            }
        }

        protected int CurrentLanguage_OLD
        {
            get
            {
                HttpCookie cultureCookie = Request.Cookies[Constants.CultureCookieName];
                if (cultureCookie != null)
                {
                    return cultureCookie.Values[Constants.ELanguage].ToInt();
                }
                else
                {
                    return AppConfig.MainLanguage;
                }
            }
        }

        protected override void OnException(ExceptionContext filterContext)
        {
            if (filterContext !=null && filterContext.Exception != null)
            {
                BaseLogger.Error("OnException:" + filterContext.Exception.ToFormattedString());
            }
            base.OnException(filterContext);
        }
    }
}