/*
 * Decompiled with CFR 0.152.
 */
import processing.core.PApplet;
import processing.core.PVector;

public class Boxhead
extends PApplet {
    Player p;
    Gun g;
    boolean up;
    boolean down;
    boolean left;
    boolean right;
    int round = 0;
    int score = 0;
    Lootbox l;
    boolean game = true;
    boolean pause = false;
    Projectile[] projectiles = new Projectile[1000];
    int bossTotal = 0;
    int zTotal = 1000;
    Zombie[] z = new Zombie[this.zTotal];
    int zCheck = 0;
    Wall[] walls = new Wall[12];

    public void setup() {
        this.p = new Player();
        this.g = new Gun();
        float wX = this.width / 5;
        float wY = this.height / 4;
        int i = 0;
        while (i < this.walls.length) {
            this.walls[i] = new Wall(wX - 50.0f, wY);
            if ((wX += (float)(this.width / 5)) + this.walls[i].w >= (float)this.width) {
                wX = this.width / 5;
                wY += (float)(this.height / 4);
            }
            ++i;
        }
    }

    public void draw() {
        this.background(200);
        if (this.p.health <= 0) {
            this.game = false;
        }
        if (this.game) {
            int i = 0;
            while (i < this.walls.length) {
                this.walls[i].shadow();
                ++i;
            }
            i = 0;
            while (i < this.projectiles.length) {
                if (this.projectiles[i] != null) {
                    this.projectiles[i].display();
                    if (this.projectiles[i].pos.x >= (float)this.width) {
                        this.projectiles[i] = null;
                    } else if (this.projectiles[i].pos.y >= (float)this.height) {
                        this.projectiles[i] = null;
                    } else if (this.projectiles[i].pos.x <= 0.0f) {
                        this.projectiles[i] = null;
                    } else if (this.projectiles[i].pos.y <= 0.0f) {
                        this.projectiles[i] = null;
                    }
                }
                ++i;
            }
            if (this.l != null) {
                this.l.display();
                if (this.l.collected) {
                    this.l.rollTheDice();
                    this.l = null;
                }
            }
            this.p.display();
            i = 0;
            while (i < this.z.length) {
                if (this.z[i] != null) {
                    this.z[i].display();
                    if (this.z[i].isDead()) {
                        this.score += this.z[i].score();
                        this.z[i] = null;
                    }
                } else {
                    ++this.zCheck;
                }
                ++i;
            }
            i = 0;
            while (i < this.walls.length) {
                this.walls[i].build();
                this.walls[i].top();
                ++i;
            }
            if (this.frameCount % 1000 == 0 && this.random(0.0f, this.round) > 5.0f) {
                this.l = new Lootbox();
            }
            this.strokeWeight(1.0f);
            this.fill(240);
            this.rect(0.0f, 0.0f, this.width, this.height / 14);
            this.p.playerHealth();
            this.textSize(25.0f);
            this.fill(0);
            this.text(String.format("%.0f", Float.valueOf(this.frameRate)), (float)this.width - (float)this.width * 0.025f, this.height - this.height / 100);
            this.textSize(50.0f);
            this.fill(255.0f, 0.0f, 0.0f);
            this.text(this.round, 10.0f, 50.0f);
            this.textSize(35.0f);
            this.fill(255.0f, 0.0f, 0.0f);
            this.text("SCORE: " + this.score, this.width / 2, (float)(this.height / 100) * 4.5f);
            this.textSize(35.0f);
            this.fill(0);
            if (this.g.ammo() == 1111) {
                this.text("AMMO: Inf.", (float)this.width / 1.4f, (float)(this.height / 100) * 4.5f);
            } else {
                this.text("AMMO: " + this.g.ammo(), (float)this.width / 1.4f, (float)(this.height / 100) * 4.5f);
            }
            this.pause();
            if (this.zCheck == this.zTotal) {
                ++this.round;
                this.bossTotal = this.round / 10;
                i = 0;
                while (i < this.round) {
                    int side = (int)this.random(1.0f, 4.9f);
                    float x1 = 0.0f;
                    float x2 = 0.0f;
                    float y1 = 0.0f;
                    float y2 = 0.0f;
                    if (side == 1) {
                        x1 = 0.0f;
                        x2 = this.width;
                        y1 = 0.0f;
                        y2 = 0.0f;
                    }
                    if (side == 2) {
                        x1 = this.width;
                        x2 = this.width;
                        y1 = 0.0f;
                        y2 = this.height;
                    }
                    if (side == 3) {
                        x1 = 0.0f;
                        x2 = this.width;
                        y1 = this.height;
                        y2 = this.height;
                    }
                    if (side == 4) {
                        x1 = 0.0f;
                        x2 = 0.0f;
                        y1 = 0.0f;
                        y2 = this.height;
                    }
                    if (this.round <= 1000) {
                        if (this.bossTotal > 0) {
                            this.z[i] = new Devil(this.random(x1, x2), this.random(y1, y2));
                            --this.bossTotal;
                        } else {
                            this.z[i] = new Zombie(this.random(x1, x2), this.random(y1, y2));
                        }
                    }
                    ++i;
                }
                this.zCheck = 0;
            } else {
                this.zCheck = 0;
            }
            if (this.mousePressed) {
                this.g.shoot();
            }
            if (this.up && this.right) {
                this.p.moveUpRight();
            } else if (this.down && this.right) {
                this.p.moveDownRight();
            } else if (this.up && this.left) {
                this.p.moveUpLeft();
            } else if (this.down && this.left) {
                this.p.moveDownLeft();
            } else if (this.up) {
                this.p.moveUp();
            } else if (this.down) {
                this.p.moveDown();
            } else if (this.left) {
                this.p.moveLeft();
            } else if (this.right) {
                this.p.moveRight();
            }
        } else if (!this.game) {
            this.gameOver();
        }
    }

    public void gameOver() {
        this.background(50);
        float x = this.width / 10 * 4;
        float y = this.height / 10 * 2;
        float w = this.width / 5;
        float h = this.height / 2;
        this.strokeWeight(5.0f);
        this.fill(220);
        this.rect(x, y, w, h);
        this.textSize(w / 6.5f);
        this.fill(0);
        this.text(" GAME OVER ", x + w * 0.015f, y + h / 6.0f);
        this.fill(200.0f, 5.0f, 10.0f);
        this.textSize(w / 12.0f);
        this.text("SCORE: " + this.score, x + w * 0.2f, y + h / 4.0f);
        this.fill(200.0f, 5.0f, 10.0f);
        this.textSize(w / 12.0f);
        this.text("ROUND: " + this.round, x + w * 0.2f, y + h / 3.0f);
        int c = this.color(240);
        float frameWidth = w / 1.3f;
        float frameHeight = h / 8.0f;
        float frameX = x + w * 0.115f;
        float frameY = y + h * 0.4f;
        if ((float)this.mouseX > frameX && (float)this.mouseX < frameX + frameWidth && (float)this.mouseY > frameY && (float)this.mouseY < frameY + frameHeight) {
            c = this.color(180);
            if (this.mousePressed) {
                this.newGame();
            }
        }
        this.fill(c);
        this.rect(frameX, frameY, frameWidth, frameHeight);
        this.textSize(w / 9.0f);
        this.fill(0);
        this.text(" NEW GAME ", frameX, frameY * 1.11f);
        frameY = y + h * 0.6f;
        c = this.color(240);
        if ((float)this.mouseX > x + 50.0f && (float)this.mouseX < x + w - 100.0f && (float)this.mouseY > frameY && (float)this.mouseY < frameY + frameHeight) {
            c = this.color(180);
            if (this.mousePressed) {
                this.newGamePlus();
            }
        }
        this.fill(c);
        this.rect(frameX, frameY, frameWidth, frameHeight);
        this.textSize(w / 9.0f);
        this.fill(0);
        this.text(" NEW GAME+ ", frameX, frameY * 1.09f);
        frameY = y + h * 0.8f;
        c = this.color(240);
        if ((float)this.mouseX > x + 50.0f && (float)this.mouseX < x + w - 100.0f && (float)this.mouseY > frameY && (float)this.mouseY < frameY + frameHeight) {
            c = this.color(180);
            if (this.mousePressed) {
                this.exit();
            }
        }
        this.fill(c);
        this.rect(frameX, frameY, frameWidth, frameHeight);
        this.textSize(w / 12.0f);
        this.fill(0);
        this.text(" EXIT TO DESKTOP ", frameX, frameY * 1.07f);
    }

    public void newGame() {
        this.game = true;
        this.score = 0;
        this.round = 0;
        this.z = new Zombie[this.zTotal];
        this.projectiles = new Projectile[1000];
        this.setup();
    }

    public void newGamePlus() {
        this.game = true;
        this.score = 0;
        this.round = 19;
        this.z = new Zombie[this.zTotal];
        this.projectiles = new Projectile[1000];
        this.setup();
    }

    public void pause() {
        int c = this.color(200);
        float x = this.width - 75;
        float y = 5.0f;
        float size = 50.0f;
        if ((float)this.mouseX > x && (float)this.mouseX < x + size && (float)this.mouseY > y && (float)this.mouseY < y + size) {
            c = this.color(100);
        }
        this.fill(c);
        this.strokeWeight(2.0f);
        this.rect(x, y, size, size);
        this.fill(0);
        this.rect(x + 10.0f, y + 5.0f, 10.0f, size - 10.0f);
        this.rect(x + 30.0f, y + 5.0f, 10.0f, size - 10.0f);
        if (this.pause) {
            this.textSize(50.0f);
            this.fill(25);
            this.text("PAUSED", x - (float)(this.width / 10), y + (float)(this.height / 8));
        }
    }

    public void mouseClicked() {
        if (this.mouseX > this.width - 75 && this.mouseX < this.width - 75 + 50 && this.mouseY > 5 && this.mouseY < 55) {
            if (!this.pause) {
                this.pause = true;
                this.pause();
                this.noLoop();
            } else {
                this.pause = false;
                this.loop();
            }
        }
    }

    public void mousePressed() {
        this.g.shoot();
    }

    public void keyPressed() {
        if (this.key == 'w' || this.key == 'W') {
            this.up = true;
        }
        if (this.key == 's' || this.key == 'S') {
            this.down = true;
        }
        if (this.key == 'a' || this.key == 'A') {
            this.left = true;
        }
        if (this.key == 'd' || this.key == 'D') {
            this.right = true;
        }
    }

    public void keyReleased() {
        if (this.key == 'w' || this.key == 'W') {
            this.up = false;
        }
        if (this.key == 's' || this.key == 'S') {
            this.down = false;
        }
        if (this.key == 'a' || this.key == 'A') {
            this.left = false;
        }
        if (this.key == 'd' || this.key == 'D') {
            this.right = false;
        }
    }

    public void settings() {
        this.fullScreen();
    }

    public static void main(String[] passedArgs) {
        String[] appletArgs = new String[]{"Boxhead"};
        if (passedArgs != null) {
            PApplet.main((String[])Boxhead.concat((String[])appletArgs, (String[])passedArgs));
        } else {
            PApplet.main((String[])appletArgs);
        }
    }

    class AR
    extends Gun {
        float gunLength;
        float gunWidth;
        float rateOfFire;
        float recoil;
        int damage;
        int ammo;
        int bullet;
        int c;

        AR() {
            this.gunLength = 30.0f;
            this.gunWidth = 5.0f;
            this.rateOfFire = 10.0f;
            this.recoil = 5.0f;
            this.damage = 2;
            this.ammo = 100;
            this.c = Boxhead.this.color(58, 61, 59);
        }

        @Override
        public void display() {
            Boxhead.this.fill(this.c);
            Boxhead.this.rect(Boxhead.this.p.x + 5.0f, Boxhead.this.p.y, this.gunLength, this.gunWidth);
            Boxhead.this.fill(0);
        }

        @Override
        public int ammo() {
            return this.ammo;
        }

        @Override
        public void shoot() {
            if ((float)Boxhead.this.frameCount % this.rateOfFire == 0.0f) {
                if (this.bullet == 1000) {
                    this.bullet = 0;
                }
                Boxhead.this.projectiles[this.bullet] = new Projectile(Boxhead.this.p.moveX + 2.0f, Boxhead.this.p.moveY, (float)Boxhead.this.mouseX + Boxhead.this.random(-this.recoil, this.recoil), (float)Boxhead.this.mouseY + Boxhead.this.random(-this.recoil, this.recoil), Boxhead.this.p.aim, this.gunLength, Boxhead.this.p.playerSize, this.damage);
                ++this.bullet;
                --this.ammo;
                if (this.ammo == 0) {
                    Boxhead.this.g = null;
                    Boxhead.this.g = new Gun();
                }
            }
        }
    }

    class Devil
    extends Zombie {
        float x;
        float y;
        float moveX;
        float moveY;
        float size;
        float health;
        int maxHealth;
        int c;
        float moveSpeed;
        float look;
        int score;

        Devil(float moveX, float moveY) {
            super(moveX, moveY);
            this.size = 30.0f;
            this.health = 50.0f;
            this.maxHealth = (int)this.health;
            this.c = Boxhead.this.color(189, 19, 0);
            this.moveSpeed = 0.75f;
            this.score = 125;
            this.x = ((Zombie)this).x;
            this.y = ((Zombie)this).y;
            this.moveX = ((Zombie)this).moveX;
            this.moveY = ((Zombie)this).moveY;
        }

        @Override
        public void display() {
            Boxhead.this.fill(this.c);
            this.look();
            int i = 0;
            while (i < Boxhead.this.walls.length) {
                if (Boxhead.this.walls[i].inWallTop(this.moveX, this.moveY, this.size)) {
                    this.wTop = true;
                } else if (Boxhead.this.walls[i].inWallBottom(this.moveX, this.moveY, this.size)) {
                    this.wBottom = true;
                } else if (Boxhead.this.walls[i].inWallLeft(this.moveX, this.moveY, this.size)) {
                    this.wLeft = true;
                } else if (Boxhead.this.walls[i].inWallRight(this.moveX, this.moveY, this.size)) {
                    this.wRight = true;
                }
                ++i;
            }
            this.move();
            this.wTop = false;
            this.wLeft = false;
            this.wRight = false;
            this.wBottom = false;
            Boxhead.this.strokeWeight(1.0f);
            Boxhead.this.pushMatrix();
            Boxhead.this.translate(this.moveX, this.moveY);
            Boxhead.this.rotate(this.look);
            Boxhead.this.rectMode(3);
            Boxhead.this.rect(this.x, this.y, this.size, this.size);
            Boxhead.this.rectMode(0);
            Boxhead.this.popMatrix();
            this.healthBar();
            this.checkHit();
        }

        @Override
        public void look() {
            float angle = Boxhead.atan2((float)(this.moveY - Boxhead.this.p.moveY), (float)(Boxhead.this.p.moveX - this.moveX));
            this.look = -angle;
        }

        @Override
        public int score() {
            return this.score;
        }

        @Override
        public void move() {
            float distX = Boxhead.this.p.moveX - this.moveX;
            float distY = Boxhead.this.p.moveY - this.moveY;
            float sum = Boxhead.sqrt((float)(Boxhead.sq((float)distX) + Boxhead.sq((float)distY)));
            float changeY = distY / sum * this.moveSpeed;
            float changeX = distX / sum * this.moveSpeed;
            if (sum > 30.0f) {
                if (!(this.wTop || this.wLeft || this.wRight || this.wBottom)) {
                    this.moveX += changeX;
                    this.moveY += changeY;
                } else if (this.wTop) {
                    this.moveX = changeX <= 0.0f ? (changeX > -0.5f ? (this.moveX += -0.5f) : (this.moveX += changeX)) : (changeX < 0.5f ? (this.moveX += 0.5f) : (this.moveX += changeX));
                    if (changeY < 0.0f) {
                        this.moveY += changeY;
                    }
                } else if (this.wBottom) {
                    this.moveX = changeX <= 0.0f ? (changeX > -0.5f ? (this.moveX += -0.5f) : (this.moveX += changeX)) : (changeX < 0.5f ? (this.moveX += 0.5f) : (this.moveX += changeX));
                    if (changeY > 0.0f) {
                        this.moveY += changeY;
                    }
                } else if (this.wLeft) {
                    this.moveY = changeY <= 0.0f ? (changeY > -0.8f ? (this.moveY += -0.8f) : (this.moveY += changeY)) : (changeY < 0.8f ? (this.moveY += 0.8f) : (this.moveY += changeY));
                    if (changeX < 0.0f) {
                        this.moveX += changeX;
                    }
                } else if (this.wRight) {
                    this.moveY = changeY <= 0.0f ? (changeY > -0.8f ? (this.moveY += -0.8f) : (this.moveY += changeY)) : (changeY < 0.8f ? (this.moveY += 0.8f) : (this.moveY += changeY));
                    if (changeX > 0.0f) {
                        this.moveX += changeX;
                    }
                }
            } else {
                this.attack();
            }
        }

        @Override
        public void healthBar() {
            float greenBar = this.size * this.health / (float)this.maxHealth;
            float redBar = this.size * (float)this.maxHealth / (float)this.maxHealth;
            Boxhead.this.fill(255.0f, 0.0f, 0.0f);
            Boxhead.this.rect(this.moveX - this.size / 2.0f, this.moveY + this.size, redBar, 7.5f);
            Boxhead.this.fill(0.0f, 255.0f, 0.0f);
            Boxhead.this.rect(this.moveX - this.size / 2.0f, this.moveY + this.size, greenBar, 7.5f);
        }

        @Override
        public void attack() {
            Boxhead.this.p.health -= 2;
        }

        @Override
        public boolean isDead() {
            return this.health <= 0.0f;
        }

        @Override
        public void checkHit() {
            int i = 0;
            while (i < Boxhead.this.projectiles.length) {
                if (Boxhead.this.projectiles[i] != null) {
                    float relativeX = Boxhead.this.projectiles[i].pos.x;
                    float relativeY = Boxhead.this.projectiles[i].pos.y;
                    if (relativeX >= this.moveX - this.size / 1.5f && relativeX <= this.moveX + this.size / 1.5f && relativeY >= this.moveY - this.size / 1.5f && relativeY <= this.moveY + this.size / 1.5f) {
                        this.health -= Boxhead.this.projectiles[i].damage;
                        Boxhead.this.projectiles[i] = null;
                    }
                }
                ++i;
            }
        }
    }

    class Gun {
        float gunLength = 20.0f;
        float gunWidth = 5.0f;
        float rateOfFire = 15.0f;
        float recoil = 15.0f;
        int ammo = 1111;
        int damage = 1;
        int bullet;

        Gun() {
        }

        public void display() {
            Boxhead.this.fill(0);
            Boxhead.this.rect(Boxhead.this.p.x + 5.0f, Boxhead.this.p.y, this.gunLength, this.gunWidth);
        }

        public int ammo() {
            return this.ammo;
        }

        public void shoot() {
            if ((float)Boxhead.this.frameCount % this.rateOfFire == 0.0f) {
                if (this.bullet == 1000) {
                    this.bullet = 0;
                }
                Boxhead.this.projectiles[this.bullet] = new Projectile(Boxhead.this.p.moveX + 2.0f, Boxhead.this.p.moveY, (float)Boxhead.this.mouseX + Boxhead.this.random(-this.recoil, this.recoil), (float)Boxhead.this.mouseY + Boxhead.this.random(-this.recoil, this.recoil), Boxhead.this.p.aim, this.gunLength, Boxhead.this.p.playerSize, this.damage);
                ++this.bullet;
            }
        }
    }

    class Lootbox {
        float x;
        float y;
        float size;
        boolean goodPos = false;
        boolean collected = false;
        int c;

        Lootbox() {
            this.c = Boxhead.this.color(255, 153, 51);
            this.goodPos = this.inWall();
            this.size = 10.0f;
        }

        public void display() {
            if (this.goodPos && !this.collected) {
                Boxhead.this.fill(this.c);
                Boxhead.this.rect(this.x, this.y, this.size, this.size);
                this.collect();
            }
        }

        public void collect() {
            if (Boxhead.this.p.moveX + (float)(Boxhead.this.p.playerSize / 2) > this.x && Boxhead.this.p.moveX - (float)(Boxhead.this.p.playerSize / 2) < this.x + this.size && Boxhead.this.p.moveY + (float)(Boxhead.this.p.playerSize / 2) > this.y && Boxhead.this.p.moveY - (float)(Boxhead.this.p.playerSize / 2) < this.y + this.size) {
                this.rollTheDice();
                this.collected = true;
            }
        }

        public void rollTheDice() {
            int number = (int)Boxhead.this.random(0.0f, 100.0f);
            if (number < 30) {
                Boxhead.this.g = new Uzi();
            }
            if (number > 30 && number < 60) {
                Boxhead.this.g = new Sniper();
            }
            if (number > 60) {
                Boxhead.this.g = new AR();
            }
        }

        public float randomX() {
            return Boxhead.this.random(25.0f, Boxhead.this.width - 25);
        }

        public float randomY() {
            return Boxhead.this.random(Boxhead.this.height / 14, Boxhead.this.height - 25);
        }

        public boolean inWall() {
            this.x = this.randomX();
            this.y = this.randomY();
            int i = 0;
            while (i < Boxhead.this.walls.length) {
                if (this.x >= Boxhead.this.walls[i].xLeft - 5.0f && this.x <= Boxhead.this.walls[i].xRight + 5.0f && this.y >= Boxhead.this.walls[i].yTop - 10.0f && this.y <= Boxhead.this.walls[i].yBot + 5.0f) {
                    this.inWall();
                }
                ++i;
            }
            return true;
        }
    }

    class Player {
        float x = 0.0f;
        float y = 0.0f;
        float moveX;
        float moveY;
        float aim;
        float speed;
        int health;
        int maxHealth;
        int playerSize = 25;
        boolean wTop;
        boolean wBottom;
        boolean wLeft;
        boolean wRight;

        Player() {
            this.moveX = Boxhead.this.width / 2;
            this.moveY = Boxhead.this.height / 2;
            this.health = 100;
            this.speed = 5.0f;
            this.maxHealth = this.health = 100;
            Boxhead.this.g = new Gun();
        }

        public void display() {
            this.aim();
            Boxhead.this.strokeWeight(1.0f);
            Boxhead.this.pushMatrix();
            Boxhead.this.translate(this.moveX, this.moveY);
            Boxhead.this.rotate(this.aim);
            if (Boxhead.this.g != null) {
                Boxhead.this.g.display();
            }
            Boxhead.this.rectMode(3);
            Boxhead.this.fill(150.0f, 75.0f, 0.0f);
            Boxhead.this.rect(this.x, this.y - (float)(this.playerSize / 2), this.playerSize, this.playerSize);
            Boxhead.this.popMatrix();
            Boxhead.this.rectMode(0);
            int i = 0;
            while (i < Boxhead.this.walls.length) {
                if (Boxhead.this.walls[i].inWallTop(this.moveX, this.moveY, this.playerSize)) {
                    if (!this.wRight || !this.wLeft) {
                        this.wTop = true;
                    }
                } else if (!(!Boxhead.this.walls[i].inWallBottom(this.moveX, this.moveY, this.playerSize) || this.wRight && this.wLeft)) {
                    this.wBottom = true;
                }
                if (Boxhead.this.walls[i].inWallLeft(this.moveX, this.moveY, this.playerSize)) {
                    if (!this.wTop || !this.wBottom) {
                        this.wLeft = true;
                    }
                } else if (!(!Boxhead.this.walls[i].inWallRight(this.moveX, this.moveY, this.playerSize) || this.wTop && this.wBottom)) {
                    this.wRight = true;
                }
                ++i;
            }
        }

        public void playerHealth() {
            Boxhead.this.strokeWeight(1.0f);
            float greenBar = Boxhead.this.width / 3 * this.health / this.maxHealth;
            float redBar = Boxhead.this.width / 3 * this.maxHealth / this.maxHealth;
            Boxhead.this.fill(255.0f, 0.0f, 0.0f);
            Boxhead.this.rect(Boxhead.this.width / 10 * 1, Boxhead.this.height / 100 * 1, redBar, redBar / 12.0f);
            Boxhead.this.fill(0.0f, 255.0f, 0.0f);
            Boxhead.this.rect(Boxhead.this.width / 10 * 1, Boxhead.this.height / 100 * 1, greenBar, redBar / 12.0f);
        }

        public void aim() {
            float angle = Boxhead.atan2((float)(this.moveY - (float)Boxhead.this.mouseY), (float)((float)Boxhead.this.mouseX - this.moveX));
            this.aim = -angle;
        }

        public void moveLeft() {
            if (this.moveX - (float)(this.playerSize / 2) > 0.0f && !this.wRight) {
                this.moveX -= this.speed;
            }
            this.wRight = false;
        }

        public void moveRight() {
            if (this.moveX + (float)(this.playerSize / 2) < (float)Boxhead.this.width && !this.wLeft) {
                this.moveX += this.speed;
            }
            this.wLeft = false;
        }

        public void moveUp() {
            if (this.moveY - (float)(this.playerSize / 2) > 0.0f && !this.wBottom) {
                this.moveY -= this.speed;
            }
            this.wBottom = false;
        }

        public void moveDown() {
            if (this.moveY + (float)(this.playerSize / 2) < (float)Boxhead.this.height && !this.wTop) {
                this.moveY += this.speed;
            }
            this.wTop = false;
        }

        public void moveUpRight() {
            if (this.moveY - (float)(this.playerSize / 2) > 0.0f && !this.wBottom) {
                this.moveY -= this.speed / 1.5f;
            }
            if (this.moveX + (float)(this.playerSize / 2) < (float)Boxhead.this.width && !this.wLeft) {
                this.moveX += this.speed / 1.5f;
            }
            this.wBottom = false;
            this.wLeft = false;
        }

        public void moveDownRight() {
            if (this.moveY + (float)(this.playerSize / 2) < (float)Boxhead.this.height && !this.wTop) {
                this.moveY += this.speed / 1.5f;
            }
            if (this.moveX + (float)(this.playerSize / 2) < (float)Boxhead.this.width && !this.wLeft) {
                this.moveX += this.speed / 1.5f;
            }
            this.wTop = false;
            this.wLeft = false;
        }

        public void moveUpLeft() {
            if (this.moveY - (float)(this.playerSize / 2) > 0.0f && !this.wBottom) {
                this.moveY -= this.speed / 1.5f;
            }
            if (this.moveX - (float)(this.playerSize / 2) > 0.0f && !this.wRight) {
                this.moveX -= this.speed / 1.5f;
            }
            this.wBottom = false;
            this.wRight = false;
        }

        public void moveDownLeft() {
            if (this.moveY + (float)(this.playerSize / 2) < (float)Boxhead.this.height && !this.wTop) {
                this.moveY += this.speed / 1.5f;
            }
            if (this.moveX - (float)(this.playerSize / 2) > 0.0f && !this.wRight) {
                this.moveX -= this.speed / 1.5f;
            }
            this.wTop = false;
            this.wRight = false;
        }
    }

    class Projectile {
        PVector start;
        PVector target;
        PVector dir;
        PVector pos;
        float changeX;
        float changeY;
        float angle;
        float gunLength;
        float playerSize;
        float moveSpeed = 20.0f;
        float damage;

        Projectile(float x, float y, float x1, float y1, float aim, float gunLength, float playerSize, float damage) {
            this.gunLength = gunLength;
            this.playerSize = playerSize;
            this.damage = damage;
            this.start = new PVector(x, y);
            this.target = new PVector(x1, y1);
            this.pos = this.start.copy();
            this.dir = this.start.copy().sub(this.target).normalize();
            this.angle = aim;
        }

        public void display() {
            Boxhead.this.strokeWeight(2.0f);
            Boxhead.this.pushMatrix();
            Boxhead.this.translate(this.pos.x, this.pos.y);
            Boxhead.this.rotate(this.angle);
            Boxhead.this.rectMode(3);
            Boxhead.this.rect(this.gunLength, 0.0f, 10.0f, 1.0f);
            Boxhead.this.rectMode(0);
            this.travel();
            Boxhead.this.popMatrix();
        }

        public void travel() {
            this.pos = this.pos.add(this.dir.copy().mult(-this.moveSpeed));
        }
    }

    class Sniper
    extends Gun {
        float gunLength = 40.0f;
        float gunWidth = 5.0f;
        float rateOfFire = 25.0f;
        float recoil = 0.0f;
        int damage = 10;
        int ammo = 20;
        int bullet;
        int c;

        Sniper() {
            this.c = Boxhead.this.color(58, 61, 59);
        }

        @Override
        public void display() {
            Boxhead.this.fill(this.c);
            Boxhead.this.rect(Boxhead.this.p.x - 5.0f, Boxhead.this.p.y, this.gunLength, this.gunWidth);
            Boxhead.this.fill(0);
        }

        @Override
        public int ammo() {
            return this.ammo;
        }

        @Override
        public void shoot() {
            if ((float)Boxhead.this.frameCount % this.rateOfFire == 0.0f) {
                if (this.bullet == 1000) {
                    this.bullet = 0;
                }
                Boxhead.this.projectiles[this.bullet] = new Projectile(Boxhead.this.p.moveX + 2.0f, Boxhead.this.p.moveY, (float)Boxhead.this.mouseX + Boxhead.this.random(-this.recoil, this.recoil), (float)Boxhead.this.mouseY + Boxhead.this.random(-this.recoil, this.recoil), Boxhead.this.p.aim, this.gunLength, Boxhead.this.p.playerSize, this.damage);
                ++this.bullet;
                --this.ammo;
                if (this.ammo == 0) {
                    Boxhead.this.g = null;
                    Boxhead.this.g = new Gun();
                }
            }
        }
    }

    class Target {
        float x;
        float y;
        float w;
        float h;
        int count = 0;
        int c;

        Target(float x, float y) {
            this.x = x;
            this.y = y;
            this.w = 50.0f;
            this.h = 50.0f;
            this.c = Boxhead.this.color(255, 0, 0);
        }

        public void display() {
            Boxhead.this.fill(this.c);
            Boxhead.this.strokeWeight(2.0f);
            Boxhead.this.rect(this.x, this.y, this.w, this.h);
            Boxhead.this.textSize(15.0f);
            Boxhead.this.fill(0);
            Boxhead.this.text(this.count, this.x + 10.0f, this.y + 25.0f);
            this.checkHit();
        }

        public void checkHit() {
            int i = 0;
            while (i < Boxhead.this.projectiles.length) {
                if (Boxhead.this.projectiles[i] != null) {
                    float relativeX = Boxhead.this.projectiles[i].pos.x;
                    float relativeY = Boxhead.this.projectiles[i].pos.y;
                    if (relativeX >= this.x && relativeX <= this.x + this.w && relativeY >= this.y && relativeY <= this.y + this.h) {
                        ++this.count;
                        Boxhead.this.projectiles[i] = null;
                    }
                    if (this.count % 10 == 0 && this.count > 0) {
                        this.c = Boxhead.this.color(0, 255, 0);
                    }
                }
                ++i;
            }
        }
    }

    class Uzi
    extends Gun {
        float gunLength = 15.0f;
        float gunWidth = 5.0f;
        float rateOfFire = 2.0f;
        float recoil = 50.0f;
        float damage = 0.75f;
        int ammo = 300;
        int bullet;
        int c;

        Uzi() {
            this.c = Boxhead.this.color(108, 101, 100);
        }

        @Override
        public void display() {
            Boxhead.this.fill(this.c);
            Boxhead.this.rect(Boxhead.this.p.x + 5.0f, Boxhead.this.p.y, this.gunLength, this.gunWidth);
            Boxhead.this.fill(0);
        }

        @Override
        public int ammo() {
            return this.ammo;
        }

        @Override
        public void shoot() {
            if ((float)Boxhead.this.frameCount % this.rateOfFire == 0.0f) {
                if (this.bullet == 1000) {
                    this.bullet = 0;
                }
                Boxhead.this.projectiles[this.bullet] = new Projectile(Boxhead.this.p.moveX + 2.0f, Boxhead.this.p.moveY, (float)Boxhead.this.mouseX + Boxhead.this.random(-this.recoil, this.recoil), (float)Boxhead.this.mouseY + Boxhead.this.random(-this.recoil, this.recoil), Boxhead.this.p.aim, this.gunLength, Boxhead.this.p.playerSize, this.damage);
                ++this.bullet;
                --this.ammo;
                if (this.ammo == 0) {
                    Boxhead.this.g = null;
                    Boxhead.this.g = new Gun();
                }
            }
        }
    }

    class Wall {
        float x;
        float y;
        float w;
        float h;
        float yTop;
        float yBot;
        float xLeft;
        float xRight;

        Wall(float x, float y) {
            this.x = x;
            this.y = y;
            this.w = 100.0f;
            this.h = 80.0f;
            this.yTop = this.y - 30.0f;
            this.yBot = this.y + this.h;
            this.xLeft = this.x;
            this.xRight = this.x + this.w;
        }

        public void build() {
            Boxhead.this.fill(255);
            Boxhead.this.stroke(0);
            Boxhead.this.strokeWeight(3.0f);
            Boxhead.this.rect(this.x, this.y, this.w, this.h);
            this.checkHit();
        }

        public void top() {
            Boxhead.this.fill(150);
            Boxhead.this.strokeWeight(3.0f);
            Boxhead.this.rect(this.x, this.y, this.w, -this.h / 1.5f);
        }

        public void shadow() {
            Boxhead.this.fill(50);
            Boxhead.this.stroke(50);
            Boxhead.this.strokeWeight(2.0f);
            Boxhead.this.beginShape();
            Boxhead.this.vertex(this.x, this.y + this.h);
            Boxhead.this.vertex(this.x - this.w / 4.0f, this.y + this.h / 2.0f);
            Boxhead.this.vertex(this.x - this.w / 4.0f, this.y - 10.0f);
            Boxhead.this.vertex(this.x, this.y - 10.0f);
            Boxhead.this.endShape();
        }

        public boolean inWallTop(float x, float y, float size) {
            if (x >= this.xLeft - size * 0.5f && x <= this.xRight + size * 0.5f && y >= this.yTop - size * 0.5f && y <= this.yTop) {
                Boxhead.println((String)"TOP");
                return true;
            }
            return false;
        }

        public boolean inWallBottom(float x, float y, float size) {
            if (x >= this.xLeft - size * 0.5f && x <= this.xRight + size * 0.5f && y <= this.yBot + size * 0.5f && y >= this.yBot) {
                Boxhead.println((String)"Bottom");
                return true;
            }
            return false;
        }

        public boolean inWallLeft(float x, float y, float size) {
            if (x >= this.xLeft - size * 0.5f && x <= this.xLeft && y >= this.yTop - size * 0.5f && y <= this.yBot + size * 0.5f) {
                Boxhead.println((String)"LEFT");
                return true;
            }
            return false;
        }

        public boolean inWallRight(float x, float y, float size) {
            if (x <= this.xRight + size * 0.5f && x >= this.xRight && y >= this.yTop - size * 0.5f && y <= this.yBot + size * 0.5f) {
                Boxhead.println((String)"RIGHT");
                return true;
            }
            return false;
        }

        public void checkHit() {
            int i = 0;
            while (i < Boxhead.this.projectiles.length) {
                if (Boxhead.this.projectiles[i] != null) {
                    float relativeX = Boxhead.this.projectiles[i].pos.x;
                    float relativeY = Boxhead.this.projectiles[i].pos.y;
                    if (relativeX >= this.xLeft && relativeX <= this.xRight && relativeY >= this.yTop && relativeY <= this.yBot) {
                        Boxhead.this.projectiles[i] = null;
                    }
                }
                ++i;
            }
        }
    }

    class Zombie {
        float x;
        float y;
        float moveX;
        float moveY;
        float size = 25.0f;
        float health = 10.0f;
        int maxHealth = (int)this.health;
        int c;
        float moveSpeed;
        float look;
        int score;
        boolean wTop;
        boolean wBottom;
        boolean wLeft;
        boolean wRight;

        Zombie(float moveX, float moveY) {
            this.c = Boxhead.this.color(105, 131, 98);
            this.moveSpeed = 1.0f;
            this.score = 25;
            this.x = 0.0f;
            this.moveX = moveX;
            this.moveY = moveY;
        }

        public void display() {
            Boxhead.this.fill(this.c);
            this.look();
            int i = 0;
            while (i < Boxhead.this.walls.length) {
                if (!(!Boxhead.this.walls[i].inWallTop(this.moveX, this.moveY, this.size) || this.wRight && this.wLeft)) {
                    this.wTop = true;
                }
                if (!(!Boxhead.this.walls[i].inWallBottom(this.moveX, this.moveY, this.size) || this.wRight && this.wLeft)) {
                    this.wBottom = true;
                }
                if (!(!Boxhead.this.walls[i].inWallLeft(this.moveX, this.moveY, this.size) || this.wTop && this.wBottom)) {
                    this.wLeft = true;
                }
                if (!(!Boxhead.this.walls[i].inWallRight(this.moveX, this.moveY, this.size) || this.wTop && this.wBottom)) {
                    this.wRight = true;
                }
                ++i;
            }
            this.move();
            this.wTop = false;
            this.wLeft = false;
            this.wRight = false;
            this.wBottom = false;
            Boxhead.this.strokeWeight(1.0f);
            Boxhead.this.pushMatrix();
            Boxhead.this.translate(this.moveX, this.moveY);
            Boxhead.this.rotate(this.look);
            Boxhead.this.rectMode(3);
            Boxhead.this.rect(this.x, this.y, this.size, this.size);
            Boxhead.this.rectMode(0);
            Boxhead.this.popMatrix();
            this.healthBar();
            this.checkHit();
        }

        public void look() {
            float angle = Boxhead.atan2((float)(this.moveY - Boxhead.this.p.moveY), (float)(Boxhead.this.p.moveX - this.moveX));
            this.look = -angle;
        }

        public int score() {
            return this.score;
        }

        public void move() {
            float distX = Boxhead.this.p.moveX - this.moveX;
            float distY = Boxhead.this.p.moveY - this.moveY;
            float sum = Boxhead.sqrt((float)(Boxhead.sq((float)distX) + Boxhead.sq((float)distY)));
            float changeY = distY / sum * this.moveSpeed;
            float changeX = distX / sum * this.moveSpeed;
            if (sum > 30.0f) {
                if (!(this.wTop || this.wLeft || this.wRight || this.wBottom)) {
                    this.moveX += changeX;
                    this.moveY += changeY;
                } else if (this.wTop) {
                    this.moveX = changeX < 0.0f ? (changeX > -0.5f ? (this.moveX += -0.5f) : (this.moveX += changeX)) : (changeX < 0.5f ? (this.moveX += 0.5f) : (this.moveX += changeX));
                    if (changeY < 0.0f) {
                        this.moveY += changeY;
                    }
                } else if (this.wBottom) {
                    this.moveX = changeX < 0.0f ? (changeX > -0.5f ? (this.moveX += -0.5f) : (this.moveX += changeX)) : (changeX < 0.5f ? (this.moveX += 0.5f) : (this.moveX += changeX));
                    if (changeY > 0.0f) {
                        this.moveY += changeY;
                    }
                } else if (this.wLeft) {
                    this.moveY = changeY < 0.0f ? (changeY > -0.8f ? (this.moveY += -0.8f) : (this.moveY += changeY)) : (changeY < 0.8f ? (this.moveY += 0.8f) : (this.moveY += changeY));
                    if (changeX < 0.0f) {
                        this.moveX += changeX;
                    }
                } else if (this.wRight) {
                    this.moveY = changeY < 0.0f ? (changeY > -0.8f ? (this.moveY += -0.8f) : (this.moveY += changeY)) : (changeY < 0.8f ? (this.moveY += 0.8f) : (this.moveY += changeY));
                    if (changeX > 0.0f) {
                        this.moveX += changeX;
                    }
                }
            } else {
                this.attack();
            }
        }

        public void healthBar() {
            float greenBar = this.size * this.health / (float)this.maxHealth;
            float redBar = this.size * (float)this.maxHealth / (float)this.maxHealth;
            Boxhead.this.fill(255.0f, 0.0f, 0.0f);
            Boxhead.this.rect(this.moveX - this.size / 2.0f, this.moveY + this.size, redBar, 7.5f);
            Boxhead.this.fill(0.0f, 255.0f, 0.0f);
            Boxhead.this.rect(this.moveX - this.size / 2.0f, this.moveY + this.size, greenBar, 7.5f);
        }

        public void attack() {
            --Boxhead.this.p.health;
        }

        public boolean isDead() {
            return this.health <= 0.0f;
        }

        public void checkHit() {
            int i = 0;
            while (i < Boxhead.this.projectiles.length) {
                if (Boxhead.this.projectiles[i] != null) {
                    float relativeX = Boxhead.this.projectiles[i].pos.x;
                    float relativeY = Boxhead.this.projectiles[i].pos.y;
                    if (relativeX >= this.moveX - this.size / 1.5f && relativeX <= this.moveX + this.size / 1.5f && relativeY >= this.moveY - this.size / 1.5f && relativeY <= this.moveY + this.size / 1.5f) {
                        this.health -= Boxhead.this.projectiles[i].damage;
                        Boxhead.this.projectiles[i] = null;
                    }
                }
                ++i;
            }
        }
    }
}

