// Generated by CoffeeScript 1.8.0

/*
 You can override this method for create your own logic for create asset
 */
import Ember from 'ember';
import DS from 'ember-data';
var fileUploadMixin;

fileUploadMixin = Ember.Mixin.create({
  actions: {
    createAssetAction: function(asset, property, view) {
      return asset.save().then((function(_this) {
        return function() {
          view.set('creating', false);
          view.clearInput();
          if (view.get('single')) {
            return _this._createBelongsTo(asset, property);
          } else {
            return _this._createHasMany(asset, property);
          }
        };
      })(this));
    },
    deleteAsset: function(options) {
      var asset = options.asset;
      var single = options.single;
      var property = options.property;
      var self = this;
      asset.then(function(asset){
        asset.destroyRecord();
        if (single) {
          return self._deleteBelongsTo(asset, property);
        } else {
          return self._deleteHasMany(asset, property);
        }
      });
    }
  },
  _createBelongsTo: function(asset, property) {
    var state;
    this.get("model").set(property, asset);
    if (this.get('model.isDirty')) {
      if (this.get('model.id')) {
        state = DS.RootState.loaded.saved;
        return this.get("model").set('currentState', state);
      }
    }
  },
  _createHasMany: function(asset, property) {
    return this.get("model." + property).pushObject(asset);
  },
  _deleteBelongsTo: function(asset, property) {
    return asset.one('didDelete', (function(_this) {
      return function() {
        var state;
        _this.get("model").set(property, null);
        if (_this.get('model.isDirty')) {
          state = DS.RootState.loaded;
          return _this.get("model").set('currentState', state.saved);
        }
      };
    })(this));
  },
  _deleteHasMany: function(asset, property) {
    return this.get("model." + property).removeObject(asset);
  }
});

export default fileUploadMixin;
