// Generated by CoffeeScript 1.8.0

/*
  This is base controller for use in all views
  If you wont add you action please override this actions
  Or you can use additionalActions property!
  for example:
   In your controller
    additionalActions:(->
      [{title: "my action", class: "btn my-action-css", action: "my"}]
    ).property()

  use @@confirm property for show text in confirmation modal
  @@action - is an action in your controller which pass model param

   *for batch actions you don't need save model, because save call automatic when all objects

   * for custom breadcrumbs actions you need override
   breadcrumbsActions property and add action title, then add this action into additionalActions property
 */
import Ember from 'ember';
var baseActionsMixin;

baseActionsMixin = Ember.Mixin.create({

  itemActions: [{
    title: "Edit",
    "class": "btn btn-small btn-primary",
    action: "edit",
    iconClass: "glyphicon glyphicon-pencil"
  }, {
    title: "Show",
    "class": "btn btn-small btn-success",
    action: "show",
    iconClass: "glyphicon glyphicon-info-sign"
  }, {
    title: "Delete",
    confirm: "Are you sure you want to delete this?",
    "class": "btn btn-small btn-danger",
    action: "destroy",
    iconClass: "glyphicon glyphicon-trash"
  }],
  allActions: Ember.computed('actionNew', 'itemActions', {
    get: function() {
      let allActions = this.get('itemActions').concat([this.get('actionNew')]);
      return Ember.A(allActions);
    }
  }),
  actionNew: Ember.computed('model', {
    get: function() {
      return {
        title: "New",
        "class": "btn btn-primary",
        action: "new",
        iconClass: "glyphicon glyphicon-plus"
      };
    }
  }),

  breadcrumbsActions: Ember.computed('__breadcrumbsActionsArray', {
    get: function() {
      return this.get('__breadcrumbsActionsArray');
    }
  }),

  actions: {
    "new": function(model) {
      return this._transitionToMetaRoute(model, "new");
    },
    edit: function(model) {
      return this._transitionToMetaRoute(model, "edit");
    },
    update: function(model) {
      return model.save();
    },
    destroy: function(model, batch) {
      if (batch == null) {
        batch = false;
      }
      if (this.get('model.__list')) {
        model.deleteRecord();
        this.get('model.items').removeObject(model);
        if (!batch) {
          this.get('__batches').removeObject(model);
        }
        return model.save();
      } else {
        return this._destroyItem(model);
      }
    },
    show: function(model) {
      return this._transitionToMetaRoute(model, "show");
    },
    adminAction: function(adminActionName, item) {
      this.send(adminActionName, item);
    }
  },

  _destroyItem: function(model) {
    model.deleteRecord();
    return model.save().then((function(_this) {
      return function() {
        return _this.transitionToRoute(_this.get('_name'));
      };
    })(this));
  },

  _transitionToMetaRoute: function(model, type) {
    var result = null;

    if (type) {
      result = `${this.get('_name')}.${type}`;

      if (type === 'new') {
        return this.transitionToRoute(result);
      } else {
        return this.transitionToRoute(result, model.get('id'));
      }
    }

    return this.transitionToRoute(`/${this.get('_name')}/${model}`);
  }
});

export default baseActionsMixin;
