# Asp.NETCore 2.1 Vue 2 SignalR Starter

This repo contains an aspnetcore + Vue.js 2 + SignalR Alpha starter template (VS2017). The template is based
on the [aspnetcore-Vue-starter Template](https://github.com/MarkPieszak/aspnetcore-Vue-starter)

_Looking for the original starter templates? [click here](https://blogs.msdn.microsoft.com/webdev/2017/02/14/building-single-page-applications-on-asp-net-core-with-javascriptservices/)_

_Looking for aspnetcore & Angular 2.x+ Universal starter? [click here](https://github.com/MarkPieszak/aspnetcore-angular2-universal)_

_Looking for SignalR source code? [click here](https://github.com/aspnet/SignalR)_
 
---

# Table of Contents

* [Features](#features)
* [Prerequisites](#prerequisites)
* [Installation - Getting Started!](#installation)
* [Special Thanks](#special-thanks)
* [License](#license)
* [Social Media](#follow-me-online)

# Features

- **ASP.NET Core 2.1**
  - Web API
- **VueJS 2**
  - Vuex (State Store)
- **Webpack 2**
  - HMR (Hot Module Replacement/Reloading)
- **Bootstrap**
- **SignalR RC1**


# Prerequisites:
 * nodejs > 6
 * VS2017
 * dotnet core 2.1

# Installation / Getting Started:
 * Clone this repo
 * At the repo's root directory run `dotnet restore`
 * Restore Node dependencies by running `npm install`
 * Run the application (`dotnet run` or `npm run dev`)
 
 or
 
 * Run the application in VSCode or Visual Studio 2017 (Hit `F5`)
 * Browse to [http://localhost:5000](http://localhost:5000)

# Extras

- Get Chrome DevTools for Vue [here](https://chrome.google.com/webstore/detail/vuejs-devtools/nhdogjmejiglipccpnnnanhbledajbpd)

# Found a Bug? Want to Contribute?

Nothing's ever perfect, but please let me know by creating an issue (make sure there isn't an existing one about it already), and we'll try and work out a fix for it! If you have any good ideas, or want to contribute, feel free to either make an Issue with the Proposal, or just make a PR from your Fork.

----

### Special Thanks

Many thanks go out to Steve Sanderson (@SteveSandersonMS) from Microsoft and his amazing work on [JavaScriptServices](https://blogs.msdn.microsoft.com/webdev/2017/02/14/building-single-page-applications-on-asp-net-core-with-javascriptservices/) and integrating the world of Node with ASP.NET Core.

[Mark Pieszak](https://github.com/MarkPieszak) for creating the original template that this was based on.

[David Fowler](https://github.com/davidfowl) for SignalR and for reviewing and improving this starter template.

# License

[![MIT License](https://img.shields.io/badge/license-MIT-blue.svg?style=flat)](/LICENSE) 

Copyright (c) 2016-2017 [Eric Malamisura](https://github.com/elucidsoft)

### Follow me online:

Twitter: [@emalamisura](http://twitter.com/emalamisura)

----

