'use client'


import { IToken } from "@/Interfaces/Interface";
import FooterComponent from "@/components/FooterComponent/page";
import NavbarComponent from "@/components/NavbarComponent";
import { useAppContext } from "@/context/Context";
import { AddStudentAPI } from "@/utils/DataServices/DataService";
import { notFound, useRouter } from "next/navigation";
import { useEffect, useState } from "react";
import InputMask from 'react-input-mask';
import { ToastContainer, toast } from 'react-toastify';
import 'react-toastify/dist/ReactToastify.css';

const AddFormPage = () => {
    const [data, setData] = useState<any>(null);
    const router = useRouter();

    const [formData, setFormData] = useState({
        id: 0,
        firstname: '',
        lastname: '',
        email: '',
        dob: '',
        address: '',
        phonenumber: '',
        isDeleted: false
    });
    const [isSubmitted, setIsSubmitted] = useState(false);
    const [maxDate, setMaxDate] = useState('');

    useEffect(() => {
        const session = sessionStorage.getItem('WA-SessionStorage');

        setData(session ? JSON.parse(session) : null);

        CheckToken(session ? JSON.parse(session) : null);

        const today = new Date();
        const year = today.getFullYear();
        const month = String(today.getMonth() + 1).padStart(2, '0');
        const day = String(today.getDate()).padStart(2, '0');
        setMaxDate(`${year}-${month}-${day}`);
    }, []);

    const CheckToken = (data: IToken | null) => {
        if ((data !== null && data.token === null) || data === null) {
            router.push('/')
        }
    }

    const updateForm = (e: React.ChangeEvent<HTMLInputElement>) => {
        // Pass through current values and update
        setFormData({
            ...formData, //get the existing form 
            [e.target.name]: e.target.value //[] to get property name dynamically
        })
    }

    const handleSubmit = async (e: React.FormEvent<HTMLFormElement>) => {
        e.preventDefault();
        setIsSubmitted(true);

        const isFilled = formData.firstname && formData.lastname && formData.email && formData.dob;
        const checkFirstName = /^[A-Za-z\u00C0-\u00FF][A-Za-z\u00C0-\u00FF'\-]+([\ A-Za-z\u00C0-\u00FF][A-Za-z\u00C0-\u00FF'\-]+)*$/.test(formData.firstname)
        const checkLastName = /^[A-Za-z\u00C0-\u00FF][A-Za-z\u00C0-\u00FF'\-]+([\ A-Za-z\u00C0-\u00FF][A-Za-z\u00C0-\u00FF'\-]+)*$/.test(formData.lastname)

        if (isFilled && checkFirstName && checkLastName) {
            if (formData.phonenumber.length > 0 && !/\([0-9]{3}\)-[0-9]{3}-[0-9]{4}/.test(formData.phonenumber)) {
                toast("Please fill out your number.", { type: "error", className: " !grid !grid-cols-[95%_5%] text-center" });
            } else {
                try {
                    await AddStudentAPI(formData)
                    toast("You've successfully added a student to the directory!", { type: "success", className: " !grid !grid-cols-[95%_5%] text-center" });

                    // Reset all form fields
                    setFormData({
                        id: 0,
                        firstname: '',
                        lastname: '',
                        email: '',
                        dob: '',
                        address: '',
                        phonenumber: '',
                        isDeleted: false
                    });
                    setIsSubmitted(false);
                } catch (error) {
                    toast("You currently can't add a student, the api might be down right now, sorry", { type: "warning", className: " !grid !grid-cols-[95%_5%] text-center" });
                }
            }

        } else {
            if (!isFilled) {
                toast("Please fill out all required fields.", { type: "error", className: " !grid !grid-cols-[95%_5%] text-center" });
            }

        }
    };


    return (
        <div className="min-h-screen bg-[#23527C] flex flex-col justify-between">
            <NavbarComponent admin={data && data.isAdmin} />

            <main className="w-full bg-[#23527C] flex items-center justify-center">
                <ToastContainer />

                <div className="px-6 py-4">

                    <div className="flex items-center flex-col">
                        <div className="bg-white px-6 py-4 sm:min-w-[538px] sm:max-w-[538px] max-w-[288px] my-8">
                            <h1 className="text-center text-[34px] text-black mb-6 robotoCondensed font-light "><strong className="font-bold">ADD STUDENT</strong></h1>

                            <form onSubmit={handleSubmit} className="openSans font-semibold">
                                <div className="grid sm:grid-cols-2 gap-x-6 gap-y-4 ">

                                    <div className='flex flex-col relative'>
                                        <p className='text-red-600 absolute top-0 right-1'>*</p>
                                        <input placeholder="First Name" type="text" id="firstName" name="firstName"
                                            className={`${isSubmitted && formData.firstname === '' ?
                                                'border border-red-500' : ''} text-center bg-[#ECF0F1] p-4 text-sm text-black mb-4 focus:outline-[#DD8A3E]
                                                 focus:rounded-none h-12 focus:!border-none focus:!ring-transparent active:!ring-transparent active:!border-none`}
                                            value={formData.firstname} minLength={2} maxLength={100}
                                            onChange={(e) => {
                                                const { value } = e.target;
                                                // Remove any characters that are not in the allowed set
                                                const sanitizedValueFirst = value.replace(/[^A-Za-z\u00C0-\u00FF ]+/g, '');
                                                setFormData({ ...formData, firstname: sanitizedValueFirst });
                                            }}
                                        />
                                    </div>

                                    <div className='flex flex-col relative'>
                                        <p className='text-red-600 absolute top-0 right-1'>*</p>
                                        <input placeholder="Last Name" type="text" id="lastName" name="lastName"
                                            className={`${isSubmitted && formData.lastname === '' ?
                                                'border border-red-500' : ''}
                                                text-center bg-[#ECF0F1] p-4 text-sm text-black mb-4 focus:outline-[#DD8A3E] 
                                                focus:rounded-none h-12 focus:!border-none focus:!ring-transparent active:!ring-transparent active:!border-none`}
                                            value={formData.lastname} minLength={2} maxLength={100}
                                            onChange={(e) => {
                                                const { value } = e.target;
                                                // Remove any characters that are not in the allowed set
                                                const sanitizedValueLast = value.replace(/[^A-Za-z\u00C0-\u00FF ]+/g, '');
                                                setFormData({ ...formData, lastname: sanitizedValueLast });
                                            }}
                                        />
                                    </div>

                                    <div className='flex flex-col relative'>
                                        <p className='text-red-600 absolute top-0 right-1'>*</p>
                                        <input placeholder="Email" type="email" autoComplete="email" id="email" name="email"
                                            className={`${isSubmitted && formData.email === '' ?
                                                'border border-red-500 ' : ''}
                                               text-center bg-[#ECF0F1] p-4 text-sm text-black mb-4 focus:outline-[#DD8A3E] focus:rounded-none
                                                h-12 focus:!border-none focus:!ring-transparent active:!ring-transparent active:!border-none`}
                                            value={formData.email} onChange={updateForm} />
                                    </div>

                                    <div className='flex flex-col relative'>
                                        <p className='text-red-600 absolute top-0 right-1'>*</p>

                                        <input placeholder="Birthdate" type="date" id="dob" name="dob"
                                            className={`${isSubmitted && formData.dob === '' ?
                                                'border border-red-500 ' : ''}
                                                text-center bg-[#ECF0F1] p-4 text-sm text-black mb-4 focus:outline-[#DD8A3E] focus:rounded-none
                                                 h-12 focus:!border-none focus:!ring-transparent active:!ring-transparent active:!border-none`}
                                            value={formData.dob} onChange={updateForm} max={maxDate} />
                                    </div>

                                    <div className='flex flex-col relative'>

                                        <input className="text-center bg-[#ECF0F1] p-4 text-sm text-black mb-4 focus:outline-[#DD8A3E]
                                         focus:rounded-none h-12 focus:!border-none focus:!ring-transparent active:!ring-transparent active:!border-none"
                                            placeholder="Address" type="text" autoComplete="street-address" id="address" name="address" value={formData.address}
                                            onChange={updateForm} maxLength={100} />
                                    </div>

                                    <div className='flex flex-col relative'>
                                        <InputMask className={`${/\([0-9]{3}\)-[0-9]{3}-[0-9]{4}/.test(formData.phonenumber) === false && formData.phonenumber.length > 0 ?
                                            "border border-red-500" : "border-zinc-500"}
                                              text-center bg-[#ECF0F1] p-4 text-sm text-black mb-4 focus:outline-[#DD8A3E] focus:rounded-none h-12 border `}
                                            placeholder="(xxx)-xxx-xxxx" autoComplete="tel" mask="(999)-999-9999" value={formData.phonenumber} onChange={updateForm} id="phonenumber" name="phonenumber"></InputMask>
                                    </div>

                                </div>

                                <div className="flex justify-center mt-6 w-full flex-col">
                                    <button type="submit" className="bg-[#DD8A3E] hover:brightness-90 p-4 w-full text-white text-sm font-bold tracking-wide">Update</button>
                                    <p className=" text-red-600 text-xs text-end pt-1 openSans">* fields required</p>
                                </div>

                            </form>
                        </div>
                    </div>
                </div>

            </main>

            <FooterComponent />
        </div>
    )
}

export default AddFormPage
