# GTL001

![Sample Image](documentation/Alpha-NFT.png)

## About

GTL001 is the first typeface released by [GTL Type Label](https://gtl.world) and was drawn by Eli Heuer.

A 100/100 edition alpha release NFT was issued by GTL Type Label for this typeface, minting is live on Zora now: [https://create.zora.co/editions/0xb013e4f218760bb72f63f8d78a82b546c91897ef](https://create.zora.co/editions/0xb013e4f218760bb72f63f8d78a82b546c91897ef)

## Building

Fonts are built automatically by GitHub Actions - take a look in the "Actions" tab for the latest build.

If you want to build fonts manually on your own computer:

* `make build` will produce font files.
* `make test` will run [FontBakery](https://github.com/googlefonts/fontbakery)'s quality assurance tests.
* `make proof` will generate HTML proof files.

The proof files and QA tests are also available automatically via GitHub Actions - look at https://eliheuer.github.io/GTL001.

## Changelog

**29 July 2022. Version 0.1**
- Alpha release
- NFT minting is [live on Zora](https://create.zora.co/editions/0xb013e4f218760bb72f63f8d78a82b546c91897ef)

**27 July 2022. Version 0.1**
- Repo setup and drawing

## License

This Font Software is licensed under the SIL Open Font License, Version 1.1.
This license is available with a FAQ at: [https://scripts.sil.org/OFL](https://scripts.sil.org/OFL)

The SIL Open Font License (OFL) is a free, libre and open source license.

The OFL provides a legal framework and infrastructure for worldwide development, sharing and improvement of fonts and related software in a collaborative manner. It enables font authors to release their work under a common license that allows use, bundling, modification and redistribution. It encourages shared value, is not limited to any specific computing platform or environment, and can be used by other organizations or individuals.

The OFL meets the specific needs of typographic design and engineering as well as the gold standards of the FLOSS (Free/Libre and Open Source Software) community, namely the cultural values and guidelines from the FSF, the Debian Free Software Guidelines, as well as the Open Source Definition.

## Google Fonts QA
[![][Fontbakery]](https://eliheuer.github.io/GTL001/fontbakery/fontbakery-report.html)
[![][Universal]](https://eliheuer.github.io/GTL001/fontbakery/fontbakery-report.html)
[![][GF Profile]](https://eliheuer.github.io/GTL001/fontbakery/fontbakery-report.html)
[![][Outline Correctness]](https://eliheuer.github.io/GTL001/fontbakery/fontbakery-report.html)
[![][Shaping]](https://eliheuer.github.io/GTL001/fontbakery/fontbakery-report.html)

[Fontbakery]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Feliheuer%2FGTL001%2Fgh-pages%2Fbadges%2Foverall.json
[GF Profile]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Feliheuer%2FGTL001%2Fgh-pages%2Fbadges%2FGoogleFonts.json
[Outline Correctness]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Feliheuer%2FGTL001%2Fgh-pages%2Fbadges%2FOutlineCorrectnessChecks.json
[Shaping]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Feliheuer%2FGTL001%2Fgh-pages%2Fbadges%2FShapingChecks.json
[Universal]: https://img.shields.io/endpoint?url=https%3A%2F%2Fraw.githubusercontent.com%2Feliheuer%2FGTL001%2Fgh-pages%2Fbadges%2FUniversal.json

## Repository Layout

This font repository structure is inspired by [Unified Font Repository v0.3](https://github.com/unified-font-repository/Unified-Font-Repository), modified for the Google Fonts workflow.
