# - Try to find the PCRE2 library and headers
# Once done this will define
#
#  PCRE2_INCLUDE_DIR - the PCRE include directory
#  PCRE2_LIBRARIES - link these to use PCRE

if(PCRE2_INCLUDE_DIR AND PCRE2_LIBRARY)
  set(PCRE2_FIND_QUIETLY TRUE)
endif(PCRE2_INCLUDE_DIR AND PCRE2_LIBRARY)

# Include dir
find_path(PCRE2_INCLUDE_DIR NAMES pcre2.h)

# Libraries
find_library(PCRE2_LIBRARY NAMES pcre2-8)

if(PCRE2_LIBRARY)
  set(PCRE2_LIBRARIES ${PCRE2_LIBRARY})
endif(PCRE2_LIBRARY)

INCLUDE(FindPackageHandleStandardArgs)
FIND_PACKAGE_HANDLE_STANDARD_ARGS(PCRE2 DEFAULT_MSG PCRE2_LIBRARIES PCRE2_INCLUDE_DIR)

MARK_AS_ADVANCED(PCRE2_LIBRARIES PCRE2_INCLUDE_DIR PCRE2_LIBRARY)

