// This file is auto-generated by @hey-api/openapi-ts


import type { CancelablePromise } from './core/CancelablePromise';
import { OpenAPI } from './core/OpenAPI';
import { request as __request } from './core/request';
import type { $OpenApiTs } from './types.gen';

export class UsageService {
    /**
 * Health
 * @returns unknown Successful Response
 * @throws ApiError
 */
    public static healthHealthGet(): CancelablePromise<$OpenApiTs['/health']['get']['res'][200]> {
        return __request(OpenAPI, {
    method: 'GET',
    url: '/health'
});
    }
    
    /**
 * Delete Subject
 * @returns unknown Successful Response
 * @throws ApiError
 */
    public static deleteSubjectSubjectsSubjectIdDelete(data: $OpenApiTs['/subjects/{subject_id}']['delete']['req']): CancelablePromise<$OpenApiTs['/subjects/{subject_id}']['delete']['res'][200]> {
        const { subjectId } = data;
        return __request(OpenAPI, {
    method: 'DELETE',
    url: '/subjects/{subject_id}',
    path: {
        subject_id: subjectId
    },
    errors: {
        422: 'Validation Error'
    }
});
    }
    
    /**
 * Get Usage Summary
 * @returns UsageSummary Successful Response
 * @throws ApiError
 */
    public static getUsageSummarySubjectsSubjectIdGet(data: $OpenApiTs['/subjects/{subject_id}']['get']['req']): CancelablePromise<$OpenApiTs['/subjects/{subject_id}']['get']['res'][200]> {
        const { subjectId } = data;
        return __request(OpenAPI, {
    method: 'GET',
    url: '/subjects/{subject_id}',
    path: {
        subject_id: subjectId
    },
    errors: {
        422: 'Validation Error'
    }
});
    }
    
    /**
 * Record Usage Transaction
 * @returns UsageSummary Successful Response
 * @throws ApiError
 */
    public static recordUsageTransactionSubjectsSubjectIdTransactionsPost(data: $OpenApiTs['/subjects/{subject_id}/transactions']['post']['req']): CancelablePromise<$OpenApiTs['/subjects/{subject_id}/transactions']['post']['res'][200]> {
        const { subjectId, requestBody } = data;
        return __request(OpenAPI, {
    method: 'POST',
    url: '/subjects/{subject_id}/transactions',
    path: {
        subject_id: subjectId
    },
    body: requestBody,
    mediaType: 'application/json',
    errors: {
        422: 'Validation Error'
    }
});
    }
    
}