---
title: SqlAlchemy
description: Description of the SqlAlchemy component
---

**Description:** A client for executing SQL queries using SQLAlchemy.
See https://docs.sqlalchemy.org/ for connection configuration details.

Performs cursory checks when `select_only` is set to True. Additionally ensure user is restricted to allowed permissions.

| Property                                   | Pattern | Type    | Deprecated | Definition | Title/Description |
| ------------------------------------------ | ------- | ------- | ---------- | ---------- | ----------------- |
| + [implementation](#implementation )       | No      | const   | No         | -          | Implementation    |
| - [protocol](#protocol )                   | No      | string  | No         | -          | Protocol          |
| - [connection_string](#connection_string ) | No      | string  | No         | -          | Connection String |
| - [engine_kwargs](#engine_kwargs )         | No      | object  | No         | -          | Engine Kwargs     |
| - [select_only](#select_only )             | No      | boolean | No         | -          | Select Only       |
| - [metadata](#metadata )                   | No      | array   | No         | -          | Metadata          |

## <a name="implementation"></a>1. Property `implementation`

**Title:** Implementation

|              |         |
| ------------ | ------- |
| **Type**     | `const` |
| **Required** | Yes     |

Specific value: `"SqlAlchemy"`

## <a name="protocol"></a>2. Property `protocol`

**Title:** Protocol

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `null`   |

## <a name="connection_string"></a>3. Property `connection_string`

**Title:** Connection String

|              |                                  |
| ------------ | -------------------------------- |
| **Type**     | `string`                         |
| **Required** | No                               |
| **Default**  | `"sqlite+aiosqlite:///:memory:"` |

**Description:** SQLAlchemy connection string. See https://docs.sqlalchemy.org/en/20/core/engines.html for more information.

## <a name="engine_kwargs"></a>4. Property `engine_kwargs`

**Title:** Engine Kwargs

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Default**               | `{}`                                                                      |

## <a name="select_only"></a>5. Property `select_only`

**Title:** Select Only

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

## <a name="metadata"></a>6. Property `metadata`

**Title:** Metadata

|              |                                                                       |
| ------------ | --------------------------------------------------------------------- |
| **Type**     | `array`                                                               |
| **Required** | No                                                                    |
| **Default**  | `[{"name": "tables", "metadata": [], "remove_falsy_metadata": true}]` |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be      | Description |
| ------------------------------------ | ----------- |
| [MetadataAttribute](#metadata_items) | -           |

### <a name="autogenerated_heading_1"></a>6.1. MetadataAttribute

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #/$defs/MetadataAttribute                                                 |

| Property                                                          | Pattern | Type        | Deprecated | Definition | Title/Description     |
| ----------------------------------------------------------------- | ------- | ----------- | ---------- | ---------- | --------------------- |
| + [name](#metadata_items_name )                                   | No      | string      | No         | -          | Name                  |
| - [metadata](#metadata_items_metadata )                           | No      | Combination | No         | -          | Metadata              |
| - [remove_falsy_metadata](#metadata_items_remove_falsy_metadata ) | No      | boolean     | No         | -          | Remove Falsy Metadata |

#### <a name="metadata_items_name"></a>6.1.1. Property `name`

**Title:** Name

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

#### <a name="metadata_items_metadata"></a>6.1.2. Property `metadata`

**Title:** Metadata

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `combining`                                                               |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Default**               | `[]`                                                                      |

| Any of(Option)                              |
| ------------------------------------------- |
| [item 0](#metadata_items_metadata_anyOf_i0) |
| [item 1](#metadata_items_metadata_anyOf_i1) |

##### <a name="metadata_items_metadata_anyOf_i0"></a>6.1.2.1. Property `item 0`

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                              | Description |
| ------------------------------------------------------------ | ----------- |
| [MetadataAttribute](#metadata_items_metadata_anyOf_i0_items) | -           |

###### <a name="autogenerated_heading_2"></a>6.1.2.1.1. MetadataAttribute

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Same definition as**    | [MetadataAttribute](#metadata_items)                                      |

##### <a name="metadata_items_metadata_anyOf_i1"></a>6.1.2.2. Property `item 1`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                         | Description |
| ------------------------------------------------------- | ----------- |
| [item 1 items](#metadata_items_metadata_anyOf_i1_items) | -           |

###### <a name="autogenerated_heading_3"></a>6.1.2.2.1. item 1 items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

#### <a name="metadata_items_remove_falsy_metadata"></a>6.1.3. Property `remove_falsy_metadata`

**Title:** Remove Falsy Metadata

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `true`    |

----------------------------------------------------------------------------------------------------------------------------
