---
title: AzureOpenAIConnectionHandler
description: Description of the AzureOpenAIConnectionHandler component
---

**Description:** Automatically infers the values from environment variables for:
    - `api_key` from `AZURE_OPENAI_API_KEY` (IFF `api_key` AND 'azure_ad_token_provider' is not provided)
    - `organization` from `OPENAI_ORG_ID`
    - `azure_ad_token` from `AZURE_OPENAI_AD_TOKEN`
    - `api_version` from `OPENAI_API_VERSION`
    - `azure_endpoint` from `AZURE_OPENAI_ENDPOINT`

| Property                                               | Pattern | Type            | Deprecated | Definition            | Title/Description     |
| ------------------------------------------------------ | ------- | --------------- | ---------- | --------------------- | --------------------- |
| + [implementation](#implementation )                   | No      | const           | No         | -                     | Implementation        |
| - [azure_ad_token_provider](#azure_ad_token_provider ) | No      | object          | No         | In #/$defs/_Reference | -                     |
| - [token_provider_scopes](#token_provider_scopes )     | No      | array of string | No         | -                     | Token Provider Scopes |
| - [api_version](#api_version )                         | No      | string          | No         | -                     | Api Version           |
| - [](#additionalProperties )                           | No      | object          | No         | -                     | -                     |

## <a name="implementation"></a>1. Property `implementation`

**Title:** Implementation

|              |         |
| ------------ | ------- |
| **Type**     | `const` |
| **Required** | Yes     |

Specific value: `"AzureOpenAIConnectionHandler"`

## <a name="azure_ad_token_provider"></a>2. Property `azure_ad_token_provider`

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #/$defs/_Reference                                                        |

| Property                                                     | Pattern | Type   | Deprecated | Definition | Title/Description |
| ------------------------------------------------------------ | ------- | ------ | ---------- | ---------- | ----------------- |
| - [implementation](#azure_ad_token_provider_implementation ) | No      | string | No         | -          | Implementation    |
| - [](#azure_ad_token_provider_additionalProperties )         | No      | object | No         | -          | -                 |

### <a name="azure_ad_token_provider_implementation"></a>2.1. Property `implementation`

**Title:** Implementation

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

## <a name="token_provider_scopes"></a>3. Property `token_provider_scopes`

**Title:** Token Provider Scopes

|              |                                                    |
| ------------ | -------------------------------------------------- |
| **Type**     | `array of string`                                  |
| **Required** | No                                                 |
| **Default**  | `["https://cognitiveservices.azure.com/.default"]` |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                             | Description |
| ----------------------------------------------------------- | ----------- |
| [token_provider_scopes items](#token_provider_scopes_items) | -           |

### <a name="autogenerated_heading_1"></a>3.1. token_provider_scopes items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

## <a name="api_version"></a>4. Property `api_version`

**Title:** Api Version

|              |                |
| ------------ | -------------- |
| **Type**     | `string`       |
| **Required** | No             |
| **Default**  | `"2024-02-01"` |

----------------------------------------------------------------------------------------------------------------------------
