---
title: MarkdownTextSplitter
description: Description of the MarkdownTextSplitter component
---

| Property                                     | Pattern | Type            | Deprecated | Definition | Title/Description  |
| -------------------------------------------- | ------- | --------------- | ---------- | ---------- | ------------------ |
| + [implementation](#implementation )         | No      | const           | No         | -          | Implementation     |
| - [chunk_size](#chunk_size )                 | No      | integer         | No         | -          | Chunk Size         |
| - [chunk_overlap](#chunk_overlap )           | No      | integer         | No         | -          | Chunk Overlap      |
| - [keep_separator](#keep_separator )         | No      | boolean         | No         | -          | Keep Separator     |
| - [strip_whitespace](#strip_whitespace )     | No      | boolean         | No         | -          | Strip Whitespace   |
| - [separators](#separators )                 | No      | array of string | No         | -          | Separators         |
| - [is_separator_regex](#is_separator_regex ) | No      | boolean         | No         | -          | Is Separator Regex |

## <a name="implementation"></a>1. Property `implementation`

**Title:** Implementation

|              |         |
| ------------ | ------- |
| **Type**     | `const` |
| **Required** | Yes     |

Specific value: `"MarkdownTextSplitter"`

## <a name="chunk_size"></a>2. Property `chunk_size`

**Title:** Chunk Size

|              |           |
| ------------ | --------- |
| **Type**     | `integer` |
| **Required** | No        |
| **Default**  | `4000`    |

**Description:** Maximum size of chunks to return

## <a name="chunk_overlap"></a>3. Property `chunk_overlap`

**Title:** Chunk Overlap

|              |           |
| ------------ | --------- |
| **Type**     | `integer` |
| **Required** | No        |
| **Default**  | `200`     |

**Description:** Overlap in characters between chunks

## <a name="keep_separator"></a>4. Property `keep_separator`

**Title:** Keep Separator

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

**Description:** Whether to keep the separator in the chunks

## <a name="strip_whitespace"></a>5. Property `strip_whitespace`

**Title:** Strip Whitespace

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `true`    |

**Description:** If `True`, strips whitespace from the start and end of every document

## <a name="separators"></a>6. Property `separators`

**Title:** Separators

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |
| **Default**  | `null`            |

**Description:** Separators to split on

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be       | Description |
| ------------------------------------- | ----------- |
| [separators items](#separators_items) | -           |

### <a name="autogenerated_heading_1"></a>6.1. separators items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

## <a name="is_separator_regex"></a>7. Property `is_separator_regex`

**Title:** Is Separator Regex

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

**Description:** Whether the separator is a regex

----------------------------------------------------------------------------------------------------------------------------
