---
title: GitLoader
description: Description of the GitLoader component
---

**Description:** Loads files from a git repository. Uses raw git protocols, so this is not a GitHub specific implementation.

| Property                             | Pattern | Type        | Deprecated | Definition | Title/Description |
| ------------------------------------ | ------- | ----------- | ---------- | ---------- | ----------------- |
| + [implementation](#implementation ) | No      | const       | No         | -          | Implementation    |
| + [url](#url )                       | No      | string      | No         | -          | Url               |
| - [branch](#branch )                 | No      | string      | No         | -          | Branch            |
| - [pattern](#pattern )               | No      | Combination | No         | -          | Pattern           |
| - [exclude](#exclude )               | No      | Combination | No         | -          | Exclude           |

## <a name="implementation"></a>1. Property `implementation`

**Title:** Implementation

|              |         |
| ------------ | ------- |
| **Type**     | `const` |
| **Required** | Yes     |

Specific value: `"GitLoader"`

## <a name="url"></a>2. Property `url`

**Title:** Url

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | Yes      |

**Description:** URL for source repository. Will be templated with envars.

**Examples:** 

```yaml
https://github.com/eidolon-ai/eidolon.git
```

```yaml
https://{GITHUB_TOKEN}@github.com/eidolon-ai/eidolon.git
```

## <a name="branch"></a>3. Property `branch`

**Title:** Branch

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `"HEAD"` |

**Description:** Branch, ref, or commit to load files from.

## <a name="pattern"></a>4. Property `pattern`

**Title:** Pattern

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `combining`                                                               |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Default**               | `"**"`                                                                    |

**Description:** Blob pattern(s) of files to include.

| Any of(Option)              |
| --------------------------- |
| [item 0](#pattern_anyOf_i0) |
| [item 1](#pattern_anyOf_i1) |

### <a name="pattern_anyOf_i0"></a>4.1. Property `item 0`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

### <a name="pattern_anyOf_i1"></a>4.2. Property `item 1`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be         | Description |
| --------------------------------------- | ----------- |
| [item 1 items](#pattern_anyOf_i1_items) | -           |

#### <a name="autogenerated_heading_1"></a>4.2.1. item 1 items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

## <a name="exclude"></a>5. Property `exclude`

**Title:** Exclude

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `combining`                                                               |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Default**               | `[]`                                                                      |

**Description:** Blob pattern(s) of files to exclude. Calculated after pattern (ei, files from pattern are selected, then any matching exclude are removed).

| Any of(Option)              |
| --------------------------- |
| [item 0](#exclude_anyOf_i0) |
| [item 1](#exclude_anyOf_i1) |

### <a name="exclude_anyOf_i0"></a>5.1. Property `item 0`

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

### <a name="exclude_anyOf_i1"></a>5.2. Property `item 1`

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be         | Description |
| --------------------------------------- | ----------- |
| [item 1 items](#exclude_anyOf_i1_items) | -           |

#### <a name="autogenerated_heading_2"></a>5.2.1. item 1 items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

----------------------------------------------------------------------------------------------------------------------------
