---
title: SimpleAgent
description: Description of the SimpleAgent component
---

**Description:** agent is designed to be a flexible, modular component that can interact with various processing units and perform a
range of actions based on its configuration.

| Property                                           | Pattern | Type                          | Deprecated | Definition | Title/Description     |
| -------------------------------------------------- | ------- | ----------------------------- | ---------- | ---------- | --------------------- |
| + [implementation](#implementation )               | No      | const                         | No         | -          | Implementation        |
| - [apu](#apu )                                     | No      | [Reference[APU]](/docs/components/apu/overview)                | No         | -          | -                     |
| - [agent_refs](#agent_refs )                       | No      | array of string               | No         | -          | Agent Refs            |
| - [tools](#tools )                                 | No      | array of [Reference[LogicUnit]](/docs/components/logicunit/overview) | No         | -          | Tools                 |
| - [description](#description )                     | No      | string                        | No         | -          | Description           |
| - [system_prompt](#system_prompt )                 | No      | string                        | No         | -          | System Prompt         |
| - [actions](#actions )                             | No      | array                         | No         | -          | Actions               |
| - [apus](#apus )                                   | No      | array                         | No         | -          | Apus                  |
| - [title_generation_mode](#title_generation_mode ) | No      | enum (of string)              | No         | -          | Title Generation Mode |
| - [prompt_templates](#prompt_templates )           | No      | object                        | No         | -          | Prompt Templates      |

## <a name="implementation"></a>1. Property `implementation`

**Title:** Implementation

|              |         |
| ------------ | ------- |
| **Type**     | `const` |
| **Required** | Yes     |

Specific value: `"SimpleAgent"`

## <a name="apu"></a>2. Property `apu`

|              |                             |
| ------------ | --------------------------- |
| **Type**     | [`Reference[APU]`](/docs/components/apu/overview)            |
| **Required** | No                          |
| **Default**  | `{"implementation": "APU"}` |

## <a name="agent_refs"></a>3. Property `agent_refs`

**Title:** Agent Refs

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |
| **Default**  | `[]`              |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be       | Description |
| ------------------------------------- | ----------- |
| [agent_refs items](#agent_refs_items) | -           |

### <a name="autogenerated_heading_1"></a>3.1. agent_refs items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

## <a name="tools"></a>4. Property `tools`

**Title:** Tools

|              |                                 |
| ------------ | ------------------------------- |
| **Type**     | `array of [Reference[LogicUnit]](/docs/components/logicunit/overview)` |
| **Required** | No                              |
| **Default**  | `[]`                            |

**Description:** A list of [tools](https://www.eidolonai.com/docs/components/logicunit/overview) available to the agent.

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be | Description |
| ------------------------------- | ----------- |
| [tools items](#tools_items)     | -           |

### <a name="autogenerated_heading_2"></a>4.1. tools items

|              |                                                                 |
| ------------ | --------------------------------------------------------------- |
| **Type**     | [`Reference[LogicUnit]`](/docs/components/logicunit/overview)                                          |
| **Required** | No                                                              |
| **Default**  | `{"implementation": "eidolon_ai_sdk.apu.logic_unit.LogicUnit"}` |

## <a name="description"></a>5. Property `description`

**Title:** Description

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `null`   |

## <a name="system_prompt"></a>6. Property `system_prompt`

**Title:** System Prompt

|              |                                                                                                       |
| ------------ | ----------------------------------------------------------------------------------------------------- |
| **Type**     | `string`                                                                                              |
| **Required** | No                                                                                                    |
| **Default**  | `"You are a helpful assistant. Always use the provided tools, if appropriate, to complete the task."` |

## <a name="actions"></a>7. Property `actions`

**Title:** Actions

|              |                                                                                                                                                                                                                                                                                                   |
| ------------ | ------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------------- |
| **Type**     | `array`                                                                                                                                                                                                                                                                                           |
| **Required** | No                                                                                                                                                                                                                                                                                                |
| **Default**  | `[{"name": "converse", "title": null, "sub_title": null, "description": null, "user_prompt": "{{ body }}", "input_schema": {}, "output_schema": "str", "allow_file_upload": false, "supported_mime_types": [], "allowed_states": ["initialized", "idle", "http_error"], "output_state": "idle"}]` |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be    | Description |
| ---------------------------------- | ----------- |
| [ActionDefinition](#actions_items) | -           |

### <a name="autogenerated_heading_3"></a>7.1. ActionDefinition

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #/$defs/ActionDefinition                                                  |

| Property                                                       | Pattern | Type            | Deprecated | Definition | Title/Description    |
| -------------------------------------------------------------- | ------- | --------------- | ---------- | ---------- | -------------------- |
| - [name](#actions_items_name )                                 | No      | string          | No         | -          | Name                 |
| - [title](#actions_items_title )                               | No      | string          | No         | -          | Title                |
| - [sub_title](#actions_items_sub_title )                       | No      | string          | No         | -          | Sub Title            |
| - [description](#actions_items_description )                   | No      | string          | No         | -          | Description          |
| - [user_prompt](#actions_items_user_prompt )                   | No      | string          | No         | -          | User Prompt          |
| - [input_schema](#actions_items_input_schema )                 | No      | object          | No         | -          | Input Schema         |
| - [output_schema](#actions_items_output_schema )               | No      | Combination     | No         | -          | Output Schema        |
| - [allow_file_upload](#actions_items_allow_file_upload )       | No      | boolean         | No         | -          | Allow File Upload    |
| - [supported_mime_types](#actions_items_supported_mime_types ) | No      | array of string | No         | -          | Supported Mime Types |
| - [allowed_states](#actions_items_allowed_states )             | No      | array of string | No         | -          | Allowed States       |
| - [output_state](#actions_items_output_state )                 | No      | string          | No         | -          | Output State         |

#### <a name="actions_items_name"></a>7.1.1. Property `name`

**Title:** Name

|              |              |
| ------------ | ------------ |
| **Type**     | `string`     |
| **Required** | No           |
| **Default**  | `"converse"` |

#### <a name="actions_items_title"></a>7.1.2. Property `title`

**Title:** Title

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `null`   |

#### <a name="actions_items_sub_title"></a>7.1.3. Property `sub_title`

**Title:** Sub Title

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `null`   |

#### <a name="actions_items_description"></a>7.1.4. Property `description`

**Title:** Description

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `null`   |

#### <a name="actions_items_user_prompt"></a>7.1.5. Property `user_prompt`

**Title:** User Prompt

|              |                |
| ------------ | -------------- |
| **Type**     | `string`       |
| **Required** | No             |
| **Default**  | `"{{ body }}"` |

#### <a name="actions_items_input_schema"></a>7.1.6. Property `input_schema`

**Title:** Input Schema

|                           |                                                                                                                                      |
| ------------------------- | ------------------------------------------------------------------------------------------------------------------------------------ |
| **Type**                  | `object`                                                                                                                             |
| **Required**              | No                                                                                                                                   |
| **Additional properties** | [[Should-conform]](#actions_items_input_schema_additionalProperties "Each additional property must conform to the following schema") |
| **Default**               | `{}`                                                                                                                                 |

| Property                                                | Pattern | Type   | Deprecated | Definition | Title/Description |
| ------------------------------------------------------- | ------- | ------ | ---------- | ---------- | ----------------- |
| - [](#actions_items_input_schema_additionalProperties ) | No      | object | No         | -          | -                 |

##### <a name="actions_items_input_schema_additionalProperties"></a>7.1.6.1. Property `additionalProperties`

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |

#### <a name="actions_items_output_schema"></a>7.1.7. Property `output_schema`

**Title:** Output Schema

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `combining`                                                               |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Default**               | `"str"`                                                                   |

| Any of(Option)                                  |
| ----------------------------------------------- |
| [item 0](#actions_items_output_schema_anyOf_i0) |
| [item 1](#actions_items_output_schema_anyOf_i1) |

##### <a name="actions_items_output_schema_anyOf_i0"></a>7.1.7.1. Property `item 0`

|              |         |
| ------------ | ------- |
| **Type**     | `const` |
| **Required** | No      |

Must be one of:
* "str"
Specific value: `"str"`

##### <a name="actions_items_output_schema_anyOf_i1"></a>7.1.7.2. Property `item 1`

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |

#### <a name="actions_items_allow_file_upload"></a>7.1.8. Property `allow_file_upload`

**Title:** Allow File Upload

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

#### <a name="actions_items_supported_mime_types"></a>7.1.9. Property `supported_mime_types`

**Title:** Supported Mime Types

|              |                   |
| ------------ | ----------------- |
| **Type**     | `array of string` |
| **Required** | No                |
| **Default**  | `[]`              |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                                         | Description |
| ----------------------------------------------------------------------- | ----------- |
| [supported_mime_types items](#actions_items_supported_mime_types_items) | -           |

##### <a name="autogenerated_heading_4"></a>7.1.9.1. supported_mime_types items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

#### <a name="actions_items_allowed_states"></a>7.1.10. Property `allowed_states`

**Title:** Allowed States

|              |                                         |
| ------------ | --------------------------------------- |
| **Type**     | `array of string`                       |
| **Required** | No                                      |
| **Default**  | `["initialized", "idle", "http_error"]` |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be                             | Description |
| ----------------------------------------------------------- | ----------- |
| [allowed_states items](#actions_items_allowed_states_items) | -           |

##### <a name="autogenerated_heading_5"></a>7.1.10.1. allowed_states items

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |

#### <a name="actions_items_output_state"></a>7.1.11. Property `output_state`

**Title:** Output State

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `"idle"` |

## <a name="apus"></a>8. Property `apus`

**Title:** Apus

|              |         |
| ------------ | ------- |
| **Type**     | `array` |
| **Required** | No      |
| **Default**  | `[]`    |

|                      | Array restrictions |
| -------------------- | ------------------ |
| **Min items**        | N/A                |
| **Max items**        | N/A                |
| **Items unicity**    | False              |
| **Additional items** | False              |
| **Tuple validation** | See below          |

| Each item of this array must be | Description |
| ------------------------------- | ----------- |
| [NamedAPU](#apus_items)         | -           |

### <a name="autogenerated_heading_6"></a>8.1. NamedAPU

|                           |                                                                           |
| ------------------------- | ------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                  |
| **Required**              | No                                                                        |
| **Additional properties** | [[Any type: allowed]](# "Additional Properties of any type are allowed.") |
| **Defined in**            | #/$defs/NamedAPU                                                          |

| Property                          | Pattern | Type           | Deprecated | Definition | Title/Description |
| --------------------------------- | ------- | -------------- | ---------- | ---------- | ----------------- |
| - [title](#apus_items_title )     | No      | string         | No         | -          | Title             |
| - [apu](#apus_items_apu )         | No      | [Reference[APU]](/docs/components/apu/overview) | No         | -          | -                 |
| - [default](#apus_items_default ) | No      | boolean        | No         | -          | Default           |

#### <a name="apus_items_title"></a>8.1.1. Property `title`

**Title:** Title

|              |          |
| ------------ | -------- |
| **Type**     | `string` |
| **Required** | No       |
| **Default**  | `null`   |

#### <a name="apus_items_apu"></a>8.1.2. Property `apu`

|              |                             |
| ------------ | --------------------------- |
| **Type**     | [`Reference[APU]`](/docs/components/apu/overview)            |
| **Required** | No                          |
| **Default**  | `{"implementation": "APU"}` |

#### <a name="apus_items_default"></a>8.1.3. Property `default`

**Title:** Default

|              |           |
| ------------ | --------- |
| **Type**     | `boolean` |
| **Required** | No        |
| **Default**  | `false`   |

## <a name="title_generation_mode"></a>9. Property `title_generation_mode`

**Title:** Title Generation Mode

|              |                    |
| ------------ | ------------------ |
| **Type**     | `enum (of string)` |
| **Required** | No                 |
| **Default**  | `"none"`           |

Must be one of:
* "none"
* "on_request"
* "auto"

## <a name="prompt_templates"></a>10. Property `prompt_templates`

**Title:** Prompt Templates

|                           |                                                                                                                            |
| ------------------------- | -------------------------------------------------------------------------------------------------------------------------- |
| **Type**                  | `object`                                                                                                                   |
| **Required**              | No                                                                                                                         |
| **Additional properties** | [[Should-conform]](#prompt_templates_additionalProperties "Each additional property must conform to the following schema") |
| **Default**               | `{}`                                                                                                                       |

**Description:** A dictionary of Templates that can be used as jinja2 keys in system or action prompts

| Property                                      | Pattern | Type                | Deprecated | Definition | Title/Description |
| --------------------------------------------- | ------- | ------------------- | ---------- | ---------- | ----------------- |
| - [](#prompt_templates_additionalProperties ) | No      | [Reference[Template]](/docs/components/template/overview) | No         | -          | -                 |

### <a name="prompt_templates_additionalProperties"></a>10.1. Property `additionalProperties`

|              |                                                                    |
| ------------ | ------------------------------------------------------------------ |
| **Type**     | [`Reference[Template]`](/docs/components/template/overview)                                              |
| **Required** | No                                                                 |
| **Default**  | `{"implementation": "eidolon_ai_sdk.agent.simple_agent.Template"}` |

----------------------------------------------------------------------------------------------------------------------------
