# Vector Store API

Welcome to the Vector Store API project! This project aims to provide an efficient and scalable API for embedding and storing vectors, leveraging the power of FastAPI, Langchain and a vector database such as Chroma. Whether you're dealing with text, images, or any data that needs to be converted into vectors and retrieved via similarity search, this API has got you covered. 😄🚀

## Features

- **File and Text Embedding**: Upload your files or text, and let the API handle the embedding into vectors.
- **Vector Storage**: Seamlessly store your vectors in Chroma for efficient retrieval.
- **Similarity Search**: Find the most similar vectors stored in the database with a simple query.
- **Scalable and Fast**: Built with FastAPI, this project is designed for speed and can handle high volumes of requests.

## Getting Started

These instructions will get your copy of the project up and running on your local machine for development and testing purposes. 🌐💻

### Project Roadmap & Tasks List 📊👣

#### 1. Project Setup 🛠️

- [x] **Task 1:** Setup a virtual environment for project to manage dependencies.

- [x] **Task 2:** Install FastAPI and Uvicorn (ASGI server) using pip.

- [x] **Task 3:** Install Chroma or any other vector database client library project will use.

#### 2. Designing the API 🎨

- [ ] **Task 1:** Define the endpoints we'll need. Consider the following:

  - [x] An endpoint for uploading files or text to be vectorized.

  - [ ] An endpoint to search through the stored vectors using similarity search.

  - [ ] An endpoint to list or retrieve specific vectors or their metadata.

- [ ] **Task 2:** Plan out the request and response models for endpoints using Pydantic models.

#### 3. Implementing Endpoints 🛠️👨‍💻

- [x] **Task 1:** Implement the file/text upload endpoint.

  - [x] Parse the input data.
  
  - [x] Embed the input into a vector form (you might need an external library or service for embedding, such as TensorFlow for images or Hugging Face's transformers for text).

  - [x] Store the vector in Chroma with relevant metadata.

- [ ] **Task 2:** Implement the search endpoint.

  - [ ] Accept a query as input and convert it into a vector.

  - [ ] Perform a similarity search in Chroma.

  - [ ] Return the closest matches.

- [ ] **Task 3:** Implement auxiliary endpoints as needed (for listing, updating, or deleting vectors).

#### 4. Vector Database Integration 🗂️↔️🚀

- [x] **Task 1:** Choose a suitable vector database (Chroma, in this case).

- [x] **Task 2:** Implement data storage logic for vectors.

- [x] **Task 3:** Implement retrieval and search logic using Chroma's search capabilities.

#### 5. Testing 🧪

- [ ] **Task 1:** Write unit tests for your API endpoints to ensure they're functioning as expected.

- [ ] **Task 2:** Test vector storage and retrieval functionality in Chroma.

- [ ] **Task 3:** Perform end[]to[]end tests of the entire API.

#### 6. Documentation & Deployment 📄✈️

- [ ] **Task 1:** Document API using FastAPI’s built[]in Swagger UI.

- [ ] **Task 2:** Prepare the project for deployment (consider using Docker for containerization).

- [ ] **Task 3:** Deploy API (options include Heroku, AWS, or GCP).

## Contributing

Contributions are what make the open-source community an amazing place to learn, inspire, and create. Any contributions you make are **greatly appreciated**. 😊👍

## License

This project is licensed under the MIT License - see the [LICENSE.md](LICENSE) file for details.

## Acknowledgments

- FastAPI Team for an amazing framework.
- The vector database client used in this project.
- LangChain framework for developing applications powered by large language models (LLMs).
- All contributors and supporters of the project.
