"""Global imports."""

"""Copyright (C) 2023 Edward West. All rights reserved.

This code is licensed under Apache 2.0 with Commons Clause license
(see LICENSE for details).
"""

from pybroker.cache import (
    clear_caches,
    clear_data_source_cache,
    clear_indicator_cache,
    clear_model_cache,
    disable_caches,
    disable_data_source_cache,
    disable_indicator_cache,
    disable_model_cache,
    enable_caches,
    enable_data_source_cache,
    enable_indicator_cache,
    enable_model_cache,
)
from pybroker.common import BarData, DataCol, Day, FeeMode, PriceType
from pybroker.context import ExecContext, ExecSignal, PosSizeContext
from pybroker.config import StrategyConfig
from pybroker.data import Alpaca, AlpacaCrypto, YFinance
from pybroker.eval import EvalMetrics, BootstrapResult
from pybroker.indicator import (
    Indicator,
    IndicatorSet,
    highest,
    indicator,
    lowest,
    returns,
)
from pybroker.model import ModelLoader, ModelSource, ModelTrainer, model
from pybroker.portfolio import Entry, Order, Position, Trade
from pybroker.scope import (
    disable_logging,
    enable_logging,
    disable_progress_bar,
    enable_progress_bar,
    param,
    register_columns,
    unregister_columns,
)
from pybroker.slippage import RandomSlippageModel
from pybroker.strategy import Strategy, TestResult
from pybroker.vect import cross, highv, lowv, returnv, sumv

# Temporary fix for regression in Numba 0.57.0
# https://github.com/numba/numba/issues/8940
from numba.np.unsafe import ndarray

__version__ = "1.2.6"
