<h1 align="center">
  <b>Awesome Hacker Search Engines</b> <img src="https://raw.githubusercontent.com/edoardottt/images/main/awesome-hacker-search-engines/awesome.svg"/>
</h1>

<p align="center">
A curated list of awesome search engines useful during Penetration testing, Vulnerability assessments, Red/Blue Team operations, Bug Bounty and more
</p>

<p align="center">
  <a href="#general-search-engines">General</a> •
  <a href="#servers">Servers</a> •
  <a href="#vulnerabilities">Vulnerabilities</a> •
  <a href="#exploits">Exploits</a> •
  <a href="#attack-surface">Attack surface</a> •
  <a href="#code">Code</a> •
  <a href="#mail-addresses">Mail addresses</a> •
  <a href="#domains">Domains</a> •
  <a href="#urls">URLs</a> •
  <a href="#dns">DNS</a> •
  <a href="#certificates">Certificates</a> •
  <a href="#wifi-networks">WiFi networks</a> •
  <a href="#device-information">Device Info</a> •
  <a href="#credentials">Credentials</a> •
  <a href="#leaks">Leaks</a> •
  <a href="#hidden-services">Hidden Services</a> •
  <a href="#social-networks">Social Networks</a> •
  <a href="#phone-numbers">Phone numbers</a> •
  <a href="#images">Images</a> •
  <a href="#threat-intelligence">Threat Intelligence</a> •
  <a href="#web-history">Web History</a> •
  <a href="#surveillance-cameras">Surveillance cameras</a> •
  <a href="#crypto">Crypto</a> •
  <a href="#people">People</a>
</p>

### General Search Engines

- [Google](https://www.google.com/)
- [Bing](https://www.bing.com/)
- [Yahoo!](http://www.yahoo.com/)
- [Yandex](https://yandex.com/)
- [Ask](https://www.ask.com/)
- [Baidu](https://www.baidu.com/)
- [SearXNG](https://searx.be/?q=)
- [EXALead](http://www.exalead.com/search/web/)
- [DuckDuckGo](https://duckduckgo.com/)
- [Swisscows](https://swisscows.com/en)
- [Naver](https://www.naver.com/)
- [AOL](https://search.aol.com)
- [Brave](https://search.brave.com/)
- [Yep](https://yep.com/)
- [Gibiru](https://gibiru.com/)
- [Kagi](https://kagi.com/)
- [Stract](https://stract.com/)

### Servers

- [Shodan](https://shodan.io) - Search Engine for the Internet of Everything
- [Censys Search](https://search.censys.io/) - Search Engine for every server on the Internet to reduce exposure and improve security
- [Onyphe.io](https://www.onyphe.io/) - Cyber Defense Search Engine for open-source and cyber threat intelligence data
- [ZoomEye](https://www.zoomeye.org/) - Global cyberspace mapping
- [GreyNoise](https://viz.greynoise.io/) - The source for understanding internet noise
- [Natlas](https://natlas.io/) - Scaling Network Scanning
- [Netlas.io](https://netlas.io/) - Discover, Research and Monitor any Assets Available Online
- [FOFA](https://fofa.info/) - Cyberspace mapping
- [Quake](https://quake.360.net/quake/#/index) - Cyberspace surveying and mapping system
- [Hunter](https://hunter.how/) - Internet Search Engines For Security Researchers
- [ODIN](https://getodin.com/) - One of the most powerful search engines for Scanned Internet Assets

### Vulnerabilities

- [NIST NVD](https://nvd.nist.gov/vuln/search) - US National Vulnerability Database
- [MITRE CVE](https://cve.mitre.org/cve/search_cve_list.html) - Identify, define, and catalog publicly disclosed cybersecurity vulnerabilities
- [GitHub Advisory Database](https://github.com/advisories) - Security vulnerability database inclusive of CVEs and GitHub originated security advisories
- [cloudvulndb.org](https://www.cloudvulndb.org/) - The Open Cloud Vulnerability & Security Issue Database
- [osv.dev](https://osv.dev/list) - Open Source Vulnerabilities
- [Vulners.com](https://vulners.com/) - Your Search Engine for Security Intelligence
- [opencve.io](https://www.opencve.io/cve) - Easiest way to track CVE updates and be alerted about new vulnerabilities
- [security.snyk.io](https://security.snyk.io/) - Open Source Vulnerability Database
- [Mend Vulnerability Database](https://www.mend.io/vulnerability-database/) - The largest open source vulnerability DB
- [Rapid7 - DB](https://www.rapid7.com/db/) - Vulnerability & Exploit Database
- [CVEDetails](https://www.cvedetails.com/) - The ultimate security vulnerability datasource
- [VulnIQ](https://vulniq.com/) - Vulnerability intelligence and management solution
- [SynapsInt](https://synapsint.com/) - The unified OSINT research tool
- [Aqua Vulnerability Database](https://avd.aquasec.com/) - Vulnerabilities and weaknesses in open source applications and cloud native infrastructure
- [Vulmon](https://vulmon.com/) - Vulnerability and exploit search engine
- [VulDB](https://vuldb.com/) - Number one vulnerability database
- [ScanFactory](https://in.scanfactory.io/cvemon.html) - Realtime Security Monitoring
- [Trend Micro Zero Day Initiative](https://www.zerodayinitiative.com/advisories/published/) - Publicly disclosed vulnerabilities discovered by Zero Day Initiative researchers
- [Google Project Zero](https://bugs.chromium.org/p/project-zero/issues/list?can=1&q=&sort=-id&colspec=ID%20Type%20Status%20Priority%20Milestone%20Owner%20Summary) - Vulnerabilities including Zero Days
- [Trickest CVE Repository](https://github.com/trickest/cve) - Gather and update all available and newest CVEs with their PoC
- [cnvd.org.cn](https://www.cnvd.org.cn/) - Chinese National Vulnerability Database
- [InTheWild.io](https://inthewild.io/feed) - Check CVEs in our free, open source feed of exploited vulnerabilities
- [Vulnerability Lab](https://www.vulnerability-lab.com/) - Vulnerability research, bug bounties and vulnerability assessments
- [Red Hat Security Advisories](https://access.redhat.com/security/security-updates/) - Information about security flaws that affect Red Hat products and services in the form of security advisories
- [Cisco Security Advisories](https://sec.cloudapps.cisco.com/security/center/publicationListing.x) - Security advisories and vulnerability information for Cisco products, including network equipment and software
- [Microsoft Security Response Center](https://msrc.microsoft.com/update-guide/en-us) - Reports of security vulnerabilities affecting Microsoft products and services
- [VARIoT](https://www.variotdbs.pl/vulns/) - VARIoT IoT Vulnerabilities Database
- [Lambda Watchdog](https://lambdawatchdog.com/) - Your CVE dashboard for AWS Lambda

### Exploits

- [Exploit-DB](https://www.exploit-db.com/) - Exploit Database
- [Sploitus](https://sploitus.com/) - Convenient central place for identifying the newest exploits
- [Rapid7 - DB](https://www.rapid7.com/db/) - Vulnerability & Exploit Database
- [Vulmon](https://vulmon.com/) - Vulnerability and exploit search engine
- [packetstormsecurity.com](https://packetstormsecurity.com/) - Information Security Services, News, Files, Tools, Exploits, Advisories and Whitepapers
- [0day.today](https://0day.today/) - Ultimate database of exploits and vulnerabilities
- [LOLBAS](https://lolbas-project.github.io/) - Living Off The Land Binaries, Scripts and Libraries
- [GTFOBins](https://gtfobins.github.io/) - Curated list of Unix binaries that can be used to bypass local security restrictions in misconfigured systems
- [Payloads All The Things](https://swisskyrepo.github.io/PayloadsAllTheThings/) - A list of useful payloads and bypasses for Web Application Security
- [XSS Payloads](http://www.xss-payloads.com/) - The wonderland of JavaScript unexpected usages, and more
- [exploitalert.com](https://www.exploitalert.com/search-results.html) - Database of Exploits
- [Reverse Shell generator](https://www.revshells.com/) - Online Reverse Shell generator with Local Storage functionality, URI & Base64 Encoding, MSFVenom Generator, and Raw Mode
- [HackerOne hacktivity](https://hackerone.com/hacktivity) - See the latest hacker activity on HackerOne
- [Bugcrowd Crowdstream](https://bugcrowd.com/crowdstream) - Showcase of accepted and disclosed submissions on Bugcrowd programs
- [GTFOArgs](https://gtfoargs.github.io/) - Curated list of Unix binaries that can be manipulated for argument injection
- [shell-storm.org/shellcode](https://shell-storm.org/shellcode/index.html) - Shellcodes database for study cases
- [Hacking the Cloud](https://hackingthe.cloud/) - Encyclopedia of the attacks/tactics/techniques that offensive security professionals can use on their next cloud exploitation adventure
- [LOLDrivers](https://www.loldrivers.io/) - Open-source project that brings together vulnerable, malicious, and known malicious Windows drivers
- [PwnWiki](http://pwnwiki.io/) - Collection of TTPs (tools, tactics, and procedures) for what to do after access has been gained
- [CVExploits Search](https://cvexploits.io/) - Your comprehensive database for CVE exploits from across the internet
- [VARIoT](https://www.variotdbs.pl/exploits/) - VARIoT IoT exploits database
- [LOOBins](https://www.loobins.io/) - Detailed information on various built-in macOS binaries and how they can be used by threat actors for malicious purposes
- [Coalition Exploit Scoring System](https://ess.coalitioninc.com/) - Model that dynamically scores new and existing vulnerabilities to reflect their exploit likelihood
- [WADComs](https://wadcoms.github.io/) - Interactive cheat sheet containing a curated list of offensive security tools and their respective commands to be used against Windows/AD environments
- [LOLAPPS](https://lolapps-project.github.io/) - Compendium of applications that can be used to carry out day-to-day exploitation
- [Living off the Hardware](https://lothardware.com.tr/) - Resource collection that provides guidance on identifying and utilizing malicious hardware and malicious devices
- [Living Off the Pipeline](https://boostsecurityio.github.io/lotp/) - How development tools commonly used in CI/CD pipelines can be used to achieve arbitrary code execution
- [hackyx.io](https://hackyx.io/) - The aim of this project is to easily find any resource related to IT security like CTF writeups, articles or Bug Bounty reports
- [exploit.observer](https://www.exploit.observer/) - The World's Largest Exploit & Vulnerability Intelligence Database and is freely accessible to all
- [VulnCheck XDB](https://vulncheck.com/xdb/) - An index of exploit proof-of-concept code in Git repositories
- [Sploitify](https://sploitify.haxx.it/) - Interactive cheat sheet, containing a curated list of public server-side exploits (mostly)
- [LOLESXi](https://lolesxi-project.github.io/LOLESXi/) - Comprehensive list of binaries/scripts natively available in VMware ESXi that adversaries have utilised in their operations
- [LOLAD](https://lolad-project.github.io/) - Comprehensive collection of Active Directory techniques, commands, and functions that can be used natively to support offensive security operations and Red Team exercises

### Attack Surface

- [FullHunt.io](https://fullhunt.io/) - Attack surface database of the entire Internet
- [BinaryEdge](https://www.binaryedge.io/) - We scan the web and gather data for you
- [Censys ASM](https://censys.io/) - Attack Surface Management Solutions
- [RedHunt Labs](https://redhuntlabs.com/) - Discover your Attack Surface, Continuously
- [SecurityTrails](https://securitytrails.com/) - The Total Internet Inventory
- [overcast-security.com](https://overcast-security.com/) - We make tracking your external attack surface easy
- [IPInfo.io](https://ipinfo.io/) - The trusted source for IP address data
- [IPData.co](https://ipdata.co/) - IP Geolocation and Threat Intelligence API
- [NetworksDB](https://networksdb.io/) - Information about the public IPv4 and IPv6 addresses, networks and domains owned by companies and organisations across the world
- [ASNlookup](https://asnlookup.com/) - Quickly lookup updated information about specific Autonomous System Number (ASN), Organization, CIDR, or registered IP addresses (IPv4 and IPv6) among other relevant data
- [BGPtools](https://bgp.tools/) - Browse the Internet ecosystem
- [BGPview](https://bgpview.io/) - Debug and investigate information about IP addresses, ASN, IXs, BGP, ISPs, Prefixes and Domain names
- [BigDataCloud](https://www.bigdatacloud.com/) - The API provides comprehensive location and network data
- [RADb](https://www.radb.net/query) - The world's largest public routing registry
- [Deepinfo](https://www.deepinfo.com/) - Empower your security with the most comprehensive Internet data
- [CloudFlare Radar](https://radar.cloudflare.com/) - Global Internet traffic, attack, and technology trends and insights
- [IPIP](https://en.ipip.net/) - The only IP Database based on real time BGP/ASN data analytics
- [Hurricane Electric BGP](https://bgp.he.net/) - The Hurricane Electric BGP Toolkit is free to use. Look up ASN from IP address
- [Webscout](https://webscout.io/) - From threat intelligence to attack surface discovery, asset management, and brand protection

### Code

- [GitHub Code Search](https://github.com/search?type=code) - Search globally across all of GitHub, or scope your search to a particular repository or organization
- [GitLab Code Search](https://gitlab.com/) - Advanced search for faster, more efficient search across the entire GitLab instance
- [Sourceforge](https://sourceforge.net/) - Complete Open-Source and Business Software Platform
- [grep.app](https://grep.app/) - Search across a half million git repos
- [publicwww.com](https://publicwww.com/) - Find any alphanumeric snippet, signature or keyword in the web pages HTML, JS and CSS code
- [SearchCode](https://searchcode.com/) - Search 75 billion lines of code from 40 million projects
- [NerdyData](https://www.nerdydata.com/) - Find companies based on their website's tech stack or code
- [RepoSearch](http://codefinder.org/) - Source code search engine that helps you find implementation details, example usages or just analyze code
- [SourceGraph](https://about.sourcegraph.com/) - Understand and search across your entire codebase
- [HotExamples](https://hotexamples.com/) - Search code examples from over 1 million projects
- [WP Directory](https://wpdirectory.net/) - Lightning fast regex searching of code in the WordPress Plugin and Theme Directories
- [GitHub Gists](https://gist.github.com/discover) - Instantly share code, notes, and snippets
- [CodeBerg](https://codeberg.org/explore/repos) - Collaboration platform and Git hosting for free and open source software, content and projects
- [Fedora Pagure](https://pagure.io/browse/projects/) - Open Source software code hosting system
- [LaunchPad](https://launchpad.net/) - Software collaboration platform that provides: Bug tracking, Code hosting, Code reviews, Ubuntu package building and hosting, Translations...
- [repo.or.cz](https://repo.or.cz/?a=project_list) - Public Git hosting site
- [gitorious.org](https://gitorious.org/) - Read-only mirror of the former gitorious.org code hosting website
- [Sourcehut](https://sr.ht/projects) - Collection of tools useful for software development
- [android.googlesource.com](https://android.googlesource.com/) - Git repositories on android
- [deps.dev](https://deps.dev/) - Service developed and hosted by Google to help developers better understand the structure, construction, and security of open source software packages
- [WebFinery](https://webfinery.com/search) - Search the source code of the web
- [Google Code Archive](https://code.google.com/archive/) - Data found on the Google Code Project Hosting Service, which was turned down in early 2016
- [Snipplr](https://snipplr.com/all) - Code snippet search engine that allows users to search and share code snippets across various programming languages and frameworks
- [Postman Public Collections](https://www.postman.com/explore/collections) - Explore the best APIs, collections, workspaces in the world on the Postman Public API Network
- [ScriptMafia](https://scriptmafia.org) - Download full nulled scripts
- [SearchFTPs](https://www.searchftps.net/) - The most advanced FTP Search Engine service maintained by members
- [Ecosyste.ms](https://ecosyste.ms/) - An open API service providing package, version and dependency metadata of many open source software ecosystems and registries
- [SwaggerHub](https://app.swaggerhub.com/search) - Search public APIs and Domains in SwaggerHub

### Mail Addresses

- [Hunter.io](https://hunter.io/) - Find professional email addresses in seconds
- [PhoneBook](https://phonebook.cz/) - Lists all domains, email addresses, or URLs for the given input domain
- [IntelligenceX](https://intelx.io/) - Search engine and data archive
- [Reacher.email](https://reacher.email/) - Open-Source Email Verification
- [RocketReach](https://rocketreach.co/) - Your first-degree connection to any professional
- [email-format.com](https://www.email-format.com/) - Find the email address formats in use at thousands of companies
- [EmailHippo](https://tools.emailhippo.com/) - Email address verification technology
- [ThatsThem](https://thatsthem.com/reverse-email-lookup) - Reverse email lookup
- [verify-email.org](https://verify-email.org/) - Checks whether the mailbox exists or not
- [Melissa - Emailcheck](https://www.melissa.com/v2/lookups/emailcheck/email/) - Check email addresses and verify they are live
- [VoilaNorbert](https://www.voilanorbert.com/) - I can find anyone's email address
- [SynapsInt](https://synapsint.com/) - The unified OSINT research tool
- [skymem.info](http://www.skymem.info/) - Find email addresses of companies and people
- [findemails.com](https://www.findemails.com/) - Find Anyone's Email Address in Seconds
- [Experte email finder](https://www.experte.com/email-finder) - Find the right email address, even if you only know the name and the company
- [EmailSherlock](https://www.emailsherlock.com/) - Search for the Person behind the Email address and find our reputation score
- [Anymail Finder](https://anymailfinder.com/) - Find verified emails
- [Tomba.io](https://tomba.io/) - With 430+ million email addresses indexed, effective search filters, and deliverability checks, Tomba's email finder is its most powerful tool
- [Snov Email Finder](https://snov.io/email-finder) Find any email. Anywhere
- [EmailSearch.io](https://emailsearch.io/) - Find any emails and phones from a domain, Linkedin, name, and company
- [Email Permutator+](http://metricsparrow.com/toolkit/email-permutator/#) - Find potential email addresses permutating different combinations
- [Emailrep.io](https://emailrep.io/) - Simple Email Reputation
- [Mailboxvalidator](https://www.mailboxvalidator.com/) - Secure and reliable email validation service to check for invalid email addresses
- [ContactOut](https://contactout.com/) - Most accurate email finder for personal and work email outreach
- [validemail.io](https://validemail.io/) - Validate email addresses for deliverability with our Email Validation API
- [Predicta Search](https://www.predictasearch.com/) - Reverse lookup search engine for email and phone numbers
- [Infoga.io](Infoga.io) - Find out all email for a certain domain using search engines

### Domains

- [PhoneBook](https://phonebook.cz/) - Lists all domains, email addresses, or URLs for the given input domain
- [IntelligenceX](https://intelx.io/) - Search engine and data archive
- [Omnisint](https://omnisint.io/subdomain-enumeration) - Subdomain enumeration
- [Riddler](https://riddler.io/) - Allows you to search in a high quality dataset
- [RobTex](https://www.robtex.com/) - Various kinds of research of IP numbers, Domain names, etc
- [CentralOps - DomainDossier](https://centralops.net/co/DomainDossier.aspx) - Investigate domains and IP addresses
- [DomainIQ](https://www.domainiq.com/) - Comprehensive Domain Intelligence
- [whois.domaintools.com](https://whois.domaintools.com/) - Industry’s fastest domain discovery engine and broadest, most accurate data
- [grayhatwarfare.com - domains](https://shorteners.grayhatwarfare.com/domains) - How to search URLs exposed by Shortener services
- [whoisology.com](https://whoisology.com/) - Deep Connections Between Domain Names & Their Owners
- [who.is](https://who.is/) - WHOIS Search, Domain Name, Website, and IP Tools
- [pentest-tools.com](https://pentest-tools.com/information-gathering/find-subdomains-of-domain) - Discover subdomains and determine the attack surface of an organization
- [BuiltWith](https://builtwith.com/) - Find out what websites are Built With
- [MoonSearch](http://moonsearch.com/) - Backlinks checker & SEO Report
- [sitereport.netcraft.com](https://sitereport.netcraft.com/) - Find out the infrastructure and technologies used by any site
- [SynapsInt](https://synapsint.com/) - The unified OSINT research tool
- [statscrop.com](https://www.statscrop.com/) - Millions of amazing websites across the web are being analyzed with StatsCrop
- [securityheaders.com](https://securityheaders.com/) - Scan your site now
- [visualsitemapper.com](http://www.visualsitemapper.com/) - Create a visual map of your site
- [similarweb.com](https://www.similarweb.com/) - The easiest and fastest tool to find out what's really going on online
- [buckets.grayhatwarfare.com](https://buckets.grayhatwarfare.com/) - Public buckets
- [C99.nl](https://api.c99.nl/) - Over 57 quality API's and growing!
- [wannabe1337.xyz](https://wannabe1337.xyz/) - Online Tools
- [subdomainfinder.c99.nl](https://subdomainfinder.c99.nl/) - Scanner that scans an entire domain to find as many subdomains as possible
- [AnubisDB](https://jonlu.ca/anubis/) - Subdomain enumeration and information gathering tool
- [HypeStat](https://hypestat.com/) - Free statistics and analytics service, where you can find information about every website
- [Private Key Project](https://www.pkey.in/tools-i/search-subdomains) - Information security tools from Private Key Project
- [SiteDossier](http://www.sitedossier.com/) - Profiles for millions of sites on the web
- [SpyOnWeb](https://spyonweb.com/) - Quick and convenient search for the websites that probably belong to the same owner
- [HaveIBeenSquatted](https://www.haveibeensquatted.com/) - Check if a domain has been typosquatted
- [expireddomains.net](https://www.expireddomains.net/) - ExpiredDomains.net gathers all the information you need to find good Expired Domains that are Pending Delete and you can Backorder
- [SubDomainRadar.io](https://subdomainradar.io) - Discover hidden subdomains with unparalleled accuracy and speed

### URLs

- [PhoneBook](https://phonebook.cz/) - Lists all domains, email addresses, or URLs for the given input domain
- [IntelligenceX](https://intelx.io/) - Search engine and data archive
- [URLScan](https://urlscan.io/) - A sandbox for the web
- [HackerTarget](https://hackertarget.com/ip-tools/) - Collect information about IP Addresses, Networks, Web Pages and DNS records
- [MOZ Link Explorer](https://moz.com/link-explorer) - The world's best backlink checker with over 40 trillion links
- [shorteners.grayhatwarfare.com](https://shorteners.grayhatwarfare.com/) - Search URLs exposed by Shortener services
- [CommonCrawl Index](http://index.commoncrawl.org/) - Open repository of web crawl data
- [URLVoid](https://www.urlvoid.com/) - Check the online reputation/safety of a website
- [Norton SafeWeb](https://safeweb.norton.com/) - Look up a site, Get our rating
- [CheckPhish](https://checkphish.bolster.ai/) - Real-time URL and website scanner
- [web-check.xyz](https://web-check.xyz/) - All-in-one OSINT tool, for quickly checking a websites data
- [TinyScan](https://www.tiny-scan.com/) - Effortlessly Dive into URL Details
- [urldna.io](https://urldna.io/) - Unleash website insights! urldna.io analyzes data, monitors brands and exposes security risks

### DNS

- [DNSDumpster](https://dnsdumpster.com/) - DNS recon & research, find & lookup dns records
- [Chaos](https://chaos.projectdiscovery.io/#/) - Enhance research and analyse changes around DNS for better insights
- [RapidDNS](https://rapiddns.io/) - DNS query tool which make querying subdomains or sites of a same ip easy
- [DNSdb](https://docs.farsightsecurity.com/#dnsdb) - Passive DNS historical database
- [Omnisint](https://omnisint.io/reverse-dns-lookup) - Reverse DNS lookup
- [HackerTarget](https://hackertarget.com/ip-tools/) - Collect information about IP Addresses, Networks, Web Pages and DNS records
- [passivedns.mnemonic.no](https://passivedns.mnemonic.no/) - Web interface for querying passive DNS data collected in our malware lab
- [ptrarchive.com](http://ptrarchive.com/) - Over 230 billion reverse DNS entries from 2008 to the present
- [dnshistory.org](http://dnshistory.org/) - Domain Name System Historical Record Archive
- [DNSTwister](https://dnstwister.report/) - The anti-phishing domain name search engine and DNS monitoring service
- [DNSviz](https://dnsviz.net/) - Tool for visualizing the status of a DNS zone
- [C99.nl](https://api.c99.nl/) - Over 57 quality API's and growing
- [wannabe1337.xyz](https://wannabe1337.xyz/) - Online Tools
- [DNSlytics](https://dnslytics.com/) - Find out everything about a domain name, IP address or provider
- [dnsrepo.noc.org](https://dnsrepo.noc.org/) - DNS Database Repository Search
- [DNSSpy](https://dnsspy.io/) - Monitor, validate and verify your DNS configurations
- [ZETAlytics](https://zetalytics.com/) - We offer unrivalled geographic diversity and exclusive global network visibility in searchable datasets for use by cyber security analysts
- [AskDNS](https://askdns.com/) - Lookup Connected Domain Names and IP Addresses
- [360 PassiveDNS.CN](https://passivedns.cn/) - Biggest public available db in China designed for security and research purpose
- [MXtoolbox](https://mxtoolbox.com/SuperTool.aspx) - All of your MX record, DNS, blacklist and SMTP diagnostics in one integrated tool
- [NSLookup.io](https://www.nslookup.io/) - Find all DNS records for a domain name using this online tool
- [Robtex DNS Lookup](https://www.robtex.com/dns-lookup/) - Get detailed information on the nameservers associated with a domain name
- [DNSMap](https://dnsmap.io/) - Worldwide DNS Propagation Checker
- [Validin](https://app.validin.com/) - Massive collection of DNS records with free DNS history search
- [dnslookup.pro](https://dnslookup.pro/) - Advanced DNS Record Analysis & Troubleshooting

### Certificates

- [Crt.sh](https://crt.sh/) - Certificate Search
- [CTSearch](https://ui.ctsearch.entrust.com/ui/ctsearchui) - Certificate Transparency Search Tool
- [tls.bufferover.run](https://tls.bufferover.run/) - Quickly find certificates in IPv4 space
- [CertSpotter](https://sslmate.com/certspotter/) - Monitors your domains for expiring, unauthorized, and invalid SSL certificates
- [SynapsInt](https://synapsint.com/) - The unified OSINT research tool
- [Censys Search - Certificates](https://search.censys.io/#) - Certificates Search
- [ciphersuite.info](https://ciphersuite.info/) - TLS Ciphersuite Search. Search for a particular cipher suite by using IANA, OpenSSL or GnuTLS name format
- [certificatedetails](https://certificatedetails.com/) - Online certificate viewer. Inspect and download certificates from your browser
- [FacebookCT](https://developers.facebook.com/tools/ct/search/) - Search for certificates issued for a given domain and subscribe to notifications from Facebook regarding new certificates
- [certs.io](https://certs.io/) - Search TLS certificates across the internet.
- [ODIN Certificates Search](https://getodin.com/search/certificates) - ODIN Certificates Search

### WiFi Networks

- [Wigle.net](https://wigle.net/) - Maps and database of 802.11 wireless networks with statistics
- [wifimap.io](https://www.wifimap.io/) - Connect to all Free WiFi Hotspots using WiFi Map App all over the World!
- [wificafespots.com](http://www.wificafespots.com/) - Free WiFi Cafe Spots
- [wifispc.com](https://wifispc.com/) - Free map of Wi-Fi passwords anywhere you go!
- [openwifimap.net](https://openwifimap.net/) - HTML5 map with OpenWiFiMap data
- [mylnikov.org](https://www.mylnikov.org/) - Public API implementation of Wi-Fi Geo-Location database

### Device Information

- [MACVendorLookup.com](https://www.macvendorlookup.com/) - Look up the vendor for a specific MAC Address
- [macvendors.com](https://macvendors.com/) - Find MAC Address Vendors. Now
- [macaddress.io](https://macaddress.io/) - MAC address vendor lookup
- [maclookup.app](https://maclookup.app/) - Find the vendor name of a device by entering an OUI or a MAC address
- [macvendors.co](https://macvendors.co/) - Get vendor name of your network device using its mac address

### Credentials

- [Have I Been Pwned](https://haveibeenpwned.com/) - Check if your email or phone is in a data breach
- [Dehashed](https://www.dehashed.com/) - Free deep-web scans and protection against credential leaks
- [LeakCheck.io](https://leakcheck.io/) - Make sure your credentials haven't been compromised
- [crackstation.net](https://crackstation.net/) -Massive pre-computed lookup tables to crack password hashes
- [HashKiller](https://hashkiller.io/listmanager) - Pre-cracked Hashes, easily searchable
- [LeakedPassword](https://leakedpassword.com/) - Search across multiple data breaches to see if your pass has been compromised
- [BugMeNot](https://bugmenot.com/) - Find and share logins
- [Hashes.com](https://hashes.com/en/decrypt/hash) - Decrypt and crack your MD5, SHA1, SHA256, MySQL, MD5 Email, SHA256 Email, and NTLM hashes for free online
- [Hashmob](https://hashmob.net/search) - The Largest Password Recovery Community
- [WhiteIntel](https://whiteintel.io/) - Check if a company or its customers was victim of an information stealer malware
- [ntlm.pw](https://ntlm.pw/) - Instantly look up NTLM hashes and resolve them to plaintext passwords using our database with 8B+ entries
- [Hudson Rock](https://www.hudsonrock.com/threat-intelligence-cybercrime-tools) - Use Hudson Rock’s free cybercrime intelligence tools to learn how compromised credentials are impacting your business
- [hackedlist.io](https://hackedlist.io/) - Enter your domain to find credentials compromised by info-stealer malware
- [HaveIBeenSold](https://haveibeensold.app/) - Lets you find out whether or not your email has been sold to third parties
- [Leak.sx](https://leak.sx/) - The best leaked accounts website you always wanted
- [ScatteredSecrets](https://scatteredsecrets.com/) - Search data breaches to see if your password has been compromised

### Leaks

- [WikiLeaks](https://wikileaks.org/) - News leaks and classified media provided by anonymous sources
- [Leak-Lookup](https://leak-lookup.com/) - Search across thousands of data breaches
- [Snusbase](https://snusbase.com/) - Stay on top of the latest database breaches
- [breachdirectory.org](https://breachdirectory.org/) - Check if your information was exposed in a data breach
- [BreachForums](https://breachforums.st/) - Breaches, Data leaks, databases and more
- [Siph0n Breach DB (onionsite)](siphondkh34l5vki.onion/) - Breaches, Data leaks, Exploits
- [Exposed Forum](https://exposed.vc/) - The premier Databreach discussion & leaks forum
- [Distributed Denial of Secrets](https://ddosecrets.com/) - Journalist 501(c)(3) non-profit devoted to publishing and archiving leaks
- [Have I Been Zuckered](https://haveibeenzuckered.com/) - Facebook Data Breach Checker
- [Cryptome](https://cryptome.org/) - Documents for publication that are prohibited by governments worldwide
- [LeakPeek](https://leakpeek.com/) - Search for your publicly leaked passwords using an email or username, secure your personal data
- [BreachCheck.io](https://breachcheck.io/) - Free service for consumers that allows you to check and download a list of your personal data exposed in various databreaches
- [OCCRP Aleph](https://data.occrp.org/) - The global archive of research material for investigative reporting

### Hidden Services

- [AHMIA](https://ahmia.fi/) - Search hidden services on the Tor network
- [thehiddenwiki.org](https://thehiddenwiki.org/) - The darknet guide
- [tor.link](https://tor.link/) - Free anonymous deepweb / Darknet search engine
- [deepweblinks.net](https://deepweblinks.net/) - Onion Links
- [onionengine.com](https://onionengine.com/) - A search engine for services accessible on the Tor network
- [OnionLand](https://onionlandsearchengine.net/) - Discover Hidden Services and access to Tor's onion sites

### Social Networks

These can be useful for osint and social engineering.

- [Facebook](https://www.facebook.com/)
- [Instagram](https://www.instagram.com/)
- [YouTube](https://www.youtube.com/)
- [Twitter/X](https://twitter.com/)
- [LinkedIn](https://www.linkedin.com/)
- [Reddit](https://new.reddit.com/)
- [Pinterest](https://www.pinterest.com/)
- [Tumblr](https://www.tumblr.com/)
- [Flickr](https://www.flickr.com/)
- [SnapChat](https://www.snapchat.com/)
- [Whatsapp](https://www.whatsapp.com/)
- [Quora](https://www.quora.com/)
- [TikTok](https://www.tiktok.com/)
- [Vimeo](https://vimeo.com/)
- [Medium](https://medium.com/)
- [WeChat](https://www.wechat.com/)
- [VK](https://vk.com/)
- [Weibo](https://weibo.com/)
- [Tinder](https://tinder.com/)
- [Threads](https://www.threads.net/)

### Phone Numbers

- [NumLookup](https://www.numlookup.com/) - Free reverse phone lookup
- [SpyDialer](https://spydialer.com/) - Free Reverse Lookup Search
- [WhitePages](https://www.whitepages.com/) - Find people, contact info & background checks
- [National Cellular Directory](https://www.nationalcellulardirectory.com/) - Begin your comprehensive people search now
- [Phone Validator](https://www.phonevalidator.com/) - Is it a cell phone or is it a landline or is it a fake?
- [Free Carrier Lookup](https://freecarrierlookup.com/) - Enter a phone number and we'll return the carrier name
- [RocketReach](https://rocketreach.co/) - Your first-degree connection to any professional
- [sync.me](https://sync.me/) - Find out who called
- [EmobileTracker](https://www.emobiletracker.com/) - Track Mobile Owner Name, Location and Mobile Service Provider
- [Reverse Phone Lookup](https://www.reversephonelookup.com/) - Find Out The Owner Of A Phone Number
- [ThatsThem](https://thatsthem.com/reverse-phone-lookup) - Reverse phone lookup
- [thisnumber.com](https://www.thisnumber.com/) - International Phone Directories
- [usphonebook.com](https://www.usphonebook.com/) - Free Reverse Phone Number Lookup
- [truepeoplesearch.com](https://www.truepeoplesearch.com/#) - Get current address, cell phone number, email address, relatives, friends and a lot more
- [Tellows](https://www.tellows.com/) - Who is calling? The phone number reverse search
- [SynapsInt](https://synapsint.com/) - The unified OSINT research tool
- [C99.nl](https://api.c99.nl/) - Over 57 quality API's and growing
- [ValidNumber.com](https://validnumber.com/) - Free reverse phone lookup service to let you identify a caller associated with any 10-digit phone number from the US and Canada
- [CellIdFinder](https://cellidfinder.com/) - Nonprofit project which helps you to find GSM BTS by MCC, MNC, LAC and CellID
- [OldPhoneBook](http://www.oldphonebook.com/) - Instantly search a large selection from the past 20 years of USA phone listings
- [Spokeo](https://www.spokeo.com/) - Search by name, phone, address, or email to confidentially lookup information about people you know
- [Intelius Phone Lookup](https://www.intelius.com/reverse-phone-lookup/) - Look up a phone number to find owner information, carrier details, and more
- [ZabaSearch Phone Lookup](https://www.zabasearch.com/reverse-phone-lookup/) - Reverse Phone Lookup Tool Can Uncover Personal Information, Social Media Data, Online Activity, Photos, and More
- [AnyWho Phone Lookup](https://www.anywho.com/reverse-phone-lookup/) - Find out information associated with a phone number
- [Radaris Phone Lookup](https://radaris.com/#findPhoneH) - Look up any phone number to see its owner and identify who's calling or texting you
- [Reverse Phone Lookup](https://www.reversephonecheck.com/) - Reverse phone number lookup with millions of listings including name or address

### Images

- [Google Image Search](https://images.google.com/) - The most comprehensive image search on the web
- [Baidu Image](https://image.baidu.com/) - Baidu Image Search
- [Yahoo Image](https://images.search.yahoo.com/) - Yahoo Image Search
- [Yandex Image](https://www.yandex.com/images/) - Yandex Image Search
- [Facecheck.id](https://facecheck.id/) - Search for people by photo and verify you are talking to the person they claim to be
- [Bing Visual Search](https://www.bing.com/visualsearch) - See it, search it
- [Reverse Image Search](https://www.reverseimagesearch.org/) - Super-fast image finder that helps you find similar images online
- [Reverse Image](https://reverseimage.net/) - Find Where Images Appear Online
- [Pixsy](https://www.pixsy.com) - Find and fight image theft
- [Pimeyes](https://pimeyes.com/) - Face Search Engine, Reverse Image Search
- [Pictriev](http://www.pictriev.com/) - Find look-alike celebrities on the web using the face recognition
- [Karmadecay](http://karmadecay.com/) - Reverse image search of Reddit.com
- [Infringement Report](https://infringement.report/) - The web's best image copyright infringement search tool
- [Tineye](https://tineye.com/) - Image search and recognition company
- [Flickr](https://flickr.com/search/) - Home to tens of billions of photos and 2 million groups
- [Sogou](https://pic.sogou.com/) - Chinese technology company that offers a search engine
- [Jimpl](https://jimpl.com/) - Online photo metadata and EXIF data viewer
- [Same Energy](https://same.energy/) - Find beautiful images
- [Pixabay](https://pixabay.com/) - Stunning royalty-free images & royalty-free stock
- [FotoForensics](https://fotoforensics.com/) - Tools and training for digital picture analysis, including error level analysis, metadata, and tutorials
- [Exif data](http://exifdata.com/) - Online application that lets you take a deeper look at your favorite images
- [Image Identify](https://www.imageidentify.com/) - Image recognition site, just drag your image & identify
- [ScamDigger](https://www.scamdigger.com/picsearch.php) - You will see if that picture belongs to somebody else, was used by somebody else, already scamlisted, etc

### Threat Intelligence

- [MITRE ATT&CK](https://attack.mitre.org/) - Globally-accessible knowledge base of adversary tactics and techniques
- [PulseDive](https://pulsedive.com/) - Threat intelligence made easy
- [ThreatCrowd](https://threatcrowd.org/) - A Search Engine for Threats
- [ThreatMiner](https://www.threatminer.org/) - Data Mining for Threat Intelligence
- [VirusTotal](https://www.virustotal.com/) - Analyze suspicious files, domains, IPs and URLs to detect malware and other breaches
- [vx-underground.org](https://vx-underground.org/) - The largest collection of malware source code, samples, and papers on the internet
- [bazaar.abuse.ch](https://bazaar.abuse.ch/browse/) - Malware sample database
- [feodotracker.abuse.ch](https://feodotracker.abuse.ch/browse/) - List of botnet Command&Control servers
- [sslbl.abuse.ch](https://sslbl.abuse.ch/ssl-certificates/) - All malicious SSL certificates
- [urlhaus.abuse.ch](https://urlhaus.abuse.ch/browse/) - Propose new malware urls
- [threatfox.abuse.ch](https://threatfox.abuse.ch/browse/) - Indicator Of Compromise (IOC) database
- [yaraify.abuse.ch](https://yaraify.abuse.ch/) - Scan suspicious files such as malware samples or process dumps against a large repository of YARA rules
- [Rescure](https://rescure.me/) - Curated cyber threat intelligence for everyone
- [otx.alienvault](https://otx.alienvault.com/) - The World's First Truly Open Threat Intelligence Community
- [urlquery.net](https://urlquery.net/) - Service for detecting and analyzing web-based malware
- [socradar.io](https://socradar.io/) - Extension to your SOC team
- [VirusShare](https://virusshare.com/) - System currently contains 48 million malware samples
- [PassiveTotal](https://www.riskiq.com/products/passivetotal/) - Security intelligence that scales security operations and response
- [malapi.io](https://malapi.io/) - Windows APIs used for malicious purposes
- [filesec.io](https://filesec.io/) - Latest file extensions being used by attackers
- [leakix.net](https://leakix.net/) - Search engine indexing public information and an open reporting platform linked to the results
- [tria.ge](https://tria.ge/s) - Fully automated solution for high-volume malware analysis using advanced sandboxing technology
- [Polyswarm](https://polyswarm.network/) - Launchpad for new technologies and innovative threat detection methods
- [Cisco Talos](https://talosintelligence.com/) - The threat intelligence organization at the center of the Cisco Security portfolio
- [scamsearch.io](https://scamsearch.io/#anchorCeckNow) - Find your scammer online & report them
- [CyberCampaigns](http://www.cybercampaigns.net/) - Threat Actor information and Write-Ups
- [ORKL](https://orkl.eu/) - The Community Driven Cyber Threat Intelligence Library
- [Maltiverse](https://maltiverse.com/search) - Data from more than 100 different Threat Intelligence sources
- [Inquest Labs](https://labs.inquest.net/) - Threat intelligence from hundreds of public, private, and internal sources to develop new FDR signatures and rules
- [PhishTank](https://phishtank.org/) - Collaborative clearing house for data and information about phishing on the Internet
- [IntelOwl](https://github.com/intelowlproject/IntelOwl) - Open Source Intelligence, or OSINT solution to get threat intelligence data about a specific file, an IP or a domain from a single API at scale
- [Lupovis](https://prowl.lupovis.io/) - Analyze and collect data on Internet-wide scans and attacks in real-time. We use this data to identify and classify malicious actors
- [AbuseIPDB](https://www.abuseipdb.com/) - Check the report history of any IP address to see if anyone else has reported malicious activities
- [Sucuri SiteCheck](https://sitecheck.sucuri.net/) - Check websites for known malware, viruses, blacklisting status, website errors, out-of-date software, and malicious code
- [Spamhaus](https://spamhaus.com) - Protect and investigate using IP and domain reputation data
- [ThreatBook](https://threatbook.io/) - One step ahead of your adversary with high-fidelity, efficient and actionable cyber threat intelligence
- [ShadowServer](https://www.shadowserver.org/) - Nonprofit security organization working altruistically behind the scenes to make the Internet more secure for everyone
- [Team Cymru](https://www.team-cymru.com/) - Global leader in cyber threat intelligence and attack surface management
- [BeVigil](https://bevigil.com/) - Search engine for mobile application security testing
- [CIRCL](https://www.circl.lu/) - The Computer Incident Response Center Luxembourg is a government-driven initiative designed to gather, review, report and respond to computer security threats and incidents
- [MetaDefender Cloud](https://metadefender.opswat.com/) - Advanced threat detection and prevention platform
- [Cybersixgill](https://cybersixgill.com/) - Threat intelligence platform that provides access to a wide range of cybersecurity information, including dark web monitoring and threat actor analysis
- [Hybrid Analysis](https://www.hybrid-analysis.com/) - Free malware analysis service for the community that detects and analyzes unknown threats using a unique Hybrid Analysis technology
- [IBM X-Force Exchange](https://exchange.xforce.ibmcloud.com/) - Threat intelligence sharing platform enabling research on security threats, aggregation of intelligence, and collaboration with peers
- [The DFIR Report](https://thedfirreport.com/) - Real Intrusions by Real Attackers, The Truth Behind the Intrusion
- [Detection.FYI](https://detection.fyi/) - Search Sigma rules
- [WhoisXMLAPI](https://www.whoisxmlapi.com/) - Domain & IP Data Intelligence for Greater Enterprise Security
- [APIVoid](https://www.apivoid.com/) - Threat analysis centered on IP and Domain reputation, along with additional services
- [AnyRun](https://app.any.run/submissions) - Browse thousands of malware samples in our database
- [Filescan.io](https://www.filescan.io/reports) - Search reports for file name, URL, IP, Domain or Hash
- [MalShare](https://malshare.com/) - Community driven public malware repository that works to provide free access to malware samples
- [Kaspersky TIP](https://opentip.kaspersky.com/requests) - Scan files, domains, IP addresses, and URLs for threats, malware, viruses
- [Malwares.com](https://malwares.com/) - Search malwares online
- [ApkLab](https://www.apklab.io/) - Mobile threat intelligence platform designed to provide the most relevant information for Android security researchers
- [Scumware](https://www.scumware.org/search.php) - Find latest reports about malware and other threats
- [Living off the False Positive](https://br0k3nlab.com/LoFP/) - Autogenerated collection of false positives sourced from some of the most popular rule sets
- [HijackLibs](https://hijacklibs.net/) - Project for tracking publicly disclosed DLL Hijacking opportunities
- [bootloaders.io](https://www.bootloaders.io/) - Curated list of known malicious bootloaders for various operating systems
- [WTFBins](https://wtfbins.wtf/) - Catalogue benign applications that exhibit suspicious behavior. These binaries can emit noise and false positives in threat hunting and automated detections
- [LOFLCAB](https://lofl-project.github.io/) - Document every cmdlet, binary, script, and WMI class that can be used for Living Off the Foreign Land techniques
- [OpSecFailure](https://opsecfail.github.io/) - Site that lists how individuals messed up their opsec, no personal info is shared on this site
- [TrailDiscover](https://traildiscover.cloud/) - An evolving repository of CloudTrail events with detailed descriptions, MITRE ATT&CK insights, real-world incidents, references and security implications
- [scamdb.net](https://www.scamdb.net/) - Report and Search Online Scams
- [OpenPhish](https://openphish.com/) - Actionable intelligence data on active phishing threats
- [ThreatIntelligencePlatform.com](https://threatintelligenceplatform.com/) - Data, tool, and API provider that specializes in automated threat detection, security analysis and threat intelligence solutions

### Web History

- [Web Archive](https://web.archive.org/) - Explore more than 702 billion web pages saved over time
- [Archive.ph](https://archive.ph/) - Create a copy of a webpage that will always be up even if the original link is down
- [CachedPages](http://www.cachedpages.com/) - Get the cached page of any URL
- [stored.website](https://stored.website/) - View cached web pages/website
- [CommonCrawl](https://commoncrawl.org/) - Open repository of web crawl data
- [UK Web Archive](https://www.webarchive.org.uk/ukwa/) - Collects millions of websites each year, preserving them for future generations
- [Arquivo](https://arquivo.pt/) - Non-profit service that maintains information published on the web of interest to the Portuguese community
- [Archive-It](https://archive-it.org/) - An archive of digital government and non-government organization (NGO) documents and reports
- [HAW](https://haw.nsk.hr/en/) - Croatian Web Archive

### Surveillance cameras

- [Insecam.org](http://www.insecam.org/en/) - The world biggest directory of online surveillance security cameras
- [Surveillance under Surveillance](https://sunders.uber.space/) - Cameras and guards watching you almost everywhere
- [World Cams](https://worldcams.tv/) - Live Streaming Webcams Like Never Seen Before
- [Skylinewebcams](https://www.skylinewebcams.com/) - Live HD webcams broadcasting from the world's best attractions and destinations
- [WebKams](https://www.webkams.com/) - Live Web Cameras Everywhere
- [WorldCam](https://worldcam.eu/) - Webcams from around the world
- [Webcam Hopper](https://www.webcamhopper.com/) - Live Webcams from around the world
- [Live Traffic](https://livetraffic.eu/) - Real-time monitoring of Europe’s live traffic cameras
- [Geocam.ru](https://www.geocam.ru/en/) - Webcams of the world
- [Moldova's borders webcams](https://www.border.gov.md/camere-web) - Official list of webcams at various border crossings around Moldova
- [Earth Cam](https://www.earthcam.com/) - Leading network of live streaming webcams for tourism and entertainment
- [Webcam Taxi](https://www.webcamtaxi.com/en/) - Live Virtual Travel
- [LiveWorldWebcams](https://liveworldwebcams.com/) - Live streaming webcams from around the world
- [AlleCam](https://www.allecam.com/) - Webcam live from Europe and the whole world
- [WXYZ Webcams](https://wxyzwebcams.com/) - Real-time webcams

### Crypto

- [ChainAbuse](https://www.chainabuse.com/) - Report malicious crypto activity
- [BlockChair](https://blockchair.com/) - Blockchain explorer, analytics and web services
- [BlockCypher](https://live.blockcypher.com/) - Search the block chain

### People

- [TruePeopleSearch](https://www.truepeoplesearch.com/) - Free people search tool. Search billions of public records
- [TruthFinder](https://www.truthfinder.com/people-search/) - A people search is a quick and simple way to find information on someone by name
- [BeenVerified](https://www.beenverified.com/) - BeenVerified's mission is to give people easy and affordable access to public record information
- [ZabaSearch](https://www.zabasearch.com/) - Free* People Search and Public Information Search Engine
- [PeekYou](https://www.peekyou.com/) - Fast People Search Made Easy
- [PeopleFinders](https://www.peoplefinders.com/people-search) - People Search
- [Pipl](https://pipl.com/) - The #1 source for identity & trust
- [That's Them](https://thatsthem.com/people-search) - Find Someone's Contact Details By Name
- [snitch.name](http://snitch.name/) - Social White Pages application with helps you Search for People's Profiles on Social Sites
- [Webmii](https://webmii.com/) - People search engine
- [FastPeopleSearch](https://www.fastpeoplesearch.com/) - Find a person by name, phone number, or street address
- [Sorted By Name](https://sortedbyname.com/) - A curated collection of links to genealogy details mentioned on other websites, or acquired by the webmaster
- [Radaris](https://radaris.com/) - Find People Fast and Free
- [Addresses.com](https://www.addresses.com/) - Free People Search and Public Information Search Engine
- [Advanced Background Checks](https://www.advancedbackgroundchecks.com/) - Free People Search
- [Yasni](http://www.yasni.com/) - Search phone, email, address for any name. News, pictures & links for any person. Find anyone on the internet with the world's largest free people search
- [USA Data Search](https://usa-official.com/) - The USA official website provides access to public data that can be searched and viewed by anyone
- [AnyWho](https://www.anywho.com/) - Finding People, Places, and Businesses
- [Lullar](https://com.lullar.com/) - Profile Search by Email, First Last Name or Username
- [Ancestry](https://www.ancestry.com/search/) - The largest for-profit genealogy company in the world, it operates a network of genealogical, historical records, and related genetic genealogy websites
- [genealogy.com](https://www.genealogy.com/) - Source for family history buffs to find genealogical research originally posted in GenForum and our most popular genealogy articles
- [US Search](https://www.ussearch.com/) - Access to details about the people in your life. Access public records, contact information, background checks & more
- [Find My Past](https://search.findmypast.com/search-world-records) - Discover your global ancestors by searching millions of records across the world
- [FamilySearch](https://www.familysearch.org/search/) - Search for your ancestors in birth certificates, marriage registrations, census records, and other documents
- [iTools - Wink People Search](http://itools.com/tool/wink-people-search) - Free people search. Find people on social networks and across the Web
- [Intelius](https://www.intelius.com/) - Leading provider of public data about people and their connections to others

### Unclassified

- [DorkSearch](https://dorksearch.com/) - Speed up your Dorking
- [usersearch.org](https://usersearch.org/) - Find someone by username or email on Social Networks, Dating Sites, Forums, Crypto Forums, Chat Sites and Blogs
- [Pastebin](https://pastebin.com/) - Website where you can store text online for a set period of time
- [Wappalyzer](https://www.wappalyzer.com/) - Instant access to website technology stacks, company and contact details, social media profiles, email verification and more
- [Awakari](https://awakari.com) - Real-Time Search from unlimited sources like RSS, Fediverse, Telegram, etc. Filter events by keywords, numeric conditions, condition groups
- [cspbypass.com](https://cspbypass.com/) - Search for CSP Bypasses
- [CanIUse.com](https://caniuse.com/) - Browser support tables for modern web technologies
- [Dark Visitors](https://darkvisitors.com/) - Track and Control Artificial Agents Crawling Your Website

### Not working / Paused

<!-- markdown-link-check-disable -->

- [DNS.BufferOver.run](https://dns.bufferover.run/)
- [NetoGraph](https://netograph.io/) - Captures and indexes detailed, low-level snapshots of website behaviour
- [Hashdd](https://hashdd.com/) - Known Good Cryptographic Hashes

<!-- markdown-link-check-enable -->

---

If you want to propose changes, just open an [issue](https://github.com/edoardottt/awesome-hacker-search-engines/issues) or a [pull request](https://github.com/edoardottt/awesome-hacker-search-engines/pulls).

[edoardottt.com](https://edoardottt.com/) to contact me.
