"""added shoes dec 2019

Revision ID: db74a5d334d
Revises: efb8320781d
Create Date: 2019-12-11 20:13:41.123714

"""

# revision identifiers, used by Alembic.
revision = 'db74a5d334d'
down_revision = 'efb8320781d'

from alembic import op
import sqlalchemy as sa
from datetime import date
from sqlalchemy.sql import table, column
from sqlalchemy import String, Integer, Date, and_

def upgrade():
    # Create an ad-hoc table to use for the insert statement.
    item_table = table('item',
        column('model', String),
        column('brand_id', Integer),
        column('gender_id', Integer),
        column('small_image_url', String),
        column('medium_image_url', String),
        column('type', String)
    )

    user_item_table = table('user_item',
        column('item_id', Integer)
    )

    # Mad Rock List
    op.bulk_insert(item_table,
        [
            {'model':'topo 2.0', 'brand_id':'4', 'gender_id':'3', 'type':'approach'}
        ]
    )

    # 28|unparallel|US
    op.bulk_insert(
        item_table, [
            {'model': 'up grade mocc', 'brand_id': '28',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'up grade engage', 'brand_id': '28',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'hold up slipper', 'brand_id': '28',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'hold up vcs', 'brand_id': '28',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'vim', 'brand_id': '28',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'newtro lace up', 'brand_id': '28',
                'gender_id': '3', 'type': 'rock'},  
            {'model': 'newtro vcs', 'brand_id': '28',
                'gender_id': '3', 'type': 'rock'}
        ])                      

    # remove unparallel vega duplicate
    conn = op.get_bind()
    # delete this one
    res1 = conn.execute("select * from item where model = 'vega' and gender_id = 1")
    results1 = res1.first()
    # keep this one
    res2 = conn.execute("select * from item where model = 'vega' and gender_id = 3")
    results2 = res2.first()

    op.execute(
        user_item_table.update().\
            where(user_item_table.c.item_id==results1.id).\
            values({'item_id':results2.id})
            )

    op.execute(
        item_table.delete().\
            where(and_(item_table.c.model == 'vega', item_table.c.gender_id == '1'))
        )


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    pass
    ### end Alembic commands ###
