"""Added shoes Feb 2021

Revision ID: 53759f7c9f55
Revises: d8e25eebb627
Create Date: 2021-02-11 20:32:53.537992

"""

# revision identifiers, used by Alembic.
revision = '53759f7c9f55'
down_revision = 'd8e25eebb627'

from alembic import op
import sqlalchemy as sa
from datetime import date
from sqlalchemy.sql import table, column
from sqlalchemy import String, Integer, Date


def upgrade():
    # Create an ad-hoc table to use for the insert statement.
    item_table = table('item',
                       column('model', String),
                       column('brand_id', Integer),
                       column('gender_id', Integer),
                       column('small_image_url', String),
                       column('medium_image_url', String),
                       column('type', String)
                       )
    # 5|scarpa|EUR
    op.bulk_insert(
        item_table, [
            {'model': 'drago lv', 'brand_id': '5',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'instinct', 'brand_id': '5',
                'gender_id': '2', 'type': 'rock'},
        ])

    # 4|mad rock|US
    op.bulk_insert(
        item_table, [
            {'model': 'redline strap', 'brand_id': '4',
                'gender_id': '1', 'type': 'rock'},
            {'model': 'remora lv', 'brand_id': '4',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'remora hv', 'brand_id': '4',
                'gender_id': '3', 'type': 'rock'},
        ])
    
    # 1|evolv|US
    op.bulk_insert(
        item_table, [
            {'model': 'geshido lace', 'brand_id': '1',
                'gender_id': '1', 'type': 'rock'},
            {'model': 'geshido velcro', 'brand_id': '1',
                'gender_id': '1', 'type': 'rock'},
            {'model': 'geshido lace', 'brand_id': '1',
                'gender_id': '2', 'type': 'rock'},
            {'model': 'geshido velcro', 'brand_id': '1',
                'gender_id': '2', 'type': 'rock'},   
            {'model': 'zenist', 'brand_id': '1',
                'gender_id': '1', 'type': 'rock'},
            {'model': 'zenist', 'brand_id': '1',
                'gender_id': '2', 'type': 'rock'},                             
        ])

    # 3|la sportiva|EUR
    op.bulk_insert(
        item_table, [
            {'model': 'aragon', 'brand_id': '3',
                'gender_id': '1', 'type': 'rock'},
            {'model': 'aragon', 'brand_id': '3',
                'gender_id': '2', 'type': 'rock'},
            {'model': 'zenit', 'brand_id': '3',
                'gender_id': '1', 'type': 'rock'},
            {'model': 'zenit', 'brand_id': '3',
                'gender_id': '2', 'type': 'rock'}
        ])


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
