"""empty message

Revision ID: 528b2edccf31
Revises: 27e720adb232
Create Date: 2016-04-06 21:06:24.536850

"""

# revision identifiers, used by Alembic.
revision = '528b2edccf31'
down_revision = '27e720adb232'

from alembic import op
import sqlalchemy as sa
from datetime import date
from sqlalchemy.sql import table, column
from sqlalchemy import String, Integer, Date


def upgrade():
    # Create an ad-hoc table to use for the insert statement.
    item_table = table('item',
        column('model', String),
        column('brand_id', Integer),
        column('gender_id', Integer)
    )
    op.execute(
        item_table.update().\
            where(item_table.c.model=='booster').\
            values({'model':'booster s'})
            )
    # Evolv Geshido SC
    op.bulk_insert(item_table,
        [
            {'model':'geshido sc', 'brand_id':'1', 'gender_id':'1'},
        ]
    )
    # 5.10 Shoe List
    op.bulk_insert(item_table,
        [
            {'model':'anasazi lace pink', 'brand_id':'2', 'gender_id':'1'},
            {'model':'anasazi lace blanco', 'brand_id':'2', 'gender_id':'1'},
        ]
    )

def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    user_item_table = table('user_item',
        column('item_id', Integer)
    )

    item_table = table('item',
        column('model', String),
        column('brand_id', Integer),
        column('gender_id', Integer)
    )

    # get galileo id
    conn = op.get_bind()
    res = conn.execute("select * from item where model = 'geshido sc'")
    results = res.first()

    op.execute(
        item_table.delete().\
            where(item_table.c.model=='geshido sc')
        )

    if results is not None:
        op.execute(
            user_item_table.delete().\
                where(user_item_table.c.item_id==results.id)
            )

    conn = op.get_bind()
    res = conn.execute("select * from item where model = 'anasazi lace pink'")
    results = res.first()

    op.execute(
        item_table.delete().\
            where(item_table.c.model=='anasazi lace pink')
        )

    if results is not None:
        op.execute(
            user_item_table.delete().\
                where(user_item_table.c.item_id==results.id)
            )

    conn = op.get_bind()
    res = conn.execute("select * from item where model = 'anasazi lace blanco'")
    results = res.first()

    op.execute(
        item_table.delete().\
            where(item_table.c.model=='anasazi lace blanco')
        )

    if results is not None:
        op.execute(
            user_item_table.delete().\
                where(user_item_table.c.item_id==results.id)
            )
    ### end Alembic commands ###
