"""empty message

Revision ID: 27e720adb232
Revises: 115bd16c70d5
Create Date: 2016-04-05 15:13:06.007651

"""

# revision identifiers, used by Alembic.
revision = '27e720adb232'
down_revision = '115bd16c70d5'

from alembic import op
import sqlalchemy as sa
from datetime import date
from sqlalchemy.sql import table, column
from sqlalchemy import String, Integer, Date


def upgrade():
    # Create an ad-hoc table to use for the insert statement.
    item_table = table('item',
        column('model', String),
        column('brand_id', Integer),
        column('gender_id', Integer)
    )
    # 5.10 Shoe List
    op.bulk_insert(item_table,
        [
            {'model':'galileo', 'brand_id':'2', 'gender_id':'1'},
        ]
    )

def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    user_item_table = table('user_item',
        column('item_id', Integer)
    )

    item_table = table('item',
        column('model', String),
        column('brand_id', Integer),
        column('gender_id', Integer)
    )

    # get galileo id
    conn = op.get_bind()
    res = conn.execute("select * from item where model = 'galileo'")
    results = res.first()

    op.execute(
        item_table.delete().\
            where(item_table.c.model=='galileo')
        )
    if results is not None:
        op.execute(
            user_item_table.delete().\
                where(user_item_table.c.item_id==results.id)
            )
    ### end Alembic commands ###
