"""added rock on brand and shoes June 2019

Revision ID: 2763a5981eb8
Revises: 2c2645f86a6e
Create Date: 2019-06-06 17:28:35.346786

"""

# revision identifiers, used by Alembic.
revision = '2763a5981eb8'
down_revision = '2c2645f86a6e'

from alembic import op
import sqlalchemy as sa
from datetime import date
from sqlalchemy.sql import table, column
from sqlalchemy import String, Integer, Date


def upgrade():
    # brand 29 rock on
    brand_table = table('brand',
                        column('name', String)
                        )
    op.bulk_insert(brand_table,
                   [
                       {'name': 'rock on'},
                   ]
                   )

    # Create an ad-hoc table to use for the insert statement.
    item_table = table('item',
                       column('model', String),
                       column('brand_id', Integer),
                       column('gender_id', Integer),
                       column('small_image_url', String),
                       column('medium_image_url', String),
                       column('type', String)
                       )

    # 29|rock on|US
    op.bulk_insert(
        item_table, [
            {'model': 'shot', 'brand_id': '29',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'fly', 'brand_id': '29',
                'gender_id': '3', 'type': 'rock'},
            {'model': 'gama', 'brand_id': '29',
                'gender_id': '3', 'type': 'rock'}
        ])

    # Red Chili Shoe List
    op.bulk_insert(item_table,
                   [
                       {'model': 'charger', 'brand_id': '9',
                           'gender_id': '1', 'type': 'rock'},
                       {'model': 'charger lv', 'brand_id': '9',
                           'gender_id': '2', 'type': 'rock'}
                   ]
                   )

    # black diamond Shoe List
    op.bulk_insert(item_table,
                   [
                       {'model': 'zone', 'brand_id': '27',
                           'gender_id': '1', 'type': 'rock'},
                       {'model': 'zone lv', 'brand_id': '27',
                           'gender_id': '2', 'type': 'rock'}
                   ]
                   )

    # 3|la sportiva|EUR
    op.bulk_insert(item_table,
                   [
                       {'model': 'trango tech GTX', 'brand_id': '3',
                           'gender_id': '1', 'type': 'mountain'},
                       {'model': 'trango tech GTX', 'brand_id': '3',
                           'gender_id': '2', 'type': 'mountain'}
                   ]
                   )

    # Scarpa Rock Shoe List
    op.bulk_insert(item_table,
                   [
                       {'model': 'instinct vs', 'brand_id': '5', 'gender_id': '2'}
                   ])


def downgrade():
    ### commands auto generated by Alembic - please adjust! ###
    pass
    ### end Alembic commands ###
