"""new shoes oct-22-2023

Revision ID: 209f4d78ef0b
Revises: 766763c8769b
Create Date: 2023-10-22 16:03:38.018146

"""

# revision identifiers, used by Alembic.
revision = '209f4d78ef0b'
down_revision = '766763c8769b'

from alembic import op
import sqlalchemy as sa
from datetime import date
from sqlalchemy.sql import table, column
from sqlalchemy import String, Integer, Date


def upgrade():
    # Create an ad-hoc table to use for the insert statement.
    item_table = table('item',
        column('model', String),
        column('brand_id', Integer),
        column('gender_id', Integer),
        column('type', String)
    )


    # 3|la sportiva|EUR
    op.bulk_insert(
        item_table, [
            {'model': 'tx guide', 'brand_id': '3',
                'gender_id': '1', 'type': 'approach'},
            {'model': 'tx guide leather', 'brand_id': '3',
                'gender_id': '1', 'type': 'approach'},
            {'model': 'tx5 low gtx', 'brand_id': '3',
                'gender_id': '1', 'type': 'approach'},
            {'model': 'tx guide', 'brand_id': '3',
                'gender_id': '2', 'type': 'approach'},
            {'model': 'tx guide leather', 'brand_id': '3',
                'gender_id': '2', 'type': 'approach'},
            {'model': 'tx5 low gtx', 'brand_id': '3',
                'gender_id': '2', 'type': 'approach'},                
        ])
    
    # mad rock drones and others
    op.bulk_insert(item_table,
        [
            {'model':'drone 2.0 HV', 'brand_id':'4', 'gender_id':'3', 'type':'rock'},
            {'model':'drone 2.0 LV', 'brand_id':'4', 'gender_id':'3', 'type':'rock'},
        ]
    )

    # change current method show to mens/womens
    op.execute(
        item_table.update().\
            where(item_table.c.model=='method').\
            values({'gender_id':'1'})
            )
    
    # 27|black diamond|US
    op.bulk_insert(
        item_table, [
            {'model': 'method s', 'brand_id': '27',
                'gender_id': '1', 'type': 'rock'}, 
            {'model': 'method s', 'brand_id': '27',
                'gender_id': '2', 'type': 'rock'},  
            {'model': 'method', 'brand_id': '27',
                'gender_id': '2', 'type': 'rock'},                      
        ])


def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
