"""new shoes may-2024

Revision ID: 1047db5fdc34
Revises: 44dd67063089
Create Date: 2024-05-09 19:52:16.913304

"""

# revision identifiers, used by Alembic.
revision = '1047db5fdc34'
down_revision = '44dd67063089'

from alembic import op
from sqlalchemy.sql import table, column
from sqlalchemy import String, Integer

def upgrade():
    # brand 31 wildclimb
    brand_table = table('brand',
                        column('name', String)
                        )
    op.bulk_insert(brand_table,
                   [
                       {'name': 'wildclimb'},
                   ]
                   )
    
    # Create an ad-hoc table to use for the insert statement.
    item_table = table('item',
                        column('model', String),
                        column('brand_id', Integer),
                        column('gender_id', Integer),
                        column('small_image_url', String),
                        column('medium_image_url', String),
                        column('type', String)
                        )  

    # 5|Scarpa|EUR
    op.bulk_insert(item_table,
        [
            {'model':'generator v', 'brand_id':'5', 'gender_id':'1'},
            {'model':'generator v', 'brand_id':'5', 'gender_id':'2'},
        ]
    )     
    
    # 3|LaSportiva|EUR
    op.bulk_insert(item_table,
        [
            {'model':'mythos eco', 'brand_id':'3', 'gender_id':'1'},
            {'model':'mythos eco', 'brand_id':'3', 'gender_id':'2'},
        ]
    )

    # 10|eb|EUR        
    op.bulk_insert(item_table,
        [
            {'model':'nebula', 'brand_id':'10', 'gender_id':'3'},
            {'model':'balboa', 'brand_id':'10', 'gender_id':'3'},
            {'model':'strange', 'brand_id':'10', 'gender_id':'3'},
            {'model':'black opium', 'brand_id':'10', 'gender_id':'3'},
            {'model':'strange', 'brand_id':'10', 'gender_id':'3'},
            {'model':'red', 'brand_id':'10', 'gender_id':'3'},
            {'model':'split', 'brand_id':'10', 'gender_id':'3'},
            {'model':'electron', 'brand_id':'10', 'gender_id':'3'},
            {'model':'mojo', 'brand_id':'10', 'gender_id':'3'},
            {'model':'torch lace', 'brand_id':'10', 'gender_id':'3'},
            {'model':'torch', 'brand_id':'10', 'gender_id':'3'},
        ]
    )
    # 31|wildclimb|EUR  
    op.bulk_insert(item_table,
        [
            {'model':'mangusta', 'brand_id':'31', 'gender_id':'3'},
            {'model':'pantera laser', 'brand_id':'31', 'gender_id':'3'},
            {'model':'pantera v', 'brand_id':'31', 'gender_id':'3'},
            {'model':'dagara', 'brand_id':'31', 'gender_id':'3'},
            {'model':'bat', 'brand_id':'31', 'gender_id':'3'},
            {'model':'sky laces', 'brand_id':'31', 'gender_id':'3'},
            {'model':'sky v', 'brand_id':'31', 'gender_id':'3'},
            {'model':'gladiator', 'brand_id':'31', 'gender_id':'3'},
            {'model':'pantera soft', 'brand_id':'31', 'gender_id':'3'},
            {'model':'pantera', 'brand_id':'31', 'gender_id':'3'},
            {'model':'pantera 2.0', 'brand_id':'31', 'gender_id':'3'},
            {'model':'pegaso', 'brand_id':'31', 'gender_id':'3'},
        ]    
    )
def downgrade():
    # ### commands auto generated by Alembic - please adjust! ###
    pass
    # ### end Alembic commands ###
