/*******************************************************************************
 * Copyright (C) 2015, Max Hohenegger <eclipse@hohenegger.eu>
 *
 * All rights reserved. This program and the accompanying materials
 * are made available under the terms of the Eclipse Public License 2.0
 * which accompanies this distribution, and is available at
 * https://www.eclipse.org/legal/epl-2.0/
 *
 * SPDX-License-Identifier: EPL-2.0
 *******************************************************************************/
package org.eclipse.egit.ui.gitflow;

import static org.eclipse.swtbot.swt.finder.waits.Conditions.shellCloses;
import static org.eclipse.swtbot.swt.finder.waits.Conditions.shellIsActive;
import static org.junit.Assert.assertFalse;

import org.eclipse.egit.gitflow.ui.Activator;
import org.eclipse.egit.gitflow.ui.internal.JobFamilies;
import org.eclipse.egit.gitflow.ui.internal.UIText;
import org.eclipse.egit.ui.test.ContextMenuHelper;
import org.eclipse.egit.ui.test.TestUtil;
import org.eclipse.swtbot.eclipse.finder.waits.Conditions;
import org.eclipse.swtbot.swt.finder.junit.SWTBotJunit4ClassRunner;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotShell;
import org.eclipse.swtbot.swt.finder.widgets.SWTBotTree;
import org.junit.runner.RunWith;

/**
 * Tests for the Team->Gitflow->Feature Start/Finish actions
 */
@RunWith(SWTBotJunit4ClassRunner.class)
public abstract class AbstractFeatureFinishHandlerTest extends AbstractGitflowHandlerTest {

	protected void finishFeature() {
		final SWTBotTree projectExplorerTree = TestUtil.getExplorerTree();
		getProjectItem(projectExplorerTree, PROJ1).select();
		final String[] menuPath = new String[] {
				util.getPluginLocalizedValue("TeamMenu.label"),
				util.getPluginLocalizedValue("TeamGitFlowMenu.name", false, Activator.getDefault().getBundle()),
				util.getPluginLocalizedValue("TeamGitFlowFeatureFinish.name", false, Activator.getDefault().getBundle()) };

		ContextMenuHelper.clickContextMenu(projectExplorerTree, menuPath);
		SWTBotShell dlg = bot.shell(UIText.FinishFeatureDialog_title);
		bot.waitUntil(shellIsActive(UIText.FinishFeatureDialog_title));
		selectOptions();
		bot.checkBox(UIText.FinishFeatureDialog_saveAsDefault).click();
		bot.button(UIText.FinishFeatureDialog_ButtonOK).click();
		bot.waitUntil(shellCloses(dlg));
		preFinish();
		bot.waitUntil(Conditions.waitForJobs(JobFamilies.GITFLOW_FAMILY, "Git flow jobs"));
	}

	protected void preFinish() {
		// do nothing by default
	}

	abstract protected void selectOptions();

	@Override
	public void checkoutFeature(String featureName) throws Exception {
		final SWTBotTree projectExplorerTree = TestUtil.getExplorerTree();
		getProjectItem(projectExplorerTree, PROJ1).select();
		final String[] menuPath = new String[] {
				util.getPluginLocalizedValue("TeamMenu.label"),
				util.getPluginLocalizedValue("TeamGitFlowMenu.name", false, Activator.getDefault().getBundle()),
				util.getPluginLocalizedValue("TeamGitFlowFeatureCheckout.name", false, Activator.getDefault().getBundle()) };

		ContextMenuHelper.clickContextMenu(projectExplorerTree, menuPath);

		SWTBotShell dlg = bot
				.shell(UIText.FeatureCheckoutHandler_selectFeature);
		bot.waitUntil(shellIsActive(UIText.FeatureCheckoutHandler_selectFeature));
		bot.text().setText("these are not the features you're looking for");
		// Wait for filter to hit. Minimum delay must be greater than
		// FilteredTree.getRefreshJobDelay().
		TestUtil.waitForJobs(500, 5000);
		assertFalse(bot.tree().hasItems());
		bot.text().setText(featureName);
		TestUtil.waitForJobs(500, 5000);
		bot.tree().select(featureName);
		bot.button(UIText.FeatureCheckoutHandler_ButtonOK).click();
		bot.waitUntil(shellCloses(dlg));
		bot.waitUntil(Conditions.waitForJobs(JobFamilies.GITFLOW_FAMILY, "Git flow jobs"));
	}
}
