// The Vue build version to load with the `import` command
// (runtime-only or standalone) has been set in webpack.base.conf with an alias.
import Vue from 'vue'
import App from './App'
import 'normalize.css/normalize.css'

import router from './router'
import store from './store/index'
import Axios from 'axios'
import ElementUI from 'element-ui'
import 'element-ui/lib/theme-chalk/index.css'
import './permission'
import VueClipboard from 'vue-clipboard2'


Vue.use(VueClipboard)
Vue.config.productionTip = false
Vue.use(ElementUI);
Axios.defaults.baseURL = process.env.PROD_ENVIROMENT;

/* eslint-disable no-new */
new Vue({
  el: '#app',
  router,
  store,
  components: { App },
  template: '<App/>'
})

