# 常见问题

## 服务请求(x)超时

核对客户端时间跟服务器时间，误差不能超过3秒。调大误差变为5秒，使用`apiConfig.setTimeoutSeconds(5);`

最好是做服务器时间同步

## 在业务方法中如何获取request对象？
ApiContext.getRequest()

## SDK加密传输json解析错误

如果使用了shiro等权限框架，注意配置url，IndexController里面有多个url，除了api，还有api/doc,api/ssl等，这些url都需要允许访问
可以使用api*通配符来允许访问。

## 如何获取当前调用者的appKey?

ApiContext.getApiParam().fatchAppKey()

## 直接返回方法中的结果

```
@Api(name = "xxx"
            , wrapResult = false // 对结果不进行包装，直接将ApiResult转成json形式返回
            )
    public ApiResult fun(GoodsParam param) {
        ApiResult apiResult = new ApiResult();
        apiResult.setCode(200);
        apiResult.setMsg("xxx");
        return apiResult;
    }
```

## 拦截器中使用spring注入

// 第一步
```
@Component // 加这个注解
public class MyInterceptor extends ApiInterceptorAdapter {
...
}
```


// 第二步
```
@Controller
@RequestMapping("/api")
public class IndexController extends ApiController {
    
    @Autowired
    private MyInterceptor myInterceptor;
    
    @Override
    protected void initApiConfig(ApiConfig apiConfig) {
        ...
        apiConfig.setInterceptors(new ApiInterceptor[]{myInterceptor});
        ...
    }

}
```