# 数据加密传输

默认我们的数据传输都是不经过加密的，要加密传输的话得用上HTTPS协议。easyopen在1.4.0版本开始提供了数据加密传输，不需要HTTPS协议。

easyopen基于公私钥+AES加密传输，交互流程如下：

```
0. 事先把公钥放在客户端,私钥放在服务端
1. 客户端生成一个随机码randomKey
2. 将randomKey通过公钥RSA加密str = rsa_encode(randomKey,publicKey)
3. 将str发送到服务端
4. 服务端通过私钥解开str,得到randomKey:randomKey = rsa_decode(str, privateKey)
5. 服务端使用randomKey通过AES对称加密一个值(假设值为"0")返回给客户端,resp = aes_encode("0", randomKey)
6. 客户端用自己的randomKey去aes解密resp,如果得到的是"0",则整个握手交互完成,后续都用这个randomKey进行aes加解密传输

注:
黑客是可以拿到公钥的,但是黑客无法知道客户端生成的随机码randomKey,一旦str发生改变则握手失败.
整个过程的重点就是将randomKey安全的送到服务器,后期都用randomKey进行对称加密传输,对称加密黑客无法破解.
此流程参照HTTPS,只不过服务器无法将公钥正确的送到客户端(浏览器),因此浏览器的HTTPS需要CA机构介入.
```

## 公私钥配置

- 生成公私钥

```java
public class PubPriKeyTest extends TestCase {
    /**
     * 生成公私钥
     * @throws Exception
     */
    @Test
    public void testCreate() throws Exception {
        KeyStore store = RSAUtil.createKeys();
        System.out.println("公钥:");
        System.out.println(store.getPublicKey());
        System.out.println("私钥:");
        System.out.println(store.getPrivateKey());
    }
}
```

- 在客户端新建一个pub.key文件，放入公钥字符串，pub.key放在客户端，启动的时候加载。
- 在服务端新建一个pri.key文件，放入私钥字符串，pri.key放在resources目录下，服务启动会自动读取。

easyopen-sdk的resources下已经存放了一个pub.key，实例化一个EncryptClient对象就能使用数据加密传输。感兴趣的同学可以查看源码，了解整个交互流程。

```
// 数据加密传输不需要secret
OpenClient client = new EncryptClient(url, app_key);
```