# 接口方法单值参数(v1.11.1)

在此之前，接口方法参数必须是一个Object对象，如下面的GoodsParam：

```java
@Api(name = "param.type.1")
    @ApiDocMethod(description = "参数类型，自定义类")
    public String demo1(GoodsParam param) {
        return JSON.toJSONString(param);
    }
```

有时候参数类里面只有一个属性，也要建一个类，这样做太麻烦，现在可以这样做：

```java
@Api(name = "param.type.4")
    @ApiDocMethod(description = "参数类型，String接收")
    @ApiDocReturn(description = "字符串返回值") // 当返回值是基本类型或string时
    public String demo3(
            @NotBlank(message = "不能为空")
            @Length(min = 3, max = 6, message = "长度3-6")
            @ApiDocField(description = "参数")
                    String param) { // 可直接申明参数，只能有一个参数，并且类型是基本类型或string
        return param;
    }
```

这样的话就不需要再新建类了。