# 限流功能（v1.9.1）

针对每个接口做限流功能，限流方式有两种：

- 漏桶策略：每秒处理固定数量的请求，超出请求返回错误信息。可用在秒杀、抢购业务
- 令牌桶策略：每秒放置固定数量的令牌数，不足的令牌数做等待处理，直到拿到令牌为止。平滑输出，可减轻服务器压力。

两种策略可在后台页面切换

## 开启限流功能

以springboot为例

- application.properties配置redis信息
- IndexController中配置：

```java
@Autowired
private RedisTemplate redisTemplate;

@Override
protected void initApiConfig(ApiConfig apiConfig) {
    ...

    // 配置拦截器
    apiConfig.setInterceptors(
            new ApiInterceptor[] {
                    new LimitInterceptor() // 限流拦截器,放在首位
                    ...
                    });       
    
    
    /*
     ****************设置限流管理************************* */
    apiConfig.setLimitManager(new ApiLimitManager(redisTemplate));
    // [可选]，设置配置页面访问密码
    //apiConfig.setLimitPassword(limitPassword);
    // [可选]，设置【策略】，默认为限流策略
    //apiConfig.setDefaultLimitType(defaultLimitType);
    // [可选]，设置【每秒可处理请求数】，默认50。策略为限流策略时，该值生效
    //apiConfig.setDefaultLimitCount(defaultLimitCount);
    // [可选]，设置【令牌桶容量】，默认50。策略为令牌桶策略时，该值生效
    //apiConfig.setDefaultTokenBucketCount(defaultTokenBucketCount); 
}
```

- 访问：http://localhost:8080/api/limit  对接口进行限流设置，默认密码limit123