# 开启app对接模式（v1.7.5）

如果平台直接跟Android或IOS对接，可开启这个功能。因为手机上的时间有可能跟服务端的时间不一致（用户的手机情况不可控）。

失去了时间校验，一个请求有可能被反复调用，服务端需要防止重复提交，有必要的话上HTTPS。


开启方式：

```
apiConfig.openAppMode();
```

开启app对接模式，开启后不进行timeout校验。

# 防止表单重复提交（v1.7.7）

使用redis分布式锁解决表单重复提交问题。

```
核心思想：

try {
    锁（用户id + 接口名） {
        执行业务代码
    }
} finally {
    释放锁
}

在锁的内部执行业务代码时，其它线程进来都将拒之门外。

```

新增拦截器继承BaseLockInterceptor 

```java
/**
 * 使用分布式锁防止表单重复提交
 * 
 * @author tanghc
 */
public class LockInterceptor extends BaseLockInterceptor {

    private StringRedisTemplate redisTemplate;

    public LockInterceptor() {
        redisTemplate = ApiContext.getApplicationContext().getBean(StringRedisTemplate.class);
    }

    @SuppressWarnings("rawtypes")
    @Override
    protected RedisTemplate getRedisTemplate() {
        return redisTemplate;
    }

    @Override
    protected String getUserId() {
        Map<String, Claim> jwtData = ApiContext.getJwtData();
        String id = jwtData.get("id").asString(); // 用户id
        return id;
    }

    @Override
    public boolean match(ApiMeta apiMeta) {
        return "userlock.test".equals(apiMeta.getName()); // 只针对这个接口
    }
}
```

实现上面三个方法即可,match方法返回true表示执行这个拦截器，可针对特定的接口做操作。

然后配置拦截器：

```
apiConfig.setInterceptors(new ApiInterceptor[] {new LockInterceptor()});
```