# 使用JWT

JWT的介绍参考这里：[什么是 JWT -- JSON WEB TOKEN](https://www.jianshu.com/p/576dbf44b2ae)。

之前我们的web应用使用session来维持用户与服务器之间的关系，其原理是使用一段cookie字符与服务器中的一个Map来对应，Map<cookie,UserInfo>，用户每次交互需要带一个sessionid过来。如果不使用分布式session，一旦服务器重启session会丢失，这样会影响用户体验，甚至影响业务逻辑。如果把用户信息存在客户端就没这个问题了。

easyopen创建JWT方式如下：

```
Map<String, String> data = new HashMap<>();
data.put("id", user.getId().toString());
data.put("username", user.getUsername());
        
String jwt = ApiContext.createJwt(data);
```

这段代码用在用户登录的时候，然后把jwt返回给客户端，让客户端保存，如H5可以存在localStorage中。

客户端传递jwt方式：

```
method.setRequestHeader("Authorization", "Bearer " + jwt);
```

即在header头部添加一个Authorization，内容是"Bearer " + jwt

客户端请求过来后，服务端获取jwt中的数据：

```
// 获取jwt数据
Map<String, Claim> jwtData = ApiContext.getJwtData();
```