# 生成文档页面

easyopen提供一个简单的api文档查看页面，类似于swagger，基于注解功能来生成文档页面。生成的文档页面可以查看参数、结果说明，也可以进行模拟请求。对于前后端分离的项目来说会很有帮助。文档界面如下图所示：

![输入图片说明](https://gitee.com/uploads/images/2018/0203/145842_55f2794e_332975.png "3.png")

左边的树形菜单对应文档名称，点击树可前往查看对应的接口说明。点击请求按钮可以发起请求进行测试。可修改业务参数中的值进行测试。

下面来讲解文档注解的使用方法。

文档页面默认是关闭的，需要在ApiConfig中设置
```
apiConfig.setShowDoc(true);// 为true开启文档页面。
```

接下来对获取商品接口设置文档信息：

```
@Api(name = "goods.get")
public Goods getGoods(GoodsParam param) {
    ...
    return goods;
}
```

## 设置文档注解

在接口方法上添加一个@ApiDocMethod注解。

```java
@Api(name = "goods.get")
@ApiDocMethod(description="获取商品") // 文档注解，description为接口描述
public Goods getGoods(GoodsParam param) {
    ...
    return goods;
}
```

## 设置参数注解

- 方式1：直接在`@ApiDocMethod`注解中申明`params`属性


```java
@Api(name = "goods.get")
@ApiDocMethod(description = "获取商品", params = {
            @ApiDocField(name = "id", dataType = DataType.INT, example = "1"),
            @ApiDocField(name = "goodsName", dataType = DataType.STRING, description = "商品名称", example = "iPhone6"),
    })
public Goods getGoods(GoodsParam param) {
    ...
    return goods;
}
```

- 方式2：在实体类的字段上申明`@ApiDocField`注解

进入GoodsParam类，使用@ApiDocField注解

```java
public class GoodsParam {

    @ApiDocField(description = "商品名称", required = true, example = "iphoneX")
    private String goods_name;
    // 省略 get set
}
```
@ApiDocField注解用来定义字段信息，@ApiDocField注解定义如下
```
/**
     * 字段描述
     */
    String description() default "";
    
    /**
     * 字段名
     */
    String name() default "";
    
    /**
     * 数据类型，int string float
     * @return
     */
    DataType dataType() default DataType.STRING;

    /**
     * 是否必填
     */
    boolean required() default false;
```

**注：方式1，方式2同时存在的情况下优先使用方式1**

## 设置返回结果注解

同样，在Goods类中设置@ApiDocField

```java
public class Goods {
    @ApiDocField(description = "id")
    private Long id;
    @ApiDocField(description = "商品名称")
    private String goods_name;
    @ApiDocField(description = "价格", dataType = DataType.FLOAT)
    private BigDecimal price;
    // 省略 get set
}
```

到此已经设置完毕了，可以访问url进行预览

## 文档页面URL

文档页面的url格式为：apiUrl + "/doc"。如：apiUrl为http://localhost:8080/api/v1，那么文档页面就是：http://localhost:8080/api/v1/doc


## List返回

如果接口方法返回一个List<T>，设置方式如下

```java
    @Api(name = "goods.list", version = "2.0")
    @ApiDocMethod(description="获取商品列表"
        ,results={@ApiDocField(description="商品列表",name="list", elementClass=Goods.class)}
    )
    public List<Goods> listGoods(GoodsParam param) {

    }
```

elementClass对应List中的元素类型

## 设置文档密码（v1.8.5）

```
apiConfig.setDocPassword("doc123"); // 设置文档页面密码
```

设置完成后，需要输入密码才能访问文档页面，可配合线上联调，排错。

## 修改文档页返回字段名（v1.8.5）

文档页面默认返回字段名为code,msg,data。可在IndexController中重写`processDocVelocityContext()`定义

```java
@Override
    protected void processDocVelocityContext(VelocityContext context) {
        context.put("code_name", "errCode");
        context.put("code_description", "状态值，\"0\"表示成功，其它都是失败");
        
        context.put("msg_name", "errMsg");
        context.put("msg_description", "错误信息，出错时显示");
        
        context.put("data_name", "respData");
        context.put("data_description", "返回的数据，没有则返回{}");
    }
```

## 第三方类返回

如果有个一个PageInfo<T>类，是第三方jar中的，没办法对其修改，那要如何对它里面的属性编写对应文档呢。

PageInfo<T>类内容如下：

```java
// 假设这是jar中的类，没法修改。但是要对其进行文档生成
public class PageInfo<T> {
    private int pageIndex;
    private int pageSize;
    private long total;
    // 省略 get set
}
```

我们可以显式的声明字段信息：

```java
    @Api(name = "goods.pageinfo", version = "1.0")
    @ApiDocMethod(description="获取商品列表"
            ,results={@ApiDocField(name="pageIndex",description="第几页",dataType=DataType.INT,example="1"),
                    @ApiDocField(name="pageSize",description="每页几条数据",dataType=DataType.INT,example="10"),
                    @ApiDocField(name="total",description="每页几条数据",dataType=DataType.LONG,example="100"),
                    @ApiDocField(name="rows",description="数据",dataType=DataType.ARRAY,elementClass=Goods.class),}
            )
    public PageInfo<Goods> pageinfo(GoodsParam param) {

    }
```

## 文档模型复用

如果多个接口都返回PageInfo<Goods>，需要复制黏贴大量的注解，改一个地方需要改多个接口，无法达到复用效果。我们可以新建一个GoodsPageVo继承PageInfo，然后把文档注解写在类的头部，这样可以达到复用效果。

```java
@ApiDocBean(fields = {
    @ApiDocField(name="pageIndex",description="第几页",dataType=DataType.INT,example="1"),
    @ApiDocField(name="pageSize",description="每页几条数据",dataType=DataType.INT,example="10"),
    @ApiDocField(name="total",description="每页几条数据",dataType=DataType.LONG,example="100"),
    @ApiDocField(name="rows",description="商品列表",dataType=DataType.ARRAY,elementClass=Goods.class),
})
public class GoodsPageVo extends PageInfo<Goods> {

}
```

```
    @Api(name = "goods.pageinfo", version = "2.0")
    @ApiDocMethod(description="获取商品列表",resultClass=GoodsPageVo.class)
    public PageInfo<Goods> pageinfo2(GoodsParam param) {

    }
```

使用resultClass=GoodsPageVo.class指定返回结果类型即可。

## 更改文档显示位置（v1.9.1）

可以使用`order`属性来指定文档显示位置，值越小越靠前

```
@ApiDoc(value = "文档demo，参考DocDemoApi.java", order = 1)

@ApiDocMethod(description = "第一个",  order = 1 // 指定了order，优先按这个值排序
    )

若不指定order，则按接口名排序
```