# 自定义序列化

easyopen序列化使用fastjson处理json，xstream处理xml。现在我们来自定义实现一个json处理：

- 新建一个类JsonFormatter，实现ResultSerializer接口

```java
public class JsonFormatter implements ResultSerializer {
    @Override
    public String serialize(Object obj) {
        Gson gson = new Gson();
        return gson.toJson(obj);
    }
}

```

这里使用了Gson。

- 在apiConfig中配置

```java
@Controller
@RequestMapping("/project/api")
public class IndexController extends ApiController {

    @Override
    protected void initApiConfig(ApiConfig apiConfig) {            
        // 自定义json序列化
        apiConfig.setJsonResultSerializer(new JsonFormatter());
        省略其它代码...    
    }
    
}
```