# 自定义结果返回

## 改变json输出策略

默认使用阿里的fastjson进行json输出

```
JSON.toJSONString(obj)
```

如果要更换输出策略，操作方式如下：

```java
@Override
protected void initApiConfig(ApiConfig apiConfig) {
    ...
    // 自定义json格式输出,将null字符串变成""
    apiConfig.setJsonResultSerializer(new JsonResultSerializer(){
        @Override
        public String serialize(Object obj) {
            return JSON.toJSONString(obj, SerializerFeature.WriteMapNullValue,SerializerFeature.WriteNullStringAsEmpty);
        }
    });
    ...
}
```
上面示例是将null字符串变成""，如果是给安卓app提供接口，这个会很管用。

## 改变json格式

easyopen默认的返回类是ApiResult，解析成json格式为：
```
{
	"code": "0",
	"msg": "",
	"data": {...}
}
```

我们也可以自定义返回结果，比如我们要返回这样的json：

```
{
    "errCode":"0",
    "errMsg":"",
    "body":{...}
}
```

- 首先，新建结果类，实现com.gitee.easyopen.Result接口：

```java
import com.gitee.easyopen.Result;

public class MyResult implements Result {
    private static final long serialVersionUID = -6618981510574135069L;

    private String errCode;
    private String errMsg;
    private String body;

    @Override
    public void setCode(Object code) {
        this.setErrCode(String.valueOf(code));
    }

    @Override
    public void setMsg(String msg) {
        this.setErrMsg(msg);
    }

    @Override
    public void setData(Object data) {
        this.setBody(String.valueOf(data));
    }

    public String getErrCode() {
        return errCode;
    }

    public void setErrCode(String errCode) {
        this.errCode = errCode;
    }

    public String getErrMsg() {
        return errMsg;
    }

    public void setErrMsg(String errMsg) {
        this.errMsg = errMsg;
    }

    public String getBody() {
        return body;
    }

    public void setBody(String body) {
        this.body = body;
    }
}
```

MyResult类可定义自己想要的字段名字，实现Result接口对应的方法即可

- 然后，新建一个结果生成器，实现ResultCreator接口：

```java
import com.gitee.easyopen.Result;
import com.gitee.easyopen.ResultCreator;

public class MyResultCreator implements ResultCreator {

    @Override
    public Result createResult(Object returnObj) {
        MyResult ret = new MyResult();
        ret.setCode(0);
        ret.setData(returnObj);
        return ret;
    }

    @Override
    public Result createErrorResult(Object code, String errorMsg, Object data) {
        MyResult ret = new MyResult();
        ret.setCode(code);
        ret.setMsg(errorMsg);
        ret.setData(data);
        return ret;
    }

}
```

ResultCreator接口定义两个方法，createResult是返回正确内容的方法，createErrorResult是返回错误时候的方法。
分别实现它们，用我们刚才新建的MyResult类。

- 最后，配置结果生成器，在initApiConfig方法中配置：

```java
@Controller
@RequestMapping("/project/api")
public class IndexController extends ApiController {

    @Override
    protected void initApiConfig(ApiConfig apiConfig) {  
          
        // 配置结果生成器
        apiConfig.setResultCreator(new MyResultCreator()); 
        省略其它代码...    
    }
    
}
```

调用apiConfig.setResultCreator(new MyResultCreator());进行配置