# 业务参数校验

业务参数校验采用JSR-303方式，关于JSR-303介绍可以参考这篇博文：[JSR 303 - Bean Validation 介绍及最佳实践](https://www.ibm.com/developerworks/cn/java/j-lo-jsr303/)

在参数中使用注解即可，框架会自动进行验证。如下面一个添加商品接口，它的参数是GoodsParam

```java
@Api(name = "goods.add")
public void addGoods(GoodsParam param) {
    ...
}
```
在GoodsParam中添加JSR-303注解:

```java
public class GoodsParam {
    @NotEmpty(message = "商品名称不能为空")    
    private String goods_name;
    // 省略get，set
}
```

如果不传商品名称则返回

```
{"code":"100","msg":"商品名称不能为空"}
```

## 参数校验国际化

国际化的配置方式如下：

```java
@NotEmpty(message = "{goods.name.notNull}")
private String goods_name;
```

国际化资源文件goods_error_en.properties中添加：
```
goods.name.notNull=The goods_name can not be null
```

goods_error_zh_CN.properties中添加：

```
goods.name.notNull=\u5546\u54C1\u540D\u79F0\u4E0D\u80FD\u4E3Anull
```

## 参数校验国际化传参

下面校验商品名称的长度，要求大于等于3且小于等于20。数字3和20要填充到国际化资源中去。

```
// 传参的格式：{xxx}=value1,value2...
@Length(min = 3, max = 20, message = "{goods.name.length}=3,20")
private String goods_name;
```

goods_error_en.properties:
```
goods.name.length=The goods_name length must >= {0} and <= {1}
```

goods_error_zh_CN.properties中添加：

```
goods.name.length=\u5546\u54C1\u540D\u79F0\u957F\u5EA6\u5FC5\u987B\u5927\u4E8E\u7B49\u4E8E{0}\u4E14\u5C0F\u4E8E\u7B49\u4E8E{1}

```
这样value1，value2会分别填充到{0},{1}中