# 错误处理

easyopen对错误处理已经封装好了，最简单的做法是向上throw即可，在最顶层的Controller会做统一处理。例如：
```java
if(StringUtils.isEmpty(param.getGoods_name())) {
    throw new ApiException("goods_name不能为null");
}
```

或者

```java
if(StringUtils.isEmpty(param.getGoods_name())) {
    throw new RuntimeException("goods_name不能为null");
}
```

为了保证编码风格的一致性，推荐统一使用ApiException

## i18n国际化

easyopen支持国际化消息。通过Request对象中的getLocale()来决定具体返回那种语言，客户端通过设置Accept-Language头部来决定返回哪种语言，中文是zh，英文是en。

easyopen通过模块化来管理国际化消息，这样做的好处结构清晰，维护方便。下面就来讲解如何设置国际化消息。

假设我们要对商品模块进行设置，步骤如下：

- 在项目的resources下新建如下目录/i18n/isv
- 在isv目录下新建goods_error_zh_CN.properties属性文件

![输入图片说明](https://gitee.com/uploads/images/2018/0118/142511_feacd145_332975.png "2.png")

属性文件的文件名有规律， **i18n/isv/goods_error** 表示模块路径， **_zh_CN.properties** 表示中文错误消息。如果要使用英文错误，则新建一个goods_error_en.properties即可。

- 在goods_error_zh_CN.properties中配置错误信息
```
# 商品名字不能为空
isv.goods_error_100=\u5546\u54C1\u540D\u79F0\u4E0D\u80FD\u4E3A\u7A7A
```

isv.goods_error_为固定前缀，100为错误码，这两个值后续会用到。

接下来是把属性文件加载到国际化容器当中。

- 添加国际化配置

easyopen的所以配置操作都在ApiConfig类里面，配置工作可以在ApiController.initApiConfig(ApiConfig apiConfig)方法中进行，因此只要重写initApiConfig(ApiConfig apiConfig)方法就行了。

```java
@Controller
@RequestMapping(value = "/api/v1")
public class IndexController extends ApiController {

    @Override
    protected void initApiConfig(ApiConfig apiConfig) {
        // 配置国际化消息
        apiConfig.getIsvModules().add("i18n/isv/goods_error");// 模块路径
        // 配置appKey秘钥
        Map<String, String> appSecretStore = new HashMap<String, String>();
        appSecretStore.put("test", "123456");
        
        apiConfig.addAppSecret(appSecretStore);
    }

}
```

添加一句apiConfig.getIsvModules().add("i18n/isv/goods_error");就行

- 新建一个interface用来定义错误

```java
// 按模块来定义异常消息,团队开发可以分开进行
public interface GoodsErrors {

    String isvModule = "isv.goods_error_"; // 前缀
    // 100为前缀后面的错误码
    // 这句话即可找到isv.goods_error_100错误
    ErrorMeta NO_GOODS_NAME = new ErrorMeta(isvModule, "100", "商品名称不能为空.");
}
```

接下来就可以使用了
```java
if (StringUtils.isEmpty(param.getGoods_name())) {
    throw GoodsErrors.NO_GOODS_NAME.getException();
}
```

### 国际化消息传参

即代码中变量传入到properties文件中去，做法是采用{0},{1}占位符。0代表第一个参数，1表示第二个参数。

```
# 商品名称太短，不能小于{0}个字
isv.goods_error_101=\u5546\u54C1\u540D\u79F0\u592A\u77ED\uFF0C\u4E0D\u80FD\u5C0F\u4E8E{0}\u4E2A\u5B57
```

```java
if(param.getGoods_name().length() < 3) {
    throw GoodsErrors.SHORT_GOODS_NAME.getException(3); // 这里的“3”会填充到{0}中
}
```
直接放进getException(Object... params)方法参数中，因为是可变参数，可随意放。