# 快速开始

eclipse下（idea原理一样）

- 下载或clone项目https://gitee.com/durcframework/easyopen.git [下载zip](https://gitee.com/durcframework/easyopen/repository/archive/master.zip)
- eclipse右键import... -> Exsiting Maven Projects。选择easyopen目录
- 导入到eclipse后会有三个工程，等待相关jar包下载。
- 全部jar下载完毕后，启动easyopen-server-manual项目，由于是spring-boot项目，直接运行ManualSpringbootApplication.java即可
- 在easyopen-sdk/sdk-java中找到SdkTest.java测试用例，运行单元测试。
- 文档页面：`http://localhost:8080/api/doc`


## 编写业务类

- 新建一个java类名为HelloworldApi，并加上@ApiService注解

加上@ApiService注解后这个类就具有了提供接口的能力。

```java
@ApiService
public class HelloWorldApi {

}

```

- 在类中添加一个方法

```java
@Api(name = "hello")
public String helloworld() {
    return "hello world";
}
```

这个方法很简单，就返回了一个字符串，方法被@Api标记，表示对应的接口，name是接口名。

到此，一个业务方法就写完了，接下来是编写sdk并测试。


## 编写SDK并测试(旧)

此过程在easyopen-sdk中进行。


- 新建Response响应类

```java
public class HelloResp extends BaseResp<String> {

}
```

- 新建Request请求类

```java
public class HelloReq extends BaseNoParamReq<HelloResp> {

    public HelloReq(String name) {
        super(name);
    }


}
```

BaseResp<T>的泛型参数指定返回体类型，这里指定String

- 编写单元测试

```java
public class HelloTest extends TestCase {

    String url = "http://localhost:8091/api";
    String appKey = "test";
    String secret = "123456";
    // 创建一个实例即可
    OpenClient client = new OpenClient(url, appKey, secret);

    @Test
    public void testGet() throws Exception {
        HelloReq req = new HelloReq("hello"); // hello对应@Api中的name属性，即接口名称

        HelloResp result = client.request(req); // 发送请求
        if (result.isSuccess()) {
            String resp = result.getBody();
            System.out.println(resp); // 返回hello world
        } else {
            throw new RuntimeException(result.getMsg());
        }

    }

}
```

这样，一个完整的接口就写完了。

## 编写SDK并测试(新)

### 接口封装步骤

比如获取商品信息接口

- 接口名：goods.get
- 版本号：""(空字符串)
- 参数：goods_name 商品名称
- 返回信息

```json
{
    "code":"0",
    "data":{
        "goods_name":"苹果iPhoneX",
        "id":1,
        "price":8000
    }
}
```

针对这个接口，封装步骤如下：



1.在`model`包下新建一个类来接收`data`部分

字段统一使用小写字母+下划线形式，如:name,user_age

```java
public class Goods {

    private Long id;
    private String goods_name;
    private BigDecimal price;

    省略 get set
}
```

2.在`response`包下新建一个返回类，继承`BaseResponse`

BaseResponse中有个泛型参数，填`Goods`类，表示返回的数据对象。

```java
public class GetGoodsResponse extends BaseResponse<Goods> {
}
```

3.在`request`包下新建一个请求类，继承`BaseRequest`

BaseRequest中有个泛型参数，填`GetGoodsResponse`类，表示这个请求对应的返回类。
重写`name()`方法，填接口名。

如果要指定版本号，可重写`version()`方法，或者后续使用`request.setVersion(version)`进行设置

```java
public class GetGoodsRequest extends BaseRequest<GetGoodsResponse> {
    @Override
    public String name() {
        return "goods.get";
    }
}
```

### 使用方式

```java
// 创建请求对象
GetGoodsRequest request = new GetGoodsRequest();
// 请求参数
GoodsParam param = new GoodsParam();
param.setGoods_name("iphone6");
request.setParam(param);

// 发送请求
GetGoodsResponse response = client.execute(request);

System.out.println("--------------------");
if (response.isSuccess()) {
    // 返回结果
    Goods goods = response.getData();
    System.out.println(goods);
} else {
    System.out.println("errorMsg:" + response.getMsg());
}
System.out.println("--------------------");
```

### 使用方式2(懒人版)

如果不想添加Request,Response,Model。可以用这种方式，返回data部分是Map<String, Object>，后续自己处理

```java
// 创建请求对象
CommonRequest request = new CommonRequest("goods.get");
// 请求参数
Map<String, Object> param = new HashMap<>();
param.put("goods_name", "iphone6");
request.setParam(param);

// 发送请求
CommonResponse response = client.execute(request);

System.out.println("--------------------");
if (response.isSuccess()) {
    // 返回结果
    Map<String, Object> goods = response.getData();
    System.out.println(goods.get("goods_name"));
} else {
    System.out.println("errorCode:" + response.getCode() + ",errorMsg:" + response.getMsg());
}
System.out.println("--------------------");
```