# easyopen介绍

一个简单易用的接口开放平台，平台封装了常用的参数校验、结果返回等功能，开发者只需实现业务代码即可。

easyopen的功能类似于[淘宝开放平台](http://open.taobao.com/docs/api.htm?spm=a219a.7629065.0.0.6cQDnQ&apiId=4)，它的所有接口只提供一个url，通过参数来区分不同业务。这样做的好处是接口url管理方便了，平台管理者只需维护好接口参数即可。由于参数的数量是可知的，这样可以在很大程度上进行封装。封装完后平台开发者只需要写业务代码，其它功能可以通过配置来完成。

得益于Java的注解功能以及Spring容器对bean的管理，我们的开放接口平台就这样产生了。

## 结构图

![easyopen架构](https://images.gitee.com/uploads/images/2018/0730/181724_32093df8_332975.png "easyopen架构.png")

- 服务器启动完毕时，从Spring容器中找到被@ApiService标记的业务类
- 循环业务类，找到被@Api标记的方法，并保存对应的参数，method，对象信息。
- 客户端请求过来时，根据name-version可定位到具体的业务类中的某个方法，然后invoke方法。
- 包装结果返回。

## 功能特点

- 开箱即用，写完业务代码直接启动服务即可使用，无需其它配置。
- 参数自动校验，支持国际化参数校验（JSR-303）。
- 校验功能和结果返回功能实现各自独立，方便自定义实现或扩展。
- 采用注解来定义接口，维护简单方便。
- 支持i18n国际化消息返回。
- 自动生成文档页面，类似swagger。
- 采用数字签名进行参数验证，签名算法见：easyopen\签名算法.txt。
- 采用appKey-secret形式接入平台，即需要给接入方提供一个appKey和secret。