import ThemeToggle from "@/components/layout/ThemeToggle/theme-toggle";
import { cn } from "@/lib/utils";
import { MobileSidebar } from "./mobile-sidebar";
import { UserNav } from "./user-nav";
import Link from "next/link";
import { Session } from "next-auth";

interface HeaderProps {
  session: Session;
}

export function Header({ session }: HeaderProps) {
  return (
    <div className="fixed top-0 left-0 right-0 supports-backdrop-blur:bg-background/60 border-b bg-background/95 backdrop-blur z-20">
      <nav className="h-14 flex items-center justify-between px-4">
        <div className="hidden lg:block">
          <Link
            href={"https://eartho.io"}
            target="_blank"
            className="flex items-center space-x-2"
          >
            {/* <svg height="32" viewBox="0 0 1723 512" fill="none" xmlns="http://www.w3.org/2000/svg">
              <rect width="1722.68" height="512" rx="32" fill="black" />
              <path d="M186.393 387V96.0909H382.416V146.801H247.899V216.119H372.331V266.83H247.899V336.29H382.984V387H186.393ZM488.395 391.119C474.474 391.119 462.069 388.705 451.179 383.875C440.289 378.951 431.671 371.706 425.327 362.142C419.077 352.483 415.952 340.456 415.952 326.062C415.952 313.941 418.177 303.761 422.628 295.523C427.079 287.284 433.139 280.655 440.81 275.636C448.48 270.617 457.192 266.83 466.946 264.273C476.795 261.716 487.116 259.917 497.912 258.875C510.601 257.549 520.829 256.318 528.594 255.182C536.359 253.951 541.993 252.152 545.497 249.784C549.001 247.417 550.753 243.913 550.753 239.273V238.42C550.753 229.424 547.912 222.464 542.23 217.54C536.643 212.616 528.688 210.153 518.366 210.153C507.476 210.153 498.812 212.568 492.372 217.398C485.933 222.133 481.671 228.098 479.588 235.295L423.622 230.75C426.463 217.492 432.05 206.034 440.384 196.375C448.717 186.621 459.465 179.14 472.628 173.932C485.885 168.629 501.226 165.977 518.651 165.977C530.772 165.977 542.372 167.398 553.452 170.239C564.626 173.08 574.522 177.483 583.139 183.449C591.851 189.415 598.717 197.085 603.736 206.46C608.755 215.741 611.264 226.867 611.264 239.841V387H553.878V356.744H552.173C548.67 363.562 543.982 369.576 538.111 374.784C532.24 379.898 525.185 383.922 516.946 386.858C508.707 389.699 499.19 391.119 488.395 391.119ZM505.724 349.358C514.626 349.358 522.486 347.606 529.304 344.102C536.122 340.504 541.473 335.674 545.355 329.614C549.238 323.553 551.179 316.687 551.179 309.017V285.864C549.285 287.095 546.681 288.231 543.366 289.273C540.147 290.22 536.501 291.119 532.429 291.972C528.357 292.729 524.285 293.439 520.213 294.102C516.141 294.67 512.448 295.191 509.134 295.665C502.031 296.706 495.829 298.364 490.526 300.636C485.223 302.909 481.103 305.987 478.168 309.869C475.232 313.657 473.764 318.392 473.764 324.074C473.764 332.312 476.747 338.61 482.713 342.966C488.774 347.227 496.444 349.358 505.724 349.358ZM654.21 387V168.818H712.875V206.886H715.148C719.125 193.345 725.801 183.117 735.176 176.205C744.551 169.197 755.347 165.693 767.562 165.693C770.593 165.693 773.86 165.883 777.364 166.261C780.867 166.64 783.945 167.161 786.597 167.824V221.517C783.756 220.665 779.826 219.907 774.807 219.244C769.788 218.581 765.195 218.25 761.028 218.25C752.127 218.25 744.172 220.191 737.165 224.074C730.252 227.862 724.759 233.165 720.688 239.983C716.71 246.801 714.722 254.661 714.722 263.562V387H654.21ZM940.871 168.818V214.273H809.479V168.818H940.871ZM839.308 116.545H899.82V319.955C899.82 325.542 900.672 329.898 902.376 333.023C904.081 336.053 906.448 338.184 909.479 339.415C912.604 340.646 916.202 341.261 920.274 341.261C923.115 341.261 925.956 341.025 928.797 340.551C931.638 339.983 933.816 339.557 935.331 339.273L944.848 384.301C941.818 385.248 937.556 386.337 932.064 387.568C926.571 388.894 919.895 389.699 912.036 389.983C897.452 390.551 884.668 388.61 873.683 384.159C862.793 379.708 854.318 372.795 848.257 363.42C842.196 354.045 839.214 342.208 839.308 327.909V116.545ZM1041.49 260.864V387H980.976V96.0909H1039.78V207.312H1042.34C1047.26 194.434 1055.22 184.348 1066.2 177.057C1077.19 169.67 1090.97 165.977 1107.54 165.977C1122.69 165.977 1135.9 169.292 1147.17 175.92C1158.53 182.455 1167.34 191.877 1173.59 204.188C1179.93 216.403 1183.06 231.034 1182.96 248.08V387H1122.45V258.875C1122.55 245.428 1119.14 234.964 1112.23 227.483C1105.41 220.002 1095.84 216.261 1083.53 216.261C1075.29 216.261 1068 218.013 1061.66 221.517C1055.41 225.021 1050.48 230.134 1046.88 236.858C1043.38 243.487 1041.58 251.489 1041.49 260.864ZM1325.16 391.261C1303.1 391.261 1284.02 386.574 1267.92 377.199C1251.92 367.729 1239.56 354.566 1230.85 337.71C1222.13 320.759 1217.78 301.11 1217.78 278.761C1217.78 256.223 1222.13 236.527 1230.85 219.67C1239.56 202.72 1251.92 189.557 1267.92 180.182C1284.02 170.712 1303.1 165.977 1325.16 165.977C1347.23 165.977 1366.26 170.712 1382.27 180.182C1398.37 189.557 1410.77 202.72 1419.48 219.67C1428.2 236.527 1432.55 256.223 1432.55 278.761C1432.55 301.11 1428.2 320.759 1419.48 337.71C1410.77 354.566 1398.37 367.729 1382.27 377.199C1366.26 386.574 1347.23 391.261 1325.16 391.261ZM1325.45 344.386C1335.49 344.386 1343.87 341.545 1350.59 335.864C1357.31 330.087 1362.38 322.227 1365.79 312.284C1369.29 302.341 1371.05 291.025 1371.05 278.335C1371.05 265.646 1369.29 254.33 1365.79 244.386C1362.38 234.443 1357.31 226.583 1350.59 220.807C1343.87 215.03 1335.49 212.142 1325.45 212.142C1315.32 212.142 1306.79 215.03 1299.88 220.807C1293.06 226.583 1287.9 234.443 1284.4 244.386C1280.99 254.33 1279.28 265.646 1279.28 278.335C1279.28 291.025 1280.99 302.341 1284.4 312.284C1287.9 322.227 1293.06 330.087 1299.88 335.864C1306.79 341.545 1315.32 344.386 1325.45 344.386ZM1503.27 390.693C1493.89 390.693 1485.84 387.379 1479.12 380.75C1472.49 374.027 1469.18 365.977 1469.18 356.602C1469.18 347.322 1472.49 339.367 1479.12 332.739C1485.84 326.11 1493.89 322.795 1503.27 322.795C1512.36 322.795 1520.31 326.11 1527.13 332.739C1533.95 339.367 1537.36 347.322 1537.36 356.602C1537.36 362.852 1535.75 368.581 1532.53 373.79C1529.4 378.903 1525.28 383.023 1520.17 386.148C1515.06 389.178 1509.42 390.693 1503.27 390.693Z" fill="white" />
            </svg> */}
            <span className="text-[22px] text-black font-bold">Eartho.</span>

            <span className="text-[20px] text-gray-500 opacity-95">Account</span>
          </Link>
        </div>
        <div className={cn("block lg:!hidden")}>
          <MobileSidebar />
        </div>

        <div className="flex items-center gap-2">
          <UserNav session={session} />
          <ThemeToggle />
        </div>
      </nav>
    </div>
  );
}
