type IconProps = React.HTMLAttributes<SVGElement>

import {
  AlertTriangle,
  AppWindowMac,
  ArrowLeft,
  ArrowRight,
  Check,
  ChevronLeft,
  ChevronRight,
  CircuitBoardIcon,
  Command,
  Cookie,
  CreditCard,
  File,
  FileText,
  Fingerprint,
  HelpCircle,
  Image,
  Laptop,
  LayoutDashboardIcon,
  Loader2,
  LogIn,
  LucideIcon,
  LucideProps,
  Moon,
  MoreVertical,
  Pizza,
  Plus,
  Settings,
  Shield,
  SunMedium,
  Trash,
  IdCard,
  User,
  User2Icon,
  UserX2Icon,
  Wallet,
  X,
  PlugZap,
} from "lucide-react";

export type Icon = LucideIcon;

export const Icons = {
  dashboard: LayoutDashboardIcon,
  logo: Command,
  login: LogIn,
  close: X,
  back: ArrowLeft,
  profile: User2Icon,
  spinner: Loader2,
  kanban: CircuitBoardIcon,
  chevronLeft: ChevronLeft,
  chevronRight: ChevronRight,
  trash: Trash,
  employee: UserX2Icon,
  post: FileText,
  shield: Shield,
  wallet: Wallet,
  page: File,
  preferences: AppWindowMac,
  media: Image,
  settings: Settings,
  billing: CreditCard,
  ellipsis: MoreVertical,
  add: Plus,
  warning: AlertTriangle,
  user: User,
  idCard: IdCard,
  identity: Fingerprint,
  privacy: Cookie,
  arrowRight: ArrowRight,
  help: HelpCircle,
  pizza: Pizza,
  sun: SunMedium,
  moon: Moon,
  laptop: Laptop,
  check: Check,
  connect: PlugZap,
  google: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" fill="none" viewBox="0 0 24 24" {...props}><path fill="#4285F4" fillRule="evenodd" d="M23.52 12.273c0-.851-.076-1.67-.218-2.455H12v4.642h6.458a5.52 5.52 0 0 1-2.394 3.622v3.01h3.878c2.269-2.088 3.578-5.165 3.578-8.82" clipRule="evenodd" /><path fill="#34A853" fillRule="evenodd" d="M12 24c3.24 0 5.956-1.074 7.942-2.907l-3.878-3.01c-1.075.72-2.45 1.145-4.064 1.145-3.125 0-5.77-2.111-6.715-4.948H1.276v3.11A12 12 0 0 0 12 24" clipRule="evenodd" /><path fill="#FBBC05" fillRule="evenodd" d="M5.285 14.28A7.2 7.2 0 0 1 4.91 12c0-.79.136-1.56.376-2.28V6.611H1.276A12 12 0 0 0 0 12.001c0 1.936.464 3.769 1.276 5.389z" clipRule="evenodd" /><path fill="#EA4335" fillRule="evenodd" d="M12 4.773c1.762 0 3.344.605 4.587 1.794l3.442-3.442C17.951 1.19 15.235 0 12 0 7.31 0 3.25 2.69 1.276 6.61l4.01 3.11C6.228 6.884 8.874 4.773 12 4.773" clipRule="evenodd" /></svg>
  ),
  apple: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 24 24" {...props}><path d="M21.772 18.703q-.549 1.257-1.302 2.32-1.028 1.451-1.677 2.009-1.004.915-2.156.94-.829.001-1.991-.47-1.165-.47-2.144-.47-1.027 0-2.204.47-1.179.472-1.905.496-1.105.047-2.205-.966-.702-.606-1.754-2.08Q3.306 19.38 2.579 17.3q-.78-2.246-.78-4.352 0-2.413 1.054-4.158a6.15 6.15 0 0 1 2.206-2.21 6 6 0 0 1 2.982-.835q.877.002 2.306.532 1.428.532 1.83.533.302 0 2.029-.628 1.63-.58 2.757-.485 3.058.244 4.586 2.393-2.732 1.643-2.705 4.593c.016 1.531.577 2.806 1.678 3.817q.748.705 1.678 1.09-.202.58-.428 1.113M17.1.48q0 1.801-1.325 3.358c-1.064 1.234-2.351 1.946-3.747 1.834a4 4 0 0 1-.028-.455c0-1.152.506-2.386 1.405-3.394q.673-.765 1.711-1.273Q16.151.048 17.074 0q.026.24.025.48" /></svg>
  ),
  facebook: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" viewBox="0 0 1365.333 1365.333" height={1365.333} width={1365.333} xmlSpace="preserve"    {...props}  >    <path style={{ fill: "#1877f2", fillOpacity: 1, fillRule: "nonzero", stroke: "none", }} d="M10240 5120c0 2827.7-2292.3 5120-5120 5120S0 7947.7 0 5120C0 2564.46 1872.31 446.301 4320 62.2V3640H3020v1480h1300v1128c0 1283.2 764.38 1992 1933.9 1992 560.17 0 1146.1-100 1146.1-100V6880h-645.62c-636.03 0-834.38-394.67-834.38-799.57V5120h1420l-227-1480H5920V62.2c2447.69 384.1 4320 2502.26 4320 5057.8" transform="matrix(.13333 0 0 -.13333 0 1365.333)" />    <path style={{ fill: "#fff", fillOpacity: 1, fillRule: "nonzero", stroke: "none", }} d="m7113 3640 227 1480H5920v960.43c0 404.9 198.35 799.57 834.38 799.57H7400v1260s-585.93 100-1146.1 100C5084.38 8240 4320 7531.2 4320 6248V5120H3020V3640h1300V62.2C4580.67 21.3 4847.84 0 5120 0s539.33 21.3 800 62.2V3640z" transform="matrix(.13333 0 0 -.13333 0 1365.333)" />  </svg>
  ),
  twitter: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" fill="none" viewBox="0 0 24 24" {...props}><path fill="#1D9BF0" d="M21.057 7.181c.01.211.01.413.01.624.009 6.403-4.696 13.795-13.3 13.795-2.537 0-5.028-.758-7.167-2.179a9.174 9.174 0 0 0 6.918-2.016c-2-.038-3.76-1.392-4.371-3.37a4.37 4.37 0 0 0 2.111-.086c-2.176-.441-3.741-2.429-3.75-4.742v-.058c.648.375 1.38.586 2.12.605C1.582 8.334.943 5.5 2.184 3.284c2.38 3.033 5.88 4.867 9.64 5.068a4.98 4.98 0 0 1 1.352-4.636c1.88-1.834 4.844-1.738 6.622.21a9.1 9.1 0 0 0 2.972-1.18 4.86 4.86 0 0 1-2.055 2.678 9.4 9.4 0 0 0 2.685-.758 9.8 9.8 0 0 1-2.343 2.515" /></svg>
  ),
  emailotp: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 490 490" {...props}><path d="M295.2 257.8 251.4 295c-3.5 2.9-8.6 2.9-12 0l-43.8-37.1L16.7 409.1h456.6zM0 92.2v305.6L180.1 245z" /><path d="M16.7 80.9 245 274.6 473.3 80.9zM309.9 245 490 397.8V92.2z" /></svg>
  ),
  github: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 32 32" {...props}><path d="M16 .396c-8.839 0-16 7.167-16 16 0 7.073 4.584 13.068 10.937 15.183.803.151 1.093-.344 1.093-.772 0-.38-.009-1.385-.015-2.719-4.453.964-5.391-2.151-5.391-2.151-.729-1.844-1.781-2.339-1.781-2.339-1.448-.989.115-.968.115-.968 1.604.109 2.448 1.645 2.448 1.645 1.427 2.448 3.744 1.74 4.661 1.328.14-1.031.557-1.74 1.011-2.135-3.552-.401-7.287-1.776-7.287-7.907 0-1.751.62-3.177 1.645-4.297-.177-.401-.719-2.031.141-4.235 0 0 1.339-.427 4.4 1.641a15.4 15.4 0 0 1 4-.541c1.36.009 2.719.187 4 .541 3.043-2.068 4.381-1.641 4.381-1.641.859 2.204.317 3.833.161 4.235 1.015 1.12 1.635 2.547 1.635 4.297 0 6.145-3.74 7.5-7.296 7.891.556.479 1.077 1.464 1.077 2.959 0 2.14-.02 3.864-.02 4.385 0 .416.28.916 1.104.755 6.4-2.093 10.979-8.093 10.979-15.156 0-8.833-7.161-16-16-16z" /></svg>
  ),
  sms: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 490 490" {...props}><path d="M384.547 31.26H105.453C47.313 31.26 0 79.606 0 139.016v106.739c0 59.411 47.313 107.756 105.453 107.756h176.408L410.103 458.74V350.266C456.489 338.453 490 295.745 490 245.755V139.016c0-59.41-47.313-107.756-105.453-107.756M112.84 238.413c-12.486 0-23.612-2.722-30.819-6.624l5.264-21.264c5.458 3.32 16.778 7.223 25.556 7.223 8.972 0 12.681-3.125 12.681-8 0-4.89-2.931-7.223-14.041-10.931-19.709-6.639-27.32-17.361-27.126-28.681 0-17.75 15.223-31.208 38.82-31.208 11.125 0 21.085 2.527 26.931 5.458l-5.264 20.486c-4.292-2.348-12.486-5.473-20.681-5.473-7.223 0-11.32 2.931-11.32 7.806 0 4.486 3.708 6.834 15.417 10.931 18.139 6.236 25.75 15.417 25.945 29.459-.001 17.749-14.043 30.818-41.363 30.818m203.474-1.944h-28.875V184.58c0-13.862-4.501-21.862-14.056-21.862-6.819 0-11.709 4.68-13.653 10.348-.778 2.138-1.166 5.264-1.166 7.611v55.792h-28.875V183.01c0-12.098-4.292-20.292-13.668-20.292-7.596 0-12.098 5.862-13.847 10.737-.972 2.333-1.166 5.069-1.166 7.417v55.598h-28.875v-64.973c0-11.888-.389-22.042-.778-30.431h24.973l1.361 12.875h.583c4.097-6.041 12.486-15.013 28.875-15.013 12.292 0 22.042 6.236 26.139 16.18h.389c3.514-4.875 7.806-8.778 12.292-11.499 5.279-3.125 11.125-4.68 18.154-4.68 18.333 0 32.195 12.875 32.195 41.347v56.193zm48.928 1.944c-12.486 0-23.612-2.722-30.819-6.624l5.264-21.264c5.458 3.32 16.778 7.223 25.556 7.223 8.972 0 12.681-3.125 12.681-8 0-4.89-2.931-7.223-14.042-10.931-19.709-6.639-27.32-17.361-27.126-28.681 0-17.75 15.223-31.208 38.82-31.208 11.125 0 21.07 2.527 26.931 5.458l-5.264 20.486c-4.292-2.348-12.486-5.473-20.681-5.473-7.223 0-11.32 2.931-11.32 7.806 0 4.486 3.708 6.834 15.417 10.931 18.139 6.236 25.75 15.417 25.945 29.459 0 17.749-14.042 30.818-41.362 30.818" /></svg>
  ),
  vk: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" fill="none" viewBox="0 0 24 24" {...props}><path fill="#07F" d="M13.072 20C4.872 20 .195 14.37 0 5h4.107c.135 6.877 3.163 9.79 5.562 10.39V5h3.868v5.93c2.368-.254 4.856-2.957 5.696-5.93H23.1c-.644 3.664-3.343 6.366-5.261 7.477C19.758 13.378 22.83 15.737 24 20h-4.257c-.915-2.853-3.193-5.06-6.206-5.36V20z" /></svg>
  ),
  reddit: ({ ...props }: LucideProps) => (
    <svg data-name="Layer 1" xmlns="http://www.w3.org/2000/svg" viewBox="0 0 256 256"    {...props}  >    <path d="M128 0C57.31 0 0 57.31 0 128c0 35.35 14.33 67.35 37.49 90.51l-24.38 24.38C8.27 247.73 11.7 256 18.54 256H128c70.69 0 128-57.31 128-128S198.69 0 128 0" style={{ fill: "#ff4500", strokeWidth: 0, }} />    <path d="M154.04 60.36c2.22 9.41 10.67 16.42 20.76 16.42 11.78 0 21.33-9.55 21.33-21.33s-9.55-21.33-21.33-21.33c-10.3 0-18.89 7.3-20.89 17.01-17.25 1.85-30.72 16.48-30.72 34.21v.11c-18.76.79-35.89 6.13-49.49 14.56a29.75 29.75 0 0 0-18.27-6.24c-16.51 0-29.89 13.38-29.89 29.89 0 11.98 7.04 22.3 17.21 27.07.99 34.7 38.8 62.61 85.31 62.61s84.37-27.94 85.31-62.67c10.09-4.8 17.07-15.09 17.07-27 0-16.51-13.38-29.89-29.89-29.89-6.85 0-13.16 2.31-18.2 6.19-13.72-8.49-31.04-13.83-49.99-14.54v-.08c0-12.7 9.44-23.24 21.68-24.97ZM72.5 142.63c.5-10.84 7.7-19.16 16.07-19.16s14.77 8.79 14.27 19.63-6.75 14.78-15.13 14.78S72 153.47 72.5 142.63m95.06-19.16c8.38 0 15.58 8.32 16.07 19.16.5 10.84-6.84 15.25-15.21 15.25s-14.63-3.93-15.13-14.78c-.5-10.84 5.89-19.63 14.27-19.63m-9.96 44.24c1.57.16 2.57 1.79 1.96 3.25-5.15 12.31-17.31 20.96-31.5 20.96s-26.34-8.65-31.5-20.96c-.61-1.46.39-3.09 1.96-3.25 9.2-.93 19.15-1.44 29.54-1.44s20.33.51 29.54 1.44" style={{ strokeWidth: 0, fill: "#fff", }} />  </svg>
  ),
  yandex: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 48 48" {...props}><linearGradient id="a" x1="13.239" x2="37.906" y1="1.907" y2="33.479" gradientUnits="userSpaceOnUse"><stop offset="0" stopColor="#f52537" /><stop offset=".293" stopColor="#f32536" /><stop offset=".465" stopColor="#ea2434" /><stop offset=".605" stopColor="#dc2231" /><stop offset=".729" stopColor="#c8202c" /><stop offset=".841" stopColor="#ae1e25" /><stop offset=".944" stopColor="#8f1a1d" /><stop offset="1" stopColor="#7a1818" /></linearGradient><path fill="url(#a)" d="M32 24h-7l8-18h7zm-5 12.689c0-4.168-.953-8.357-2.758-12.117L15 6H8l10.833 21.169A22.1 22.1 0 0 1 21 36.689V42h6z" /></svg>
  ),
  metamask: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" baseProfile="basic" viewBox="0 0 33.9 31.3" {...props}><path fill="#E17726" stroke="#E17726" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="M32.1.1 18.9 9.8l2.4-5.7z" /><path fill="#E27625" stroke="#E27625" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m1.8.1 13 9.8-2.3-5.8zM27.4 22.7 23.9 28l7.5 2.1 2.1-7.3zM.4 22.8l2.1 7.3L10 28l-3.5-5.3z" /><path fill="#E27625" stroke="#E27625" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m9.6 13.6-2.1 3.1 7.4.3-.2-8zM24.3 13.6 19.1 9l-.2 8.1 7.4-.3zM10 28l4.5-2.2-3.9-3zM19.4 25.8l4.5 2.2-.6-5.2z" /><path fill="#D5BFB2" stroke="#D5BFB2" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m23.9 28-4.5-2.2.4 2.9v1.2zM10 28l4.2 2v-1.2l.4-2.9z" /><path fill="#233447" stroke="#233447" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m14.2 20.9-3.7-1.1 2.6-1.2zM19.6 20.9l1.1-2.3 2.6 1.2z" /><path fill="#CC6228" stroke="#CC6228" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m10 28 .6-5.3-4.1.1zM23.2 22.7l.6 5.3 3.5-5.2zM26.4 16.8l-7.4.3.7 3.8 1.1-2.3 2.6 1.2zM10.5 19.8l2.6-1.2 1.1 2.3.7-3.8-7.4-.3z" /><path fill="#E27525" stroke="#E27525" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m7.5 16.8 3.1 6.1-.1-3zM23.4 19.8l-.1 3 3.1-6.1zM14.9 17.1l-.7 3.8.9 4.5.2-5.9zM18.9 17.1l-.4 2.4.2 5.9.9-4.5z" /><path fill="#F5841F" stroke="#F5841F" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m19.6 20.9-.9 4.5.6.4 3.9-3 .1-3zM10.5 19.8l.1 3 3.9 3 .6-.4-.9-4.5z" /><path fill="#C0AC9D" stroke="#C0AC9D" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="M19.7 30v-1.2l-.3-.3h-5l-.3.3V30L10 28l1.5 1.2 2.9 2h5.1l3-2 1.4-1.2z" /><path fill="#161616" stroke="#161616" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m19.4 25.8-.6-.4h-3.7l-.6.4-.4 2.9.3-.3h5l.3.3z" /><path fill="#763E1A" stroke="#763E1A" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m32.6 10.5 1.1-5.4-1.7-5-12.6 9.4 4.9 4.1 6.9 2 1.5-1.8-.7-.4 1.1-1-.8-.6 1.1-.8zM.1 5.1l1.1 5.4-.7.5 1.1.8-.8.6 1.1 1-.7.5 1.5 1.8 6.9-2 4.9-4.1L1.8.1z" /><path fill="#F5841F" stroke="#F5841F" strokeLinecap="round" strokeLinejoin="round" strokeWidth=".25" d="m31.2 15.6-6.9-2 2.1 3.1-3.1 6.1 4.1-.1h6.1zM9.6 13.6l-6.9 2-2.3 7.1h6.1l4.1.1-3.1-6.1zM18.9 17.1l.4-7.6 2-5.4h-8.9l2 5.4.4 7.6.2 2.4v5.9h3.7v-5.9z" /></svg>
  ),
  walletconnect: ({ ...props }: LucideProps) => (
    <svg xmlns="http://www.w3.org/2000/svg" width="100" height="100" viewBox="0 0 300 185" {...props}><path fill="#3B99FC" fillRule="nonzero" d="M61.439 36.256c48.91-47.888 128.212-47.888 177.123 0l5.886 5.764a6.04 6.04 0 0 1 0 8.67l-20.136 19.716a3.18 3.18 0 0 1-4.428 0l-8.101-7.931c-34.122-33.408-89.444-33.408-123.566 0l-8.675 8.494a3.18 3.18 0 0 1-4.428 0L54.978 51.253a6.04 6.04 0 0 1 0-8.67zM280.206 77.03l17.922 17.547a6.04 6.04 0 0 1 0 8.67l-80.81 79.122c-2.446 2.394-6.41 2.394-8.856 0l-57.354-56.155a1.59 1.59 0 0 0-2.214 0L91.54 182.37c-2.446 2.394-6.411 2.394-8.857 0L1.872 103.247a6.04 6.04 0 0 1 0-8.671l17.922-17.547c2.445-2.394 6.41-2.394 8.856 0l57.355 56.155a1.59 1.59 0 0 0 2.214 0L145.57 77.03c2.446-2.394 6.41-2.395 8.856 0l57.355 56.155a1.59 1.59 0 0 0 2.214 0L271.35 77.03c2.446-2.394 6.41-2.394 8.856 0" /></svg>
  ),
};
