<div align="center">
  <a href="https://eartho.io">
    <img src="https://github.com/eartho-group/media/blob/main/icon.png" alt="Eartho Logo" width="120">
  </a>
  <h1>Eartho Brand Guidelines</h1>
  <p>Welcome to the Eartho Brand Guidelines! This section will help you understand how to use Eartho's branding materials in your projects and ensure a consistent representation of our identity. As a developer integrating Eartho, these guidelines will provide you with creative assets and important rules to follow when presenting Eartho to your users. Whether you're embedding Eartho’s login functionality into your app, showcasing it on your website, or referencing it in any materials, this guide is for you.</p>
</div>

<h2>Table of Contents</h2>
<ol>
  <li><a href="#logo-usage">Logo Usage</a></li>
  <li><a href="#brand-colors">Brand Colors</a></li>
  <li><a href="#typography">Typography</a></li>
  <li><a href="#visual-style">Visual Style</a></li>
  <li><a href="#dos-and-donts">Do's and Don'ts</a></li>
  <li><a href="#examples-in-action">Examples in Action</a></li>
  <li><a href="#downloadable-assets">Downloadable Assets</a></li>
</ol>

<h2 id="logo-usage">Logo Usage</h2>
<p>Our logo is a key part of Eartho’s identity, and using it correctly helps maintain the trust and recognition we've built with our users.</p>

<h3>Primary Logo</h3>
<p><b>Full Logo</b>: Use this in most cases where Eartho’s login or service is mentioned.</p>
<img src="https://github.com/eartho-group/media/blob/main/eartho_cover_1.png" alt="Eartho Icon" width="250">
<p><b>Icon Only</b>: For smaller spaces or when the full logo is too large, use the icon version:</p>
<img src="https://github.com/eartho-group/media/blob/main/icon.png" alt="Eartho Logo" width="250">

<h3>Clear Space</h3>
<p>To maintain the logo’s impact and legibility, always ensure there’s enough padding around it. We recommend using at least the height of the “E” in "Eartho" as the clear space boundary around the logo.</p>

<h3>Minimum Size</h3>
<p>For digital media, the minimum size of the full logo should be no smaller than 120px wide to ensure legibility.</p>

<h2 id="brand-colors">Brand Colors</h2>
<p>Consistency is key when using our brand colors. Please use the following colors to keep Eartho’s look unified across all touchpoints.</p>
<ul>
  <li><b>White</b>: #ffffff - Applied as a background or text color.</li>
  <li><b>Black</b>: #000000 - Applied as a background or text color.</li>
  <li><b>Orange</b>: #ff6700 - Highlighting emphasis areas, such as banners or calls to action.</li>
  <li><b>Light Grey</b>: #d9d9d9 - Used for text hover or big background</li>
</ul>


<h2 id="typography">Typography</h2>
<p>We use simple, modern fonts to create a clean and accessible user experience. When displaying Eartho in your applications or websites, please follow these font guidelines.</p>

<h3>Primary Font:</h3>
<ul>
  <li><b>Font Family</b>: <a href="https://vercel.com/font">Geist</a> - This is our main typeface, balancing readability and modern design.</li>
  <li><b>Weights</b>:
    <ul>
      <li>Regular (400) for body text</li>
      <li>Medium (500) for subheadings</li>
      <li>Bold (700) for headings</li>
    </ul>
  </li>
</ul>

<h3>Font Sizes:</h3>
<ul>
  <li><b>Headings</b>: 32px (H1), 28px (H2), 24px (H3)</li>
  <li><b>Body Text</b>: 16px</li>
</ul>

<h2 id="visual-style">Visual Style</h2>
<p>The visual style of Eartho is simple, clean, and user-centric. We prioritize clarity and ease of use, both in our branding and our product interfaces.</p>

<h3>Guidelines:</h3>
<ul>
  <li>Use <b>minimal design</b> principles—lots of white space and clean lines.</li>
  <li>Focus on <b>ease of navigation</b> when incorporating Eartho into login flows.</li>
  <li>Keep visual elements <b>modern</b> but not overwhelming. Eartho should blend seamlessly with your design while standing out as a trusted login provider.</li>
</ul>

<h2 id="dos-and-donts">Do's and Don'ts</h2>

<h3>Do's</h3>
<ul>
  <li><b>Use Eartho’s logo in a prominent position</b>: Place it near the login buttons, allowing users to recognize the brand instantly.</li>
  <li><b>Maintain contrast</b>: Ensure the logo is always clearly visible by using it on contrasting backgrounds.</li>
  <li><b>Use official brand colors</b>: When creating custom buttons or actions, always use our official colors to align with the Eartho identity.</li>
</ul>

<h3>Don'ts</h3>
<ul>
  <li><b>Alter the logo</b>: Avoid changing colors, stretching, or modifying the logo in any way.</li>
  <li><b>Crowd the logo</b>: Always maintain enough space around it to prevent clutter.</li>
  <li><b>Use off-brand colors</b>: Stick to Eartho’s primary color palette to ensure consistency.</li>
</ul>

<h2 id="examples-in-action">Examples in Action</h2>
<p>Here are some examples of how Eartho can be incorporated into your login flows or applications:</p>

<h3>Web App Integration:</h3>
<pre><code>&lt;button style="background-color: #1976D2; color: #fff; padding: 10px 20px;"&gt;
  &lt;img src="https://github.com/eartho-group/media/blob/main/icon.png" alt="Eartho Icon" width="20px"&gt;
  Sign in with Eartho
&lt;/button&gt;
</code></pre>

<h3>Mobile App Integration:</h3>
<p>- Use the icon version for buttons or login screens where space is limited.</p>
<p>- Incorporate Eartho icons into the user interface to signal secure actions or privacy.</p>

<h2 id="downloadable-assets">Buttons Example</h2>
<p>
https://html-preview.github.io/?url=https://github.com/eartho-group/eartho/blob/main/brand/buttons-example.html
</p>

<h2 id="downloadable-assets">Downloadable Assets</h2>
<p>You can download all of our official branding assets for your use directly from our repository.</p>
<ul>
  <li><a href="https://github.com/eartho-group/media">Download Logos</a></li>
  <li><a href="https://github.com/eartho-group/media">Download Icons</a></li>
  <li><a href="https://vercel.com/font">Download Fonts</a></li>
</ul>

<p>Thank you for keeping Eartho’s brand consistent and recognizable. If you have any questions or need further assets, feel free to <a href="mailto:contact@eartho.io">contact us</a> or <a href="https://discord.gg/5QbuTNTG2q">join our Discord</a> for support!</p>
