<div align="center">
  <a href="https://eartho.io">
    <img src="https://github.com/eartho-group/media/blob/main/eartho_cover_1.png" alt="Logo">
  </a>


---

Please note: We take Eartho's security and our users' trust very seriously. If you believe you have found a security issue in Eartho, please responsibly disclose by contacting us at contact@eartho.io

---
  
  <h1>The Open-Source, <br /> Privacy-Focused Alternative to Google Sign-In <br/> (In Construction, Join Us)</h1>
  <p>
    <b>Eartho</b> is an open-source sign-in alternative for users that prioritizes convenience & user privacy.<br />
    It offers a flexible, secure, and privacy-first alternative to traditional login providers like Google Sign-In, Apple, or Facebook.<br />
    Eartho ensures that users' personal data stays protected from Big Tech tracking, while developers benefit from a simple, easy-to-integrate solution.<br />
  </p>
</div>


<h3 align="center">
  <a href="https://eartho.io">Website</a>
  | <a href="https://myaccount.eartho.io">Open Eartho Account</a>
  | <a href="https://console.eartho.io">Developers Dasboard</a>
  | <a href="https://www.eartho.io/developers/demo/login-oauth">Demo</a>
  | <a href="https://discord.gg/5QbuTNTG2q">Our Discord</a>
  | <a href="contact@eartho.io">Our Email</a>  
</h3>

<div align="center">
  <b>🌟 Please give us a star to help us continue and grow! 🌟</b>
</div>

<br /><br />

<table align="center" border="1" cellpadding="10">
  <tr>
    <th align="center">Name</th>
    <td align="center"><b>Auth0</b></td>
    <td align="center"><b>Clerk</b></td>
      <td align="center"><b>Stack-Auth</b></td>
</tr>
  <tr>
    <th align="center">Image</th>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/example_auth0.png" alt="Auth0 Logo" width="200" />
    </td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/example_clerk_1.png" alt="Clerk Logo" width="200" />
    </td>
    <td align="center">
      <img src="https://github.com/earthodev/media/blob/main/example_stack.png" alt="Stack Logo" width="200" />
    </td>
  </tr>
  <tr>
    <th align="center">Name</th>
    <td align="center"><b>Supabase</b></td>
    <td align="center"><b>Firebase</b></td>
  </tr>
  <tr>
    <th align="center">Image</th>
    <td align="center">
      <img src="https://github.com/earthodev/media/blob/main/example_supabase_firebase.png" alt="Supabase Logo" width="200" />
    </td>
    <td align="center">
      <img src="https://github.com/earthodev/media/blob/main/example_supabase_firebase.png" alt="Firenase Logo" width="200" />
    </td>
  </tr>
</table>


<br />

<div>
<div align="">
  <h2>Current Challenges in User Access</h2>
</div>

<ul>
  <li><strong>Long-Term Data Ownership:</strong> 
    Using major platforms for login often means surrendering control of your data indefinitely. Users want clarity on who owns their data and how it’s stored and managed over time.
  </li>
  
  <li><strong>Fragmented Digital Identities:</strong> 
    With accounts scattered across platforms like Google, Facebook, LinkedIn, and more, managing logins becomes complex. People need a unified, secure way to access apps without losing track of their identities.
  </li>
  
  <li><strong>I don’t want to be forced to share my real identity:</strong> 
    Some users prefer to log in with minimal details, without needing to disclose personal information like email, phone number, or full name.
  </li>
  
  <li><strong>What happens to my accounts when I die?</strong> 
    Many are concerned about the future of their digital identity. They want clear control over how their accounts are managed if they’re no longer around, protecting their digital legacy.
  </li>
</ul>

</div>

<br />

## Roadmap


**Ready and Available** ✅

- **Multi-Provider Authentication**: Log in via Google, Facebook, Apple, GitHub, MetaMask, and more.
- **Zero Tracking**: No data tracking—user information remains private.
- **Two-Factor Authentication (2FA)**: Secure logins with SMS, email, or authenticator apps.
- **Recent Activity Review**: Monitor and review account activity for unauthorized access.
- **Self-Managed Login History**: View, download, or delete login history to monitor and manage account access.
- **Seamless Developer Integration**: Quick setup with minimal code for easy logins.

**In Progress** 🚧

- **End-to-End Encryption**: Encrypt user data for enhanced security.
- **Trusted Devices Management**: Manage devices connected to your account.
- **Session Management**: Remotely log out from unrecognized devices.
- **Security Alerts**: Get real-time alerts for suspicious activity.
- **Advanced Antifraud System**: Detect and prevent fraudulent logins.
- **Privacy Checkup**: Review and adjust privacy settings.
- **Data from Connected Apps**: Manage permissions for apps connected to your account.
- **Plan Your Digital Legacy**: Set up account management for when you can no longer access it.
- **Autofill Support**: Autofill passwords and payment info for faster logins.
- **Eartho Pay**: Integrate payments securely alongside authentication.
- **Customizable UI**: Tailor Eartho’s login widget to fit your brand.
- **Biometric Authentication**: Fingerprint and facial recognition for secure access.
- **Anonymous Login**: Protect identities with anonymous access.
- **Advanced Analytics Dashboard**: Gain insights into account activity and data usage.
- **Granular Privacy Controls**: Set specific data permissions for apps.
- **Multi-Account Management**: Easily switch between multiple accounts.
- **Enhanced Offline Access**: Authenticate even without internet connectivity.

**Future**

- **Browser Extension**: Autofill, and more.
- **Eartho One Tap**: Users are prompted to create an account with a dialog that's inline with your app's content, so they're never taken out of context by a sign-up screen.

<br />

## How It Works

Eartho serves as a privacy-focused layer between users and major authentication providers like Google, Facebook, and others. When users log in using Eartho, they can still choose popular sign-in options such as **Google Sign-In** or **Facebook Login**, but with a critical difference: **Big Tech companies will no longer have access to your users’ login services list**.

By wrapping major sign-in services, Eartho provides the best of both worlds: the convenience of popular authentication providers and the security of true privacy for users, ensuring that no personal data leaks to third-party companies.

<br /> <br />
<div align="center">
<a href="https://eartho.io">
    <img src="https://github.com/eartho-group/media/blob/main/eartho_shield_illustration_white.svg" alt="Logo">
  </a>
</div>

<br /><br />

## Table of Contents
1. [Features](#features)
2. [Why Eartho?](#why-eartho)
3. [Authentication Methods Supported](#authentication-methods-supported)
4. [Contributing](#contributing)
5. [Community & Support](#community--support)
6. [License](#license)
7. [FAQ](#faq)


<br />

## Web App - Features

<table>
  <tr>
    <th>Feature</th>
    <th>Description</th>
    <th>Image</th>
  </tr>
  <tr>
    <td><b>Privacy-Focused</b></td>
    <td>Your personal data is yours alone. With Eartho, your information stays private—no tracking, no sharing.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/readme/feature_3.png" alt="Privacy Icon" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Manage Multiple Identities</b></td>
    <td>Easily link and manage multiple accounts, from social media to crypto wallets, all in one place.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/readme/feature_1.png" alt="Easy Integration" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Manage Multiple Spaces Of Services</b></td>
    <td>Build a space for access to your work, build a space for access to your personal life, and build a space for your hidden services and protect them with an extra password</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/readme/feature_10.png" alt="Multi-Space" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Privacy-Based Access Levels</b></td>
    <td>Allow users to create multiple access levels within their accounts, choosing exactly what each app or platform can access. For instance, users could grant “basic,” “enhanced,” or “restricted” access, tailoring permissions on a granular level.

</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/readme/feature_10.png" alt="" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Digital Identity Vault for Sensitive Information</b></td>
    <td>Create a secure digital vault where users can store sensitive identity documents (e.g., ID scans, certificates) and share them selectively with apps that require identity verification.
    </td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/readme/feature_10.png" alt="" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Security Checkups</b></td>
    <td>Regularly check your account security and protect yourself from threats across all your linked accounts.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/readme/feature_2.png" alt="Multi-Provider Login" width="250">
    </td>
  </tr>
  <tr>
    <td><b>End-to-End Encryption</b></td>
    <td>Your data is fully encrypted, meaning only you can access it—no one else, not even us.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/readme/feature_4.png" alt="Encryption" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Autofill Support</b></td>
    <td>Save time by letting Eartho autofill your passwords and payment details safely across all your devices.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/autofill.png" alt="Autofill" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Built-in Payment System</b></td>
    <td>Pay securely through Eartho’s built-in payment system, keeping your financial details private.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/payment_system.png" alt="Payment System" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Proactive Security Alerts</b></td>
    <td>Get instant notifications if anything suspicious happens with your account, so you can take action quickly.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/security_alerts.png" alt="Security Alerts" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Zero Trust Architecture</b></td>
    <td>Eartho treats every action as potentially risky and verifies everything to keep your account secure.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/zero_trust.png" alt="Zero Trust" width="250">
    </td>
  </tr>
  <tr>
    <td><b>Open Source</b></td>
    <td>Eartho is built with transparency. You can trust how it works because the code is available for anyone to review.</td>
    <td align="center">
      <img src="https://github.com/eartho-group/media/blob/main/open_source.png" alt="Open Source" width="250">
    </td>
  </tr>
</table>

<br />

## Why Eartho?

In today’s digital age, privacy is paramount. Most single sign-on (SSO) providers collect data from users and track their online activity. **Eartho** solves this problem by offering a sign-in solution that ensures users’ privacy remains intact.

Developers can integrate Eartho with a few lines of code and provide users with:
- Secure login options
- Control over what data they share and with whom
- A unified account management system with multiple login methods
- Protection from Big Tech tracking and surveillance

Eartho is built for developers who care about privacy and security, but don't want to compromise on ease of use.

## **Tech Stack** ⚙️

Account Module:
- Next.js
- NextAuth(Auth.js)
- Oidc-Provider(Panva)

MyAccount Module:
- Next.js
- NextAuth(Auth.js) - Use Account Module as provider

Developers Module:
- Next.js
- NextAuth(Auth.js) - Use Account Module as provider

Infra:
- Database: Google Cloud Databases(Should be replaced)
- Cloud: Google Cloud Platform (GCP)


## **Developer? Add Eartho to Your App**

Enhance your app’s authentication with Eartho. It provides a **privacy-first login** experience that integrates easily into your existing system. With Eartho, you can offer users the convenience of popular sign-in options like **Google, Facebook, Apple**, and more—without compromising their privacy. We ensure that **Big Tech companies can’t track your users** or use their data against you.

### **Why Add Eartho?**
- **Privacy-First Authentication**: Eartho acts as a layer of protection between your users and Big Tech, preventing data tracking while still allowing users to log in with familiar providers.
- **Multiple Authentication Options**: Give your users the freedom to log in with **Google, Facebook, Apple**, **GitHub**, or even **MetaMask**—while keeping their data private.
- **Easy Integration**: Eartho simplifies the development process for login, sign-up, and profile management pages. With just one line of code, you can integrate Eartho seamlessly into your app.
- **No Migration Needed**: Continue using existing authentication providers without the need to migrate users or disrupt their experience. Eartho enhances privacy while keeping everything intact.
- **Advanced Security Features**: Eartho comes with an **advanced antifraud system**, using on-device machine learning to verify user authenticity and prevent fraud.


<h2>How to Add Eartho Authentication</h2>

<p>Eartho offers two primary methods for integrating secure, privacy-first authentication into your application: via the OIDC Provider or by using the Eartho SDK. Choose the option that best fits your setup and requirements.</p>

<h2>Option 1: Using Eartho OIDC Provider</h2>

<p>If your application already supports OpenID Connect (OIDC), integrating Eartho as an OIDC provider is a flexible, secure, and standards-compliant choice. This method is highly compatible with popular libraries and frameworks, making it easy to add Eartho to existing setups.</p>

<h3>Integration with Popular OIDC Libraries</h3>

<p>Using Eartho’s OIDC endpoints, you can seamlessly integrate with many popular libraries and frameworks, including:</p>

<ul>
  <li><strong>Auth.js</strong> - A versatile library for OAuth and OIDC providers.</li>
  <li><strong>Keycloak</strong> - Open-source identity management, supporting SSO with Eartho.</li>
  <li><strong>Auth0</strong> - Universal authentication platform, configurable with Eartho as an OIDC provider.</li>
  <li><strong>Passport.js</strong> - Middleware for Node.js supporting custom OIDC strategies like Eartho.</li>
  <li><strong>Okta</strong> - Enterprise identity and access management platform with support for custom OIDC providers.</li>
  <li><strong>Firebase Auth</strong> - Firebase's authentication service that can be configured to accept tokens from Eartho.</li>
  <li><strong>Clerk</strong> - User management and authentication solution, compatible with custom OIDC providers like Eartho.</li>
  <li><strong>SuperTokens</strong> - Open-source authentication library that supports integration with custom OIDC providers.</li>
  <li><strong>Supabase</strong> - Open-source Firebase alternative with authentication that can be integrated with Eartho’s OIDC for added flexibility.</li>
  <li><strong>StackAuth</strong> - A secure authentication solution that supports multiple providers, configurable with Eartho’s OIDC.</li>
</ul>

<h3>Configuration</h3>

<ol>
  <li><strong>Set the Issuer</strong>  
    <p>Configure Eartho as your OIDC provider by setting the <code>issuer</code> and <code>wellKnown</code> fields. This allows your app to retrieve Eartho’s OIDC configuration.</p>
    <pre><code>issuer: "https://account.eartho.io"
wellKnown: "https://account.eartho.io/.well-known/openid-configuration"</code></pre>
  </li>
  <li><strong>Redirect URI Setup</strong>  
    <p>Ensure your Eartho application is configured to recognize your app’s redirect URI, where Eartho will return authorization codes or tokens after authentication.</p>
  </li>
  <li><strong>Benefits of OIDC Integration</strong>  
    <ul>
      <li><strong>Standardized Protocol:</strong> Provides a robust, industry-standard authentication approach.</li>
      <li><strong>Enhanced Security:</strong> Leveraging Eartho’s secure OIDC flow minimizes unauthorized access.</li>
      <li><strong>Compatibility:</strong> Integrates with other OIDC-compatible identity providers and authentication systems.</li>
    </ul>
  </li>
</ol>

## Authentication Methods Supported

Eartho supports a wide range of authentication methods, allowing users to log in using their preferred provider while ensuring their privacy is maintained. Below are the supported authentication methods that users can choose from:

### **Popular Authentication Providers:**
- **Google**: Log in with your Google account for seamless access.
- **Apple**: Use your Apple ID for secure and private authentication.
- **Facebook**: Sign in through Facebook while keeping your data private from Big Tech.
- **Twitter (X)**: Authenticate with your Twitter (X) account and remain protected.
- **GitHub**: Ideal for developers logging in with their GitHub accounts.

### **Additional Methods:**
- **Email**: Secure login via one-time password (OTP) sent to your email.
- **SMS**: Authenticate using a code sent directly to your phone via SMS.
- **VK**: Support for VK, a popular platform in Eastern Europe and Russia.
- **Reddit**: Login via Reddit for users active on the platform.
- **Yandex**: A secure login option through Yandex.
- **MetaMask**: For crypto enthusiasts, log in using your MetaMask wallet.
<div align="center">
<a href="https://eartho.io">
    <img src="https://github.com/eartho-group/media/blob/main/authentication_methods.png" height="264" width="264" alt="Logo">
  </a>
</div>
<br />

<h2>How It Works:</h2>
Eartho wraps these providers, acting as a privacy layer, which means your login process goes through Eartho. This ensures that while the authentication provider can verify your credentials, they don't gain access to your app activity or personal information—keeping your data safe and secure.

<h3>Eartho Architecture</h3>

<p>Eartho's system is organized into three main services, each with a unique purpose:</p>

<h4>1. Account Service</h4>
<ul>
  <li>Users log in through existing accounts (Google, Facebook, etc.) using <strong>OAuth2</strong>.</li>
  <li>Eartho then acts as an <strong>OIDC provider</strong>, offering a unified, privacy-focused login across supported apps without sharing data back to these providers.</li>
</ul>

<h4>2. MyAccount Service</h4>
<ul>
  <li>Allows users to manage their data, privacy settings, and linked accounts.</li>
  <li>Users have control over data storage, can view login history, and adjust privacy preferences.</li>
</ul>

<h4>3. Developer Service</h4>
<ul>
  <li>For developers to register their apps and integrate Eartho as a login option.</li>
  <li>Provides all setup details for easy app integration.</li>
</ul>

<p>This structure keeps each service focused: <strong>Account Service</strong> for user login, <strong>MyAccount Service</strong> for data control, and <strong>Developer Service</strong> for app integration.</p>


<br /> <br />
<div align="center">
<a href="https://eartho.io">
    <img src="https://github.com/earthodev/media/blob/main/illustration_eartho_infrastrucre.png" height="500" alt="Logo">
  </a>
</div>

<h2>Contributing</h2>
<p>
  We welcome contributions from the open-source community! If you'd like to contribute to Eartho, please follow these steps:
</p>

<h3>Fork & PR</h3>
<ol>
  <li><strong>Fork the repository</strong> on GitHub.</li>
  <li><strong>Create a new branch</strong> for your feature or fix: <br>
    <code>git checkout -b feature/your-feature-name</code>
  </li>
  <li><strong>Make your changes</strong> and commit them with a meaningful message: <br>
    <code>git commit -m "Add your feature or fix description"</code>
  </li>
  <li><strong>Push to your fork</strong>: <br>
    <code>git push origin feature/your-feature-name</code>
  </li>
  <li><strong>Create a pull request</strong> from your branch into the main repository.</li>
</ol>
<p>
  We also encourage you to review our 
  <a href="link_to_contributing_guide">Contributing Guide</a> before submitting a pull request. 
  Contributions can range from code improvements, documentation updates, or even bug reports. Every contribution helps make Eartho better for everyone!
</p>

<h3>Installation</h3>

Instructions Per Package

<h3>Configuration</h3>

Instructions Per Package

<h2>Community & Support</h2>
<p>
  Join our vibrant community of developers and privacy advocates who are helping to shape the future of Eartho! Here’s how you can get involved:
</p>
<ul>
  <li><strong>Discord</strong>: Join our <a href="https://discord.gg/5QbuTNTG2q">Discord community</a> for real-time discussions, support, and collaboration with other developers.</li>
  <li><strong>GitHub Discussions</strong>: Start or join a conversation in our <a href="https://github.com/eartho-group/eartho-packages/pulls">GitHub Discussions</a> to get help or suggest new features.</li>
  <li><strong>Our Website</strong>: Follow us on <a href="https://eartho.io">Eartho</a> for updates, news, and announcements.</li>
</ul>

<h2>License</h2>
<p>
 Each package is licensed individually.

 Server components are licensed under the AGPLv3, while client libraries and examples are provided under custom license license. 
 For detailed information, please refer to the LICENSE files in each package.
</p>


Portions of this code are derived from projects licensed with MIT(Check LICENSE file to see the full license).
Here are the copyrights and the license type:

- MIT License, Copyright (c) 2018 Auth0, Inc. <support@auth0.com> (http://auth0.com)
- MIT License, Copyright (c) 2020-present Cryptr
- MIT License, Copyright (c) 2020 Ville de Montréal
- ISC License, Copyright (c) 2022-2024, Balázs Orbán (Auth.js)
- MIT License, Copyright (c) 2018 Filip Skokan - Jose
- MIT License,  Copyright (c) 2015 Filip Skokan https://github.com/panva/node-oidc-provider/blob/main/LICENSE.md

<h2>Frequently Asked Questions (FAQ)</h2>

<h3>Why should I trust you?</h3>

<p>We're committed to being as transparent as possible. We use well-established, widely adopted open-source libraries that have been trusted by millions of developers. Our team has years of experience in the industry, and we’re dedicated to building a platform that puts users' privacy and security first.</p>

<p>We understand this is a new project, and we’re constantly improving. Our code is open for anyone to review, contribute to, or suggest improvements. While it’s early days for Eartho, our goal is to continually evolve and provide a safe, privacy-first solution for managing digital access.</p>

<p><strong>Disclaimer</strong>: As this is a growing project, we’re always open to feedback and making things better over time.</p>

<h3>Who is behind Eartho?</h3>

<p>Hey! I'm Dvir Daniel, the creator of Eartho. I've been working in the IT industry for almost 10 years as a software engineer. Eartho started as my personal project with the goal to offer a privacy-first, open-source alternative to Google Sign-In. Right now, it's just me and a few friends helping out here and there. It's still early days for the project, but we’re improving it step by step and being as transparent as possible. Excited to have you join us on this journey!</p>

<h3>How is Eartho different from other authentication services like Auth0 or Keycloak?</h3>

<p>Eartho is designed with the user in mind, and not for developers, offering features like multiple identities, privacy-first payments, and the ability to plan your digital legacy. Unlike developer-focused tools, Eartho provides users with control over their access and personal data.</p>

<p>Developers add us as sign in option to their existing solution and they can can manage their users in Keycloak if they want. we are like Google/Facebook/Apple sign in</p>

<h3>Why should I trust Eartho with my data over Big Tech like Google/Facebook/Apple ?</h3>

Big Tech may collect data as part of their larger ecosystem, but for Eartho, access and privacy are our mission. While for them it's just another piece of the puzzle, for us, it’s the focus. We’re committed to being more convenient and advanced when it comes to managing access, giving you full control over your data and logins. Being open-source means transparency, and with Eartho, you always know where your information is and how it's used.







