﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Diagnostics;
using TailspinSpyworks.Data_Access;

namespace TailspinSpyworks
{
    public partial class ReviewAdd : System.Web.UI.Page
    {
        //------------------------------------------------------------------------------------------------------------------------------------------+
protected void Page_Load(object sender, EventArgs e)
{
    if (!String.IsNullOrEmpty(Request.QueryString["ProductID"]))//获取查询字符串的值
        {
        int  productID = 0;
        //得到ProductId的整型表示
        Int32.TryParse(Request["productID"].ToString(), out productID);
        using (CommerceEntities db = new CommerceEntities())  //实例化ObjectContext派生类
            {
                try
                {                                             //使用LINQ查询指定商品Id的首个返回值
                    var thisProduct = 
                        (from p in db.Products where p.ProductID
                                == productID select p).FirstOrDefault();
                    ModelName.Text = thisProduct.ModelName;  //设置商品名称Label控件的文本值
                }
                catch (Exception exp)
                {
                    throw new Exception("错误: 不能添加产品 - "
                        + exp.Message.ToString(), exp);      //显示异常信息
                }
            }
        }
    else
        {
        Debug.Fail("错误 : 无ProductId不能添加评论.");        //添加调试信息
        throw new Exception("错误 : 没有特定的ProductId是无法添加商品评论的.");
        }
}

        //------------------------------------------------------------------------------------------------------------------------------------------+
        protected void ReviewAddBtn_Click(object sender, ImageClickEventArgs e)
        {
            if (Page.IsValid == true)
            {
                // 从查询字符串中获取ProductId值
                int productID = Int32.Parse(Request["productID"]);
                // 得到在RadioButtonList选择的评级数字
                int rating = Int32.Parse(Rating.SelectedItem.Value);
                // 添加评论到数据库中，必须先使用HtmlEncode进行HTML编码
                using (CommerceEntities db = new CommerceEntities())
                {
                    try
                    {
                        Review newReview = new Review()    //实体化一个Review实体
                        {   //使用对象初始化语法设置实体对象的相关参数
                            ProductID = productID,   
                            Rating = rating,
                            CustomerName = HttpUtility.HtmlEncode(Name.Text),
                            CustomerEmail = HttpUtility.HtmlEncode(Email.Text),
                            Comments = HttpUtility.HtmlEncode(UserComment.Content)
                        };
                        db.Reviews.AddObject(newReview);  //添加到Reviews实体集合中
                        db.SaveChanges();                 //向数据库提交更改
                    }
                    catch (Exception exp)                 //异常处理
                    {
                        throw new Exception("错误: 不能添加产品评论- " 
                            + exp.Message.ToString(), exp);
                    }
                }
               //在添加完产品评论后，重定向到产品明细显示评论信息
               Response.Redirect("ProductDetails.aspx?ProductID=" + productID);
            }
          Response.Redirect("ProductList.aspx");         //如果页面验证失败，则重定向到产品列表
        }

        protected void LikeRating_Changed(object sender, AjaxControlToolkit.RatingEventArgs e)
        {

        }
    }
}