﻿using System;
using System.Collections.Specialized;
using System.Collections.Generic;
using System.Collections;
using System.Linq;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;

namespace TailspinSpyworks
{
    public partial class MyShoppingCart : System.Web.UI.Page
    {
        //------------------------------------------------------------------------------------------------------------------------------------------+
        protected void Page_Load(object sender, EventArgs e)
        {
            MyShoppingCart usersShoppingCart = new MyShoppingCart();
            String cartId = usersShoppingCart.GetShoppingCartId();
            decimal cartTotal = 0;
            cartTotal = usersShoppingCart.GetTotal(cartId);
            if (cartTotal > 0)
            {
                lblTotal.Text = String.Format("{0:c}", usersShoppingCart.GetTotal(cartId));
            }
            else
            {
                LabelTotalText.Text = "";
                lblTotal.Text = "";
                ShoppingCartTitle.InnerText = "当前购物车是空的";
                UpdateBtn.Visible = false;
                CheckoutBtn.Visible = false;
            }
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        protected void UpdateBtn_Click(object sender, ImageClickEventArgs e)
        {   //实例化购物车对象
            MyShoppingCart usersShoppingCart = new MyShoppingCart();
            String cartId = usersShoppingCart.GetShoppingCartId();   //得到当前购物车Id
            //定义ShoppingCartUpdates数组，数组长为GridView控件的行数
            ShoppingCartUpdates[] cartUpdates = new ShoppingCartUpdates[MyList.Rows.Count];
            for (int i = 0; i < MyList.Rows.Count; i++)   //循环遍历GridView行
            {
                IOrderedDictionary rowValues = new OrderedDictionary();  //实例化排序字段
                rowValues = GetValues(MyList.Rows[i]);                   //提取行值
                cartUpdates[i].ProductId =  Convert.ToInt32(rowValues["ProductID"]); //记录产品Id
                cartUpdates[i].PurchaseQantity = Convert.ToInt32(rowValues["Quantity"]);//数量 
                //判断移除复选框是否选中
                CheckBox cbRemove = new CheckBox();
                cbRemove = (CheckBox)MyList.Rows[i].FindControl("Remove");//得到移除复选框
                cartUpdates[i].RemoveItem = cbRemove.Checked;             //记录是否移除项
            }
            //使用MyShoppingCart提供的方法更新购物车
            usersShoppingCart.UpdateShoppingCartDatabase(cartId, cartUpdates);
            MyList.DataBind();                                           //进行数据绑定
            lblTotal.Text = String.Format("{0:c}", usersShoppingCart.GetTotal(cartId));
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public static IOrderedDictionary GetValues(GridViewRow row)
        {
            IOrderedDictionary values = new OrderedDictionary();//保存结果值
            foreach (DataControlFieldCell cell in row.Cells)    //遍历单元格
            {
                if (cell.Visible)                              //如果行值可见
                {
                    cell.ContainingField.                     //从单元格中提取值
                        ExtractValuesFromCell(values, cell, row.RowState, true);
                }
            }
            return values;                                   //返回行值字典
        }

        protected void CheckoutBtn_Click(object sender, ImageClickEventArgs e)
        {

        } 
    }
}