﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Web;
using TailspinSpyworks.Data_Access;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Web.Security;

//--------------------------------------------------------------------------------------------------------------------------------------------------+
// TODO: In a future version of this application we will seperate this logic into a seperate Business Objets Layer
//--------------------------------------------------------------------------------------------------------------------------------------------------+
namespace TailspinSpyworks
{
    public struct ShoppingCartUpdates
    {
        public int ProductId;         //产品Id
        public int PurchaseQantity;   //购买数量
        public bool RemoveItem;       //是否移除项
    }


    public partial class MyShoppingCart
    {
        public const string CartId = "TailSpinSpyWorks_CartID";
        public String GetShoppingCartId()  //获取购物车Id号
        {
            if (Session[CartId] == null)  //如果Id值为空
            {
                Session[CartId] = System.Web.HttpContext.
                    Current.Request.IsAuthenticated ? 
                    User.Identity.Name : 
                    Guid.NewGuid().ToString();  //得到购物车Id
            }
            return Session[CartId].ToString();  //返回购物车Id
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public decimal GetTotal(string cartID)
        {

            using (CommerceEntities db = new CommerceEntities())
            {
                decimal cartTotal = 0;
                try 
                {
                  var myCart = (from c in db.ViewCarts where c.CartID == cartID select c);
                  if (myCart.Count() > 0)
                  {
                      cartTotal = myCart.Sum(od => (decimal)od.Quantity * (decimal)od.UnitCost);
                  }
                }
                catch(Exception exp)
                {
                    throw new Exception("错误，不能计算订单合计 - " + exp.Message.ToString(), exp);
                }
            return (cartTotal);
            }
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public void RemoveItem(string cartID, int  productID)
        {
            using (CommerceEntities db = new CommerceEntities())
            {
                try
                {
                    var myItem = (from c in db.ShoppingCarts where 
                                      c.CartID == cartID && 
                                      c.ProductID == productID select c).FirstOrDefault();
                    if (myItem != null)
                    {
                        db.DeleteObject(myItem);
                        db.SaveChanges();
                    }

                }
                catch (Exception exp)
                {
                    throw new Exception("错误，不能移除购物车项- " + 
                        exp.Message.ToString(), exp);
                }
            }

        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public void UpdateItem(string cartID, int productID, int quantity)
        {
            using (CommerceEntities db = new CommerceEntities())
            {
                try
                {
                    var myItem = (from c in db.ShoppingCarts where 
                                  c.CartID == cartID && c.ProductID == productID 
                                  select c).FirstOrDefault();
                    if (myItem != null)
                    {
                        myItem.Quantity = quantity;
                        db.SaveChanges();
                    }
                }
                catch (Exception exp)
                {
                    throw new Exception("错误，不能更新购物车项- " 
                        + exp.Message.ToString(), exp);
                }
            }
    
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public void UpdateShoppingCartDatabase(String cartId, 
            ShoppingCartUpdates[] CartItemUpdates)
        {
            using (CommerceEntities db = new CommerceEntities())  //实例化上下文对象
            {
                try
                {
                   int CartItemCOunt = CartItemUpdates.Count();  //获取更改的总数量
                   var myCart = (from c in db.ViewCarts 
                                 where c.CartID == cartId select c);//查询购物车对象
                   foreach (var cartItem in myCart)             //遍历购物车中的产品
                   {
                       // 遍历购物车中所有的行
                       for (int i = 0; i < CartItemCOunt; i++)
                       {   //如果购物车的ProductID与更改后的ProductID一致
                           if (cartItem.ProductID == CartItemUpdates[i].ProductId)
                           {  //判断是否数量为0或者己经为标记为移除项
                               if (CartItemUpdates[i].PurchaseQantity < 1 || 
                                   CartItemUpdates[i].RemoveItem == true)
                              {   //从购物车中移除
                                  RemoveItem(cartId, cartItem.ProductID);
                              }
                           else 
                              {   //更新购物车项
                                  UpdateItem(cartId, cartItem.ProductID, 
                                      CartItemUpdates[i].PurchaseQantity);
                              }
                           }
                        }
                    }
                }
                catch (Exception exp)   //处理程序异常
                {
                    throw new Exception("错误，不能更新购物车数据库- " + 
                        exp.Message.ToString(), exp);
                }            
            }           
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public void AddItem(string cartID, int productID, int quantity)
        {
            using (CommerceEntities db = new CommerceEntities())  //实体化对象上下文
            {
                try 
                {   //查询指定的CartID和ProductID是否存在
                    var myItem = (from c in db.ShoppingCarts where 
                                  c.CartID == cartID && c.ProductID == productID 
                                  select c).FirstOrDefault();
                    if (myItem == null)                         //如果不存在
                    {   //创建一个新的购物车
                        ShoppingCart cartadd = new ShoppingCart();
                        cartadd.CartID = cartID;                //指定购物车Id
                        cartadd.Quantity = quantity;            //指定产品数量
                        cartadd.ProductID = productID;          //产品Id
                        cartadd.DateCreated = DateTime.Now;     //创建日期
                        db.ShoppingCarts.AddObject(cartadd);    //添加到购物车
                    }
                    else
                    {
                        myItem.Quantity += quantity;           //如果产品存在添加数量
                    }                   
                    db.SaveChanges();                          //提交更改
                }
                catch (Exception exp)
                {   //显示异常信息
                    throw new Exception("错误：不能添加商品到购物车- " 
                        + exp.Message.ToString(), exp);
                }
            }
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public bool SubmitOrder(string UserName)
        {
            using (CommerceEntities db = new CommerceEntities())
            {
                try
                {
                    Order newOrder = new Order();           //添加新单订
                    newOrder.CustomerName = UserName;       //指定订单客户名称
                    newOrder.OrderDate = DateTime.Now;      //订单创建日期
                    newOrder.ShipDate = CalculateShipDate();//计算出货日期
                    db.Orders.AddObject(newOrder);          //添加到实体集合
                    db.SaveChanges();                       //保存更改
                    String cartId = GetShoppingCartId();    //获取购物车Id
                    var myCart = (from c in db.ViewCarts    //得到购物车对象
                                  where c.CartID == cartId select c);
                    foreach (ViewCart item in myCart)       //循环遍历购物车
                    {
                        int i = 0;
                        if (i < 1)                          //添加购物车中的产品
                        {
                            OrderDetail od = new OrderDetail(); //实例化OrderDetail对象
                            od.OrderID = newOrder.OrderID;      //得到新订单的Id号
                            od.ProductID = item.ProductID;      //和得到产品ID号
                            od.Quantity = item.Quantity;        //得到产品数量
                            od.UnitCost = item.UnitCost;        //得到单价
                            db.OrderDetails.AddObject(od);      //添加到实体集合
                            i++;
                        }
                        //从购物车中查询指定购物车中的产品
                        var myItem = (from c in db.ShoppingCarts where 
                                          c.CartID == item.CartID && 
                                          c.ProductID == item.ProductID
                                          select c).FirstOrDefault();
                        if (myItem != null)
                        {
                            db.DeleteObject(myItem);           //从购物车中删除产品
                        }
                    }
                    db.SaveChanges();                          //保存数据库更改 
                }
                catch (Exception exp)                          //显示异常信息
                {
                    throw new Exception("错误：不能提交订单- " 
                        + exp.Message.ToString(), exp);
                }
            } 
            return(true);                                     //返回成功更新的布尔值
        }


        //------------------------------------------------------------------------------------------------------------------------------------------+
        DateTime CalculateShipDate()
        {
            DateTime shipDate = DateTime.Now.AddDays(2);
            return (shipDate);
        }

        //------------------------------------------------------------------------------------------------------------------------------------------+
        public void MigrateCart(String oldCartId, String UserName)
        {
            //实例化上下文
            using (CommerceEntities db = new CommerceEntities())   
            {
                try 
                {   //查询旧的购物车对象
                    var myShoppingCart = from cart in db.ShoppingCarts
                         where cart.CartID == oldCartId
                         select cart;
                    //通过循环更新购物车中的CartID
                    foreach (ShoppingCart item in myShoppingCart)
                    {
                        item.CartID = UserName;   //更新CartID为UserName             
                    }
                   db.SaveChanges();             //保存更改         
                   Session[CartId] = UserName;   //设置当前的CartID值
                }
                catch (Exception exp)
                {   //显示异常消息
                    throw new Exception("错误：不能迁移购物车- " 
                        + exp.Message.ToString(), exp);
                }
            }           
        }
    }
}